/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vector3f;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class EntityArmorStand
extends EntityLiving {
    public static final int WOBBLE_TIME = 5;
    private static final boolean ENABLE_ARMS = true;
    private static final Vector3f DEFAULT_HEAD_POSE = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final Vector3f DEFAULT_BODY_POSE = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final Vector3f DEFAULT_LEFT_ARM_POSE = new Vector3f(-10.0f, 0.0f, -10.0f);
    private static final Vector3f DEFAULT_RIGHT_ARM_POSE = new Vector3f(-15.0f, 0.0f, 10.0f);
    private static final Vector3f DEFAULT_LEFT_LEG_POSE = new Vector3f(-1.0f, 0.0f, -1.0f);
    private static final Vector3f DEFAULT_RIGHT_LEG_POSE = new Vector3f(1.0f, 0.0f, 1.0f);
    private static final EntitySize MARKER_DIMENSIONS = new EntitySize(0.0f, 0.0f, true);
    private static final EntitySize BABY_DIMENSIONS = EntityTypes.ARMOR_STAND.getDimensions().scale(0.5f);
    private static final double FEET_OFFSET = 0.1;
    private static final double CHEST_OFFSET = 0.9;
    private static final double LEGS_OFFSET = 0.4;
    private static final double HEAD_OFFSET = 1.6;
    public static final int DISABLE_TAKING_OFFSET = 8;
    public static final int DISABLE_PUTTING_OFFSET = 16;
    public static final int CLIENT_FLAG_SMALL = 1;
    public static final int CLIENT_FLAG_SHOW_ARMS = 4;
    public static final int CLIENT_FLAG_NO_BASEPLATE = 8;
    public static final int CLIENT_FLAG_MARKER = 16;
    public static final DataWatcherObject<Byte> DATA_CLIENT_FLAGS = DataWatcher.defineId(EntityArmorStand.class, DataWatcherRegistry.BYTE);
    public static final DataWatcherObject<Vector3f> DATA_HEAD_POSE = DataWatcher.defineId(EntityArmorStand.class, DataWatcherRegistry.ROTATIONS);
    public static final DataWatcherObject<Vector3f> DATA_BODY_POSE = DataWatcher.defineId(EntityArmorStand.class, DataWatcherRegistry.ROTATIONS);
    public static final DataWatcherObject<Vector3f> DATA_LEFT_ARM_POSE = DataWatcher.defineId(EntityArmorStand.class, DataWatcherRegistry.ROTATIONS);
    public static final DataWatcherObject<Vector3f> DATA_RIGHT_ARM_POSE = DataWatcher.defineId(EntityArmorStand.class, DataWatcherRegistry.ROTATIONS);
    public static final DataWatcherObject<Vector3f> DATA_LEFT_LEG_POSE = DataWatcher.defineId(EntityArmorStand.class, DataWatcherRegistry.ROTATIONS);
    public static final DataWatcherObject<Vector3f> DATA_RIGHT_LEG_POSE = DataWatcher.defineId(EntityArmorStand.class, DataWatcherRegistry.ROTATIONS);
    private static final Predicate<Entity> RIDABLE_MINECARTS = var0 -> var0 instanceof EntityMinecartAbstract && ((EntityMinecartAbstract)var0).getMinecartType() == EntityMinecartAbstract.EnumMinecartType.RIDEABLE;
    private final NonNullList<ItemStack> handItems = NonNullList.withSize(2, ItemStack.EMPTY);
    private final NonNullList<ItemStack> armorItems = NonNullList.withSize(4, ItemStack.EMPTY);
    private boolean invisible;
    public long lastHit;
    public int disabledSlots;
    public Vector3f headPose = DEFAULT_HEAD_POSE;
    public Vector3f bodyPose = DEFAULT_BODY_POSE;
    public Vector3f leftArmPose = DEFAULT_LEFT_ARM_POSE;
    public Vector3f rightArmPose = DEFAULT_RIGHT_ARM_POSE;
    public Vector3f leftLegPose = DEFAULT_LEFT_LEG_POSE;
    public Vector3f rightLegPose = DEFAULT_RIGHT_LEG_POSE;

    public EntityArmorStand(EntityTypes<? extends EntityArmorStand> var0, World var1) {
        super((EntityTypes<? extends EntityLiving>)var0, var1);
        this.maxUpStep = 0.0f;
    }

    public EntityArmorStand(World var0, double var1, double var3, double var5) {
        this((EntityTypes<? extends EntityArmorStand>)EntityTypes.ARMOR_STAND, var0);
        this.setPos(var1, var3, var5);
    }

    @Override
    public void refreshDimensions() {
        double var0 = this.getX();
        double var2 = this.getY();
        double var4 = this.getZ();
        super.refreshDimensions();
        this.setPos(var0, var2, var4);
    }

    private boolean hasPhysics() {
        return !this.isMarker() && !this.isNoGravity();
    }

    @Override
    public boolean isEffectiveAi() {
        return super.isEffectiveAi() && this.hasPhysics();
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(DATA_CLIENT_FLAGS, (byte)0);
        this.entityData.define(DATA_HEAD_POSE, DEFAULT_HEAD_POSE);
        this.entityData.define(DATA_BODY_POSE, DEFAULT_BODY_POSE);
        this.entityData.define(DATA_LEFT_ARM_POSE, DEFAULT_LEFT_ARM_POSE);
        this.entityData.define(DATA_RIGHT_ARM_POSE, DEFAULT_RIGHT_ARM_POSE);
        this.entityData.define(DATA_LEFT_LEG_POSE, DEFAULT_LEFT_LEG_POSE);
        this.entityData.define(DATA_RIGHT_LEG_POSE, DEFAULT_RIGHT_LEG_POSE);
    }

    @Override
    public Iterable<ItemStack> getHandSlots() {
        return this.handItems;
    }

    @Override
    public Iterable<ItemStack> getArmorSlots() {
        return this.armorItems;
    }

    @Override
    public ItemStack getItemBySlot(EnumItemSlot var0) {
        switch (var0.getType()) {
            case HAND: {
                return this.handItems.get(var0.getIndex());
            }
            case ARMOR: {
                return this.armorItems.get(var0.getIndex());
            }
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void setItemSlot(EnumItemSlot var0, ItemStack var1) {
        this.verifyEquippedItem(var1);
        switch (var0.getType()) {
            case HAND: {
                this.onEquipItem(var0, this.handItems.set(var0.getIndex(), var1), var1);
                break;
            }
            case ARMOR: {
                this.onEquipItem(var0, this.armorItems.set(var0.getIndex(), var1), var1);
            }
        }
    }

    @Override
    public boolean canTakeItem(ItemStack var0) {
        EnumItemSlot var1 = EntityInsentient.getEquipmentSlotForItem(var0);
        return this.getItemBySlot(var1).isEmpty() && !this.isDisabled(var1);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        NBTTagList var1 = new NBTTagList();
        for (ItemStack var3 : this.armorItems) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            if (!var3.isEmpty()) {
                var3.save(nBTTagCompound);
            }
            var1.add(nBTTagCompound);
        }
        var0.put("ArmorItems", var1);
        NBTTagList var2 = new NBTTagList();
        for (ItemStack itemStack : this.handItems) {
            NBTTagCompound var5 = new NBTTagCompound();
            if (!itemStack.isEmpty()) {
                itemStack.save(var5);
            }
            var2.add(var5);
        }
        var0.put("HandItems", var2);
        var0.putBoolean("Invisible", this.isInvisible());
        var0.putBoolean("Small", this.isSmall());
        var0.putBoolean("ShowArms", this.isShowArms());
        var0.putInt("DisabledSlots", this.disabledSlots);
        var0.putBoolean("NoBasePlate", this.isNoBasePlate());
        if (this.isMarker()) {
            var0.putBoolean("Marker", this.isMarker());
        }
        var0.put("Pose", this.writePose());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        int var2;
        NBTBase var1;
        super.readAdditionalSaveData(var0);
        if (var0.contains("ArmorItems", 9)) {
            var1 = var0.getList("ArmorItems", 10);
            for (var2 = 0; var2 < this.armorItems.size(); ++var2) {
                this.armorItems.set(var2, ItemStack.of(var1.getCompound(var2)));
            }
        }
        if (var0.contains("HandItems", 9)) {
            var1 = var0.getList("HandItems", 10);
            for (var2 = 0; var2 < this.handItems.size(); ++var2) {
                this.handItems.set(var2, ItemStack.of(var1.getCompound(var2)));
            }
        }
        this.setInvisible(var0.getBoolean("Invisible"));
        this.setSmall(var0.getBoolean("Small"));
        this.setShowArms(var0.getBoolean("ShowArms"));
        this.disabledSlots = var0.getInt("DisabledSlots");
        this.setNoBasePlate(var0.getBoolean("NoBasePlate"));
        this.setMarker(var0.getBoolean("Marker"));
        this.noPhysics = !this.hasPhysics();
        var1 = var0.getCompound("Pose");
        this.readPose((NBTTagCompound)var1);
    }

    private void readPose(NBTTagCompound var0) {
        NBTTagList var1 = var0.getList("Head", 5);
        this.setHeadPose(var1.isEmpty() ? DEFAULT_HEAD_POSE : new Vector3f(var1));
        NBTTagList var2 = var0.getList("Body", 5);
        this.setBodyPose(var2.isEmpty() ? DEFAULT_BODY_POSE : new Vector3f(var2));
        NBTTagList var3 = var0.getList("LeftArm", 5);
        this.setLeftArmPose(var3.isEmpty() ? DEFAULT_LEFT_ARM_POSE : new Vector3f(var3));
        NBTTagList var4 = var0.getList("RightArm", 5);
        this.setRightArmPose(var4.isEmpty() ? DEFAULT_RIGHT_ARM_POSE : new Vector3f(var4));
        NBTTagList var5 = var0.getList("LeftLeg", 5);
        this.setLeftLegPose(var5.isEmpty() ? DEFAULT_LEFT_LEG_POSE : new Vector3f(var5));
        NBTTagList var6 = var0.getList("RightLeg", 5);
        this.setRightLegPose(var6.isEmpty() ? DEFAULT_RIGHT_LEG_POSE : new Vector3f(var6));
    }

    private NBTTagCompound writePose() {
        NBTTagCompound var0 = new NBTTagCompound();
        if (!DEFAULT_HEAD_POSE.equals(this.headPose)) {
            var0.put("Head", this.headPose.save());
        }
        if (!DEFAULT_BODY_POSE.equals(this.bodyPose)) {
            var0.put("Body", this.bodyPose.save());
        }
        if (!DEFAULT_LEFT_ARM_POSE.equals(this.leftArmPose)) {
            var0.put("LeftArm", this.leftArmPose.save());
        }
        if (!DEFAULT_RIGHT_ARM_POSE.equals(this.rightArmPose)) {
            var0.put("RightArm", this.rightArmPose.save());
        }
        if (!DEFAULT_LEFT_LEG_POSE.equals(this.leftLegPose)) {
            var0.put("LeftLeg", this.leftLegPose.save());
        }
        if (!DEFAULT_RIGHT_LEG_POSE.equals(this.rightLegPose)) {
            var0.put("RightLeg", this.rightLegPose.save());
        }
        return var0;
    }

    @Override
    public boolean isPushable() {
        return false;
    }

    @Override
    protected void doPush(Entity var0) {
    }

    @Override
    protected void pushEntities() {
        List<Entity> var0 = this.level.getEntities(this, this.getBoundingBox(), RIDABLE_MINECARTS);
        for (int var1 = 0; var1 < var0.size(); ++var1) {
            Entity var2 = var0.get(var1);
            if (!(this.distanceToSqr(var2) <= 0.2)) continue;
            var2.push(this);
        }
    }

    @Override
    public EnumInteractionResult interactAt(EntityHuman var0, Vec3D var1, EnumHand var2) {
        ItemStack var3 = var0.getItemInHand(var2);
        if (this.isMarker() || var3.is(Items.NAME_TAG)) {
            return EnumInteractionResult.PASS;
        }
        if (var0.isSpectator()) {
            return EnumInteractionResult.SUCCESS;
        }
        if (var0.level.isClientSide) {
            return EnumInteractionResult.CONSUME;
        }
        EnumItemSlot var4 = EntityInsentient.getEquipmentSlotForItem(var3);
        if (var3.isEmpty()) {
            EnumItemSlot var6;
            EnumItemSlot var5 = this.getClickedSlot(var1);
            EnumItemSlot enumItemSlot = var6 = this.isDisabled(var5) ? var4 : var5;
            if (this.hasItemInSlot(var6) && this.swapItem(var0, var6, var3, var2)) {
                return EnumInteractionResult.SUCCESS;
            }
        } else {
            if (this.isDisabled(var4)) {
                return EnumInteractionResult.FAIL;
            }
            if (var4.getType() == EnumItemSlot.Function.HAND && !this.isShowArms()) {
                return EnumInteractionResult.FAIL;
            }
            if (this.swapItem(var0, var4, var3, var2)) {
                return EnumInteractionResult.SUCCESS;
            }
        }
        return EnumInteractionResult.PASS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EnumItemSlot getClickedSlot(Vec3D var0) {
        EnumItemSlot var1 = EnumItemSlot.MAINHAND;
        boolean var2 = this.isSmall();
        double var3 = var2 ? var0.y * 2.0 : var0.y;
        EnumItemSlot var5 = EnumItemSlot.FEET;
        if (var3 >= 0.1) {
            double d2 = var2 ? 0.8 : 0.45;
            if (var3 < 0.1 + d2 && this.hasItemInSlot(var5)) {
                return EnumItemSlot.FEET;
            }
        }
        double d3 = var2 ? 0.3 : 0.0;
        if (var3 >= 0.9 + d3) {
            double d4 = var2 ? 1.0 : 0.7;
            if (var3 < 0.9 + d4 && this.hasItemInSlot(EnumItemSlot.CHEST)) {
                return EnumItemSlot.CHEST;
            }
        }
        if (var3 >= 0.4) {
            double d5 = var2 ? 1.0 : 0.8;
            if (var3 < 0.4 + d5 && this.hasItemInSlot(EnumItemSlot.LEGS)) {
                return EnumItemSlot.LEGS;
            }
        }
        if (var3 >= 1.6 && this.hasItemInSlot(EnumItemSlot.HEAD)) {
            return EnumItemSlot.HEAD;
        }
        if (this.hasItemInSlot(EnumItemSlot.MAINHAND)) return var1;
        if (!this.hasItemInSlot(EnumItemSlot.OFFHAND)) return var1;
        return EnumItemSlot.OFFHAND;
    }

    private boolean isDisabled(EnumItemSlot var0) {
        return (this.disabledSlots & 1 << var0.getFilterFlag()) != 0 || var0.getType() == EnumItemSlot.Function.HAND && !this.isShowArms();
    }

    private boolean swapItem(EntityHuman var0, EnumItemSlot var1, ItemStack var2, EnumHand var3) {
        ItemStack var4 = this.getItemBySlot(var1);
        if (!var4.isEmpty() && (this.disabledSlots & 1 << var1.getFilterFlag() + 8) != 0) {
            return false;
        }
        if (var4.isEmpty() && (this.disabledSlots & 1 << var1.getFilterFlag() + 16) != 0) {
            return false;
        }
        if (var0.getAbilities().instabuild && var4.isEmpty() && !var2.isEmpty()) {
            ItemStack var5 = var2.copy();
            var5.setCount(1);
            this.setItemSlot(var1, var5);
            return true;
        }
        if (!var2.isEmpty() && var2.getCount() > 1) {
            if (!var4.isEmpty()) {
                return false;
            }
            ItemStack var5 = var2.copy();
            var5.setCount(1);
            this.setItemSlot(var1, var5);
            var2.shrink(1);
            return true;
        }
        this.setItemSlot(var1, var2);
        var0.setItemInHand(var3, var4);
        return true;
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        if (this.level.isClientSide || this.isRemoved()) {
            return false;
        }
        if (DamageSource.OUT_OF_WORLD.equals(var0)) {
            this.kill();
            return false;
        }
        if (this.isInvulnerableTo(var0) || this.invisible || this.isMarker()) {
            return false;
        }
        if (var0.isExplosion()) {
            this.brokenByAnything(var0);
            this.kill();
            return false;
        }
        if (DamageSource.IN_FIRE.equals(var0)) {
            if (this.isOnFire()) {
                this.causeDamage(var0, 0.15f);
            } else {
                this.setSecondsOnFire(5);
            }
            return false;
        }
        if (DamageSource.ON_FIRE.equals(var0) && this.getHealth() > 0.5f) {
            this.causeDamage(var0, 4.0f);
            return false;
        }
        boolean var2 = var0.getDirectEntity() instanceof EntityArrow;
        boolean var3 = var2 && ((EntityArrow)var0.getDirectEntity()).getPierceLevel() > 0;
        boolean var4 = "player".equals(var0.getMsgId());
        if (!var4 && !var2) {
            return false;
        }
        if (var0.getEntity() instanceof EntityHuman && !((EntityHuman)var0.getEntity()).getAbilities().mayBuild) {
            return false;
        }
        if (var0.isCreativePlayer()) {
            this.playBrokenSound();
            this.showBreakingParticles();
            this.kill();
            return var3;
        }
        long var5 = this.level.getGameTime();
        if (var5 - this.lastHit <= 5L || var2) {
            this.brokenByPlayer(var0);
            this.showBreakingParticles();
            this.kill();
        } else {
            this.level.broadcastEntityEvent(this, (byte)32);
            this.gameEvent(GameEvent.ENTITY_DAMAGE, var0.getEntity());
            this.lastHit = var5;
        }
        return true;
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 32) {
            if (this.level.isClientSide) {
                this.level.playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEffects.ARMOR_STAND_HIT, this.getSoundSource(), 0.3f, 1.0f, false);
                this.lastHit = this.level.getGameTime();
            }
        } else {
            super.handleEntityEvent(var0);
        }
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double var0) {
        double var2 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(var2) || var2 == 0.0) {
            var2 = 4.0;
        }
        return var0 < (var2 *= 64.0) * var2;
    }

    private void showBreakingParticles() {
        if (this.level instanceof WorldServer) {
            ((WorldServer)this.level).sendParticles(new ParticleParamBlock(Particles.BLOCK, Blocks.OAK_PLANKS.defaultBlockState()), this.getX(), this.getY(0.6666666666666666), this.getZ(), 10, this.getBbWidth() / 4.0f, this.getBbHeight() / 4.0f, this.getBbWidth() / 4.0f, 0.05);
        }
    }

    private void causeDamage(DamageSource var0, float var1) {
        float var2 = this.getHealth();
        if ((var2 -= var1) <= 0.5f) {
            this.brokenByAnything(var0);
            this.kill();
        } else {
            this.setHealth(var2);
            this.gameEvent(GameEvent.ENTITY_DAMAGE, var0.getEntity());
        }
    }

    private void brokenByPlayer(DamageSource var0) {
        Block.popResource(this.level, this.blockPosition(), new ItemStack(Items.ARMOR_STAND));
        this.brokenByAnything(var0);
    }

    private void brokenByAnything(DamageSource var0) {
        ItemStack var2;
        int var1;
        this.playBrokenSound();
        this.dropAllDeathLoot(var0);
        for (var1 = 0; var1 < this.handItems.size(); ++var1) {
            var2 = this.handItems.get(var1);
            if (var2.isEmpty()) continue;
            Block.popResource(this.level, this.blockPosition().above(), var2);
            this.handItems.set(var1, ItemStack.EMPTY);
        }
        for (var1 = 0; var1 < this.armorItems.size(); ++var1) {
            var2 = this.armorItems.get(var1);
            if (var2.isEmpty()) continue;
            Block.popResource(this.level, this.blockPosition().above(), var2);
            this.armorItems.set(var1, ItemStack.EMPTY);
        }
    }

    private void playBrokenSound() {
        this.level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEffects.ARMOR_STAND_BREAK, this.getSoundSource(), 1.0f, 1.0f);
    }

    @Override
    protected float tickHeadTurn(float var0, float var1) {
        this.yBodyRotO = this.yRotO;
        this.yBodyRot = this.getYRot();
        return 0.0f;
    }

    @Override
    protected float getStandingEyeHeight(EntityPose var0, EntitySize var1) {
        return var1.height * (this.isBaby() ? 0.5f : 0.9f);
    }

    @Override
    public double getMyRidingOffset() {
        return this.isMarker() ? 0.0 : (double)0.1f;
    }

    @Override
    public void travel(Vec3D var0) {
        if (!this.hasPhysics()) {
            return;
        }
        super.travel(var0);
    }

    @Override
    public void setYBodyRot(float var0) {
        this.yBodyRotO = this.yRotO = var0;
        this.yHeadRotO = this.yHeadRot = var0;
    }

    @Override
    public void setYHeadRot(float var0) {
        this.yBodyRotO = this.yRotO = var0;
        this.yHeadRotO = this.yHeadRot = var0;
    }

    @Override
    public void tick() {
        Vector3f var5;
        Vector3f var4;
        Vector3f var3;
        Vector3f var2;
        Vector3f var1;
        super.tick();
        Vector3f var0 = this.entityData.get(DATA_HEAD_POSE);
        if (!this.headPose.equals(var0)) {
            this.setHeadPose(var0);
        }
        if (!this.bodyPose.equals(var1 = this.entityData.get(DATA_BODY_POSE))) {
            this.setBodyPose(var1);
        }
        if (!this.leftArmPose.equals(var2 = this.entityData.get(DATA_LEFT_ARM_POSE))) {
            this.setLeftArmPose(var2);
        }
        if (!this.rightArmPose.equals(var3 = this.entityData.get(DATA_RIGHT_ARM_POSE))) {
            this.setRightArmPose(var3);
        }
        if (!this.leftLegPose.equals(var4 = this.entityData.get(DATA_LEFT_LEG_POSE))) {
            this.setLeftLegPose(var4);
        }
        if (!this.rightLegPose.equals(var5 = this.entityData.get(DATA_RIGHT_LEG_POSE))) {
            this.setRightLegPose(var5);
        }
    }

    @Override
    protected void updateInvisibilityStatus() {
        this.setInvisible(this.invisible);
    }

    @Override
    public void setInvisible(boolean var0) {
        this.invisible = var0;
        super.setInvisible(var0);
    }

    @Override
    public boolean isBaby() {
        return this.isSmall();
    }

    @Override
    public void kill() {
        this.remove(Entity.RemovalReason.KILLED);
        this.gameEvent(GameEvent.ENTITY_DIE);
    }

    @Override
    public boolean ignoreExplosion() {
        return this.isInvisible();
    }

    @Override
    public EnumPistonReaction getPistonPushReaction() {
        if (this.isMarker()) {
            return EnumPistonReaction.IGNORE;
        }
        return super.getPistonPushReaction();
    }

    public void setSmall(boolean var0) {
        this.entityData.set(DATA_CLIENT_FLAGS, this.setBit(this.entityData.get(DATA_CLIENT_FLAGS), 1, var0));
    }

    public boolean isSmall() {
        return (this.entityData.get(DATA_CLIENT_FLAGS) & 1) != 0;
    }

    public void setShowArms(boolean var0) {
        this.entityData.set(DATA_CLIENT_FLAGS, this.setBit(this.entityData.get(DATA_CLIENT_FLAGS), 4, var0));
    }

    public boolean isShowArms() {
        return (this.entityData.get(DATA_CLIENT_FLAGS) & 4) != 0;
    }

    public void setNoBasePlate(boolean var0) {
        this.entityData.set(DATA_CLIENT_FLAGS, this.setBit(this.entityData.get(DATA_CLIENT_FLAGS), 8, var0));
    }

    public boolean isNoBasePlate() {
        return (this.entityData.get(DATA_CLIENT_FLAGS) & 8) != 0;
    }

    public void setMarker(boolean var0) {
        this.entityData.set(DATA_CLIENT_FLAGS, this.setBit(this.entityData.get(DATA_CLIENT_FLAGS), 16, var0));
    }

    public boolean isMarker() {
        return (this.entityData.get(DATA_CLIENT_FLAGS) & 0x10) != 0;
    }

    private byte setBit(byte var0, int var1, boolean var2) {
        var0 = var2 ? (byte)(var0 | var1) : (byte)(var0 & ~var1);
        return var0;
    }

    public void setHeadPose(Vector3f var0) {
        this.headPose = var0;
        this.entityData.set(DATA_HEAD_POSE, var0);
    }

    public void setBodyPose(Vector3f var0) {
        this.bodyPose = var0;
        this.entityData.set(DATA_BODY_POSE, var0);
    }

    public void setLeftArmPose(Vector3f var0) {
        this.leftArmPose = var0;
        this.entityData.set(DATA_LEFT_ARM_POSE, var0);
    }

    public void setRightArmPose(Vector3f var0) {
        this.rightArmPose = var0;
        this.entityData.set(DATA_RIGHT_ARM_POSE, var0);
    }

    public void setLeftLegPose(Vector3f var0) {
        this.leftLegPose = var0;
        this.entityData.set(DATA_LEFT_LEG_POSE, var0);
    }

    public void setRightLegPose(Vector3f var0) {
        this.rightLegPose = var0;
        this.entityData.set(DATA_RIGHT_LEG_POSE, var0);
    }

    public Vector3f getHeadPose() {
        return this.headPose;
    }

    public Vector3f getBodyPose() {
        return this.bodyPose;
    }

    public Vector3f getLeftArmPose() {
        return this.leftArmPose;
    }

    public Vector3f getRightArmPose() {
        return this.rightArmPose;
    }

    public Vector3f getLeftLegPose() {
        return this.leftLegPose;
    }

    public Vector3f getRightLegPose() {
        return this.rightLegPose;
    }

    @Override
    public boolean isPickable() {
        return super.isPickable() && !this.isMarker();
    }

    @Override
    public boolean skipAttackInteraction(Entity var0) {
        return var0 instanceof EntityHuman && !this.level.mayInteract((EntityHuman)var0, this.blockPosition());
    }

    @Override
    public EnumMainHand getMainArm() {
        return EnumMainHand.RIGHT;
    }

    @Override
    public EntityLiving.a getFallSounds() {
        return new EntityLiving.a(SoundEffects.ARMOR_STAND_FALL, SoundEffects.ARMOR_STAND_FALL);
    }

    @Override
    @Nullable
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.ARMOR_STAND_HIT;
    }

    @Override
    @Nullable
    protected SoundEffect getDeathSound() {
        return SoundEffects.ARMOR_STAND_BREAK;
    }

    @Override
    public void thunderHit(WorldServer var0, EntityLightning var1) {
    }

    @Override
    public boolean isAffectedByPotions() {
        return false;
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (DATA_CLIENT_FLAGS.equals(var0)) {
            this.refreshDimensions();
            this.blocksBuilding = !this.isMarker();
        }
        super.onSyncedDataUpdated(var0);
    }

    @Override
    public boolean attackable() {
        return false;
    }

    @Override
    public EntitySize getDimensions(EntityPose var0) {
        return this.getDimensionsMarker(this.isMarker());
    }

    private EntitySize getDimensionsMarker(boolean var0) {
        if (var0) {
            return MARKER_DIMENSIONS;
        }
        return this.isBaby() ? BABY_DIMENSIONS : this.getType().getDimensions();
    }

    @Override
    public Vec3D getLightProbePosition(float var0) {
        if (this.isMarker()) {
            AxisAlignedBB var1 = this.getDimensionsMarker(false).makeBoundingBox(this.position());
            BlockPosition var2 = this.blockPosition();
            int var3 = Integer.MIN_VALUE;
            for (BlockPosition var5 : BlockPosition.betweenClosed(new BlockPosition(var1.minX, var1.minY, var1.minZ), new BlockPosition(var1.maxX, var1.maxY, var1.maxZ))) {
                int var6 = Math.max(this.level.getBrightness(EnumSkyBlock.BLOCK, var5), this.level.getBrightness(EnumSkyBlock.SKY, var5));
                if (var6 == 15) {
                    return Vec3D.atCenterOf(var5);
                }
                if (var6 <= var3) continue;
                var3 = var6;
                var2 = var5.immutable();
            }
            return Vec3D.atCenterOf(var2);
        }
        return super.getLightProbePosition(var0);
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.ARMOR_STAND);
    }

    @Override
    public boolean canBeSeenByAnyone() {
        return !this.isInvisible() && !this.isMarker();
    }
}

