/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.IInventoryListener;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTame;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public abstract class EntityHorseAbstract
extends EntityAnimal
implements IInventoryListener,
HasCustomInventoryScreen,
IJumpable,
ISaddleable {
    public static final int EQUIPMENT_SLOT_OFFSET = 400;
    public static final int CHEST_SLOT_OFFSET = 499;
    public static final int INVENTORY_SLOT_OFFSET = 500;
    private static final Predicate<EntityLiving> PARENT_HORSE_SELECTOR = var0 -> var0 instanceof EntityHorseAbstract && ((EntityHorseAbstract)var0).isBred();
    private static final PathfinderTargetCondition MOMMY_TARGETING = PathfinderTargetCondition.forNonCombat().range(16.0).ignoreLineOfSight().selector(PARENT_HORSE_SELECTOR);
    private static final RecipeItemStack FOOD_ITEMS = RecipeItemStack.of(Items.WHEAT, Items.SUGAR, Blocks.HAY_BLOCK.asItem(), Items.APPLE, Items.GOLDEN_CARROT, Items.GOLDEN_APPLE, Items.ENCHANTED_GOLDEN_APPLE);
    private static final DataWatcherObject<Byte> DATA_ID_FLAGS = DataWatcher.defineId(EntityHorseAbstract.class, DataWatcherRegistry.BYTE);
    private static final DataWatcherObject<Optional<UUID>> DATA_ID_OWNER_UUID = DataWatcher.defineId(EntityHorseAbstract.class, DataWatcherRegistry.OPTIONAL_UUID);
    private static final int FLAG_TAME = 2;
    private static final int FLAG_SADDLE = 4;
    private static final int FLAG_BRED = 8;
    private static final int FLAG_EATING = 16;
    private static final int FLAG_STANDING = 32;
    private static final int FLAG_OPEN_MOUTH = 64;
    public static final int INV_SLOT_SADDLE = 0;
    public static final int INV_SLOT_ARMOR = 1;
    public static final int INV_BASE_COUNT = 2;
    private int eatingCounter;
    private int mouthCounter;
    private int standCounter;
    public int tailCounter;
    public int sprintCounter;
    protected boolean isJumping;
    public InventorySubcontainer inventory;
    protected int temper;
    protected float playerJumpPendingScale;
    private boolean allowStandSliding;
    private float eatAnim;
    private float eatAnimO;
    private float standAnim;
    private float standAnimO;
    private float mouthAnim;
    private float mouthAnimO;
    protected boolean canGallop = true;
    protected int gallopSoundCounter;

    protected EntityHorseAbstract(EntityTypes<? extends EntityHorseAbstract> var0, World var1) {
        super((EntityTypes<? extends EntityAnimal>)var0, var1);
        this.maxUpStep = 1.0f;
        this.createInventory();
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, new PathfinderGoalPanic(this, 1.2));
        this.goalSelector.addGoal(1, new PathfinderGoalTame(this, 1.2));
        this.goalSelector.addGoal(2, new PathfinderGoalBreed(this, 1.0, EntityHorseAbstract.class));
        this.goalSelector.addGoal(4, new PathfinderGoalFollowParent(this, 1.0));
        this.goalSelector.addGoal(6, new PathfinderGoalRandomStrollLand(this, 0.7));
        this.goalSelector.addGoal(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.goalSelector.addGoal(8, new PathfinderGoalRandomLookaround(this));
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.goalSelector.addGoal(0, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(3, new PathfinderGoalTempt(this, 1.25, RecipeItemStack.of(Items.GOLDEN_CARROT, Items.GOLDEN_APPLE, Items.ENCHANTED_GOLDEN_APPLE), false));
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(DATA_ID_FLAGS, (byte)0);
        this.entityData.define(DATA_ID_OWNER_UUID, Optional.empty());
    }

    protected boolean getFlag(int var0) {
        return (this.entityData.get(DATA_ID_FLAGS) & var0) != 0;
    }

    protected void setFlag(int var0, boolean var1) {
        byte var2 = this.entityData.get(DATA_ID_FLAGS);
        if (var1) {
            this.entityData.set(DATA_ID_FLAGS, (byte)(var2 | var0));
        } else {
            this.entityData.set(DATA_ID_FLAGS, (byte)(var2 & ~var0));
        }
    }

    public boolean isTamed() {
        return this.getFlag(2);
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.entityData.get(DATA_ID_OWNER_UUID).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID var0) {
        this.entityData.set(DATA_ID_OWNER_UUID, Optional.ofNullable(var0));
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public void setTamed(boolean var0) {
        this.setFlag(2, var0);
    }

    public void setIsJumping(boolean var0) {
        this.isJumping = var0;
    }

    @Override
    protected void onLeashDistance(float var0) {
        if (var0 > 6.0f && this.isEating()) {
            this.setEating(false);
        }
    }

    public boolean isEating() {
        return this.getFlag(16);
    }

    public boolean isStanding() {
        return this.getFlag(32);
    }

    public boolean isBred() {
        return this.getFlag(8);
    }

    public void setBred(boolean var0) {
        this.setFlag(8, var0);
    }

    @Override
    public boolean isSaddleable() {
        return this.isAlive() && !this.isBaby() && this.isTamed();
    }

    @Override
    public void equipSaddle(@Nullable SoundCategory var0) {
        this.inventory.setItem(0, new ItemStack(Items.SADDLE));
        if (var0 != null) {
            this.level.playSound(null, this, SoundEffects.HORSE_SADDLE, var0, 0.5f, 1.0f);
        }
    }

    @Override
    public boolean isSaddled() {
        return this.getFlag(4);
    }

    public int getTemper() {
        return this.temper;
    }

    public void setTemper(int var0) {
        this.temper = var0;
    }

    public int modifyTemper(int var0) {
        int var1 = MathHelper.clamp(this.getTemper() + var0, 0, this.getMaxTemper());
        this.setTemper(var1);
        return var1;
    }

    @Override
    public boolean isPushable() {
        return !this.isVehicle();
    }

    private void eating() {
        SoundEffect var0;
        this.openMouth();
        if (!this.isSilent() && (var0 = this.getEatingSound()) != null) {
            this.level.playSound(null, this.getX(), this.getY(), this.getZ(), var0, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
    }

    @Override
    public boolean causeFallDamage(float var0, float var1, DamageSource var2) {
        int var3;
        if (var0 > 1.0f) {
            this.playSound(SoundEffects.HORSE_LAND, 0.4f, 1.0f);
        }
        if ((var3 = this.calculateFallDamage(var0, var1)) <= 0) {
            return false;
        }
        this.hurt(var2, var3);
        if (this.isVehicle()) {
            for (Entity var5 : this.getIndirectPassengers()) {
                var5.hurt(var2, var3);
            }
        }
        this.playBlockFallSound();
        return true;
    }

    @Override
    protected int calculateFallDamage(float var0, float var1) {
        return MathHelper.ceil((var0 * 0.5f - 3.0f) * var1);
    }

    protected int getInventorySize() {
        return 2;
    }

    public void createInventory() {
        InventorySubcontainer var0 = this.inventory;
        this.inventory = new InventorySubcontainer(this.getInventorySize());
        if (var0 != null) {
            var0.removeListener(this);
            int var1 = Math.min(var0.getContainerSize(), this.inventory.getContainerSize());
            for (int var2 = 0; var2 < var1; ++var2) {
                ItemStack var3 = var0.getItem(var2);
                if (var3.isEmpty()) continue;
                this.inventory.setItem(var2, var3.copy());
            }
        }
        this.inventory.addListener(this);
        this.updateContainerEquipment();
    }

    protected void updateContainerEquipment() {
        if (this.level.isClientSide) {
            return;
        }
        this.setFlag(4, !this.inventory.getItem(0).isEmpty());
    }

    @Override
    public void containerChanged(IInventory var0) {
        boolean var1 = this.isSaddled();
        this.updateContainerEquipment();
        if (this.tickCount > 20 && !var1 && this.isSaddled()) {
            this.playSound(SoundEffects.HORSE_SADDLE, 0.5f, 1.0f);
        }
    }

    public double getCustomJump() {
        return this.getAttributeValue(GenericAttributes.JUMP_STRENGTH);
    }

    @Nullable
    protected SoundEffect getEatingSound() {
        return null;
    }

    @Override
    @Nullable
    protected SoundEffect getDeathSound() {
        return null;
    }

    @Override
    @Nullable
    protected SoundEffect getHurtSound(DamageSource var0) {
        if (this.random.nextInt(3) == 0) {
            this.stand();
        }
        return null;
    }

    @Override
    @Nullable
    protected SoundEffect getAmbientSound() {
        if (this.random.nextInt(10) == 0 && !this.isImmobile()) {
            this.stand();
        }
        return null;
    }

    @Nullable
    protected SoundEffect getAngrySound() {
        this.stand();
        return null;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        if (var1.getMaterial().isLiquid()) {
            return;
        }
        IBlockData var2 = this.level.getBlockState(var0.above());
        SoundEffectType var3 = var1.getSoundType();
        if (var2.is(Blocks.SNOW)) {
            var3 = var2.getSoundType();
        }
        if (this.isVehicle() && this.canGallop) {
            ++this.gallopSoundCounter;
            if (this.gallopSoundCounter > 5 && this.gallopSoundCounter % 3 == 0) {
                this.playGallopSound(var3);
            } else if (this.gallopSoundCounter <= 5) {
                this.playSound(SoundEffects.HORSE_STEP_WOOD, var3.getVolume() * 0.15f, var3.getPitch());
            }
        } else if (var3 == SoundEffectType.WOOD) {
            this.playSound(SoundEffects.HORSE_STEP_WOOD, var3.getVolume() * 0.15f, var3.getPitch());
        } else {
            this.playSound(SoundEffects.HORSE_STEP, var3.getVolume() * 0.15f, var3.getPitch());
        }
    }

    protected void playGallopSound(SoundEffectType var0) {
        this.playSound(SoundEffects.HORSE_GALLOP, var0.getVolume() * 0.15f, var0.getPitch());
    }

    public static AttributeProvider.Builder createBaseHorseAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.JUMP_STRENGTH).add(GenericAttributes.MAX_HEALTH, 53.0).add(GenericAttributes.MOVEMENT_SPEED, 0.225f);
    }

    @Override
    public int getMaxSpawnClusterSize() {
        return 6;
    }

    public int getMaxTemper() {
        return 100;
    }

    @Override
    protected float getSoundVolume() {
        return 0.8f;
    }

    @Override
    public int getAmbientSoundInterval() {
        return 400;
    }

    @Override
    public void openCustomInventoryScreen(EntityHuman var0) {
        if (!this.level.isClientSide && (!this.isVehicle() || this.hasPassenger(var0)) && this.isTamed()) {
            var0.openHorseInventory(this, this.inventory);
        }
    }

    public EnumInteractionResult fedFood(EntityHuman var0, ItemStack var1) {
        boolean var2 = this.handleEating(var0, var1);
        if (!var0.getAbilities().instabuild) {
            var1.shrink(1);
        }
        if (this.level.isClientSide) {
            return EnumInteractionResult.CONSUME;
        }
        return var2 ? EnumInteractionResult.SUCCESS : EnumInteractionResult.PASS;
    }

    protected boolean handleEating(EntityHuman var0, ItemStack var1) {
        boolean var2 = false;
        float var3 = 0.0f;
        int var4 = 0;
        int var5 = 0;
        if (var1.is(Items.WHEAT)) {
            var3 = 2.0f;
            var4 = 20;
            var5 = 3;
        } else if (var1.is(Items.SUGAR)) {
            var3 = 1.0f;
            var4 = 30;
            var5 = 3;
        } else if (var1.is(Blocks.HAY_BLOCK.asItem())) {
            var3 = 20.0f;
            var4 = 180;
        } else if (var1.is(Items.APPLE)) {
            var3 = 3.0f;
            var4 = 60;
            var5 = 3;
        } else if (var1.is(Items.GOLDEN_CARROT)) {
            var3 = 4.0f;
            var4 = 60;
            var5 = 5;
            if (!this.level.isClientSide && this.isTamed() && this.getAge() == 0 && !this.isInLove()) {
                var2 = true;
                this.setInLove(var0);
            }
        } else if (var1.is(Items.GOLDEN_APPLE) || var1.is(Items.ENCHANTED_GOLDEN_APPLE)) {
            var3 = 10.0f;
            var4 = 240;
            var5 = 10;
            if (!this.level.isClientSide && this.isTamed() && this.getAge() == 0 && !this.isInLove()) {
                var2 = true;
                this.setInLove(var0);
            }
        }
        if (this.getHealth() < this.getMaxHealth() && var3 > 0.0f) {
            this.heal(var3);
            var2 = true;
        }
        if (this.isBaby() && var4 > 0) {
            this.level.addParticle(Particles.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 0.0, 0.0, 0.0);
            if (!this.level.isClientSide) {
                this.ageUp(var4);
            }
            var2 = true;
        }
        if (var5 > 0 && (var2 || !this.isTamed()) && this.getTemper() < this.getMaxTemper()) {
            var2 = true;
            if (!this.level.isClientSide) {
                this.modifyTemper(var5);
            }
        }
        if (var2) {
            this.eating();
            this.gameEvent(GameEvent.EAT);
        }
        return var2;
    }

    protected void doPlayerRide(EntityHuman var0) {
        this.setEating(false);
        this.setStanding(false);
        if (!this.level.isClientSide) {
            var0.setYRot(this.getYRot());
            var0.setXRot(this.getXRot());
            var0.startRiding(this);
        }
    }

    @Override
    protected boolean isImmobile() {
        return super.isImmobile() && this.isVehicle() && this.isSaddled() || this.isEating() || this.isStanding();
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return FOOD_ITEMS.test(var0);
    }

    private void moveTail() {
        this.tailCounter = 1;
    }

    @Override
    protected void dropEquipment() {
        super.dropEquipment();
        if (this.inventory == null) {
            return;
        }
        for (int var0 = 0; var0 < this.inventory.getContainerSize(); ++var0) {
            ItemStack var1 = this.inventory.getItem(var0);
            if (var1.isEmpty() || EnchantmentManager.hasVanishingCurse(var1)) continue;
            this.spawnAtLocation(var1);
        }
    }

    @Override
    public void aiStep() {
        if (this.random.nextInt(200) == 0) {
            this.moveTail();
        }
        super.aiStep();
        if (this.level.isClientSide || !this.isAlive()) {
            return;
        }
        if (this.random.nextInt(900) == 0 && this.deathTime == 0) {
            this.heal(1.0f);
        }
        if (this.canEatGrass()) {
            if (!this.isEating() && !this.isVehicle() && this.random.nextInt(300) == 0 && this.level.getBlockState(this.blockPosition().below()).is(Blocks.GRASS_BLOCK)) {
                this.setEating(true);
            }
            if (this.isEating() && ++this.eatingCounter > 50) {
                this.eatingCounter = 0;
                this.setEating(false);
            }
        }
        this.followMommy();
    }

    protected void followMommy() {
        EntityHorseAbstract var0;
        if (this.isBred() && this.isBaby() && !this.isEating() && (var0 = this.level.getNearestEntity(EntityHorseAbstract.class, MOMMY_TARGETING, this, this.getX(), this.getY(), this.getZ(), this.getBoundingBox().inflate(16.0))) != null && this.distanceToSqr(var0) > 4.0) {
            this.navigation.createPath(var0, 0);
        }
    }

    public boolean canEatGrass() {
        return true;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.mouthCounter > 0 && ++this.mouthCounter > 30) {
            this.mouthCounter = 0;
            this.setFlag(64, false);
        }
        if ((this.isControlledByLocalInstance() || this.isEffectiveAi()) && this.standCounter > 0 && ++this.standCounter > 20) {
            this.standCounter = 0;
            this.setStanding(false);
        }
        if (this.tailCounter > 0 && ++this.tailCounter > 8) {
            this.tailCounter = 0;
        }
        if (this.sprintCounter > 0) {
            ++this.sprintCounter;
            if (this.sprintCounter > 300) {
                this.sprintCounter = 0;
            }
        }
        this.eatAnimO = this.eatAnim;
        if (this.isEating()) {
            this.eatAnim += (1.0f - this.eatAnim) * 0.4f + 0.05f;
            if (this.eatAnim > 1.0f) {
                this.eatAnim = 1.0f;
            }
        } else {
            this.eatAnim += (0.0f - this.eatAnim) * 0.4f - 0.05f;
            if (this.eatAnim < 0.0f) {
                this.eatAnim = 0.0f;
            }
        }
        this.standAnimO = this.standAnim;
        if (this.isStanding()) {
            this.eatAnimO = this.eatAnim = 0.0f;
            this.standAnim += (1.0f - this.standAnim) * 0.4f + 0.05f;
            if (this.standAnim > 1.0f) {
                this.standAnim = 1.0f;
            }
        } else {
            this.allowStandSliding = false;
            this.standAnim += (0.8f * this.standAnim * this.standAnim * this.standAnim - this.standAnim) * 0.6f - 0.05f;
            if (this.standAnim < 0.0f) {
                this.standAnim = 0.0f;
            }
        }
        this.mouthAnimO = this.mouthAnim;
        if (this.getFlag(64)) {
            this.mouthAnim += (1.0f - this.mouthAnim) * 0.7f + 0.05f;
            if (this.mouthAnim > 1.0f) {
                this.mouthAnim = 1.0f;
            }
        } else {
            this.mouthAnim += (0.0f - this.mouthAnim) * 0.7f - 0.05f;
            if (this.mouthAnim < 0.0f) {
                this.mouthAnim = 0.0f;
            }
        }
    }

    private void openMouth() {
        if (!this.level.isClientSide) {
            this.mouthCounter = 1;
            this.setFlag(64, true);
        }
    }

    public void setEating(boolean var0) {
        this.setFlag(16, var0);
    }

    public void setStanding(boolean var0) {
        if (var0) {
            this.setEating(false);
        }
        this.setFlag(32, var0);
    }

    private void stand() {
        if (this.isControlledByLocalInstance() || this.isEffectiveAi()) {
            this.standCounter = 1;
            this.setStanding(true);
        }
    }

    public void makeMad() {
        if (!this.isStanding()) {
            this.stand();
            SoundEffect var0 = this.getAngrySound();
            if (var0 != null) {
                this.playSound(var0, this.getSoundVolume(), this.getVoicePitch());
            }
        }
    }

    public boolean tameWithName(EntityHuman var0) {
        this.setOwnerUUID(var0.getUUID());
        this.setTamed(true);
        if (var0 instanceof EntityPlayer) {
            CriterionTriggers.TAME_ANIMAL.trigger((EntityPlayer)var0, this);
        }
        this.level.broadcastEntityEvent(this, (byte)7);
        return true;
    }

    @Override
    public void travel(Vec3D var0) {
        if (!this.isAlive()) {
            return;
        }
        EntityLiving var1 = this.getControllingPassenger();
        if (!this.isVehicle() || var1 == null) {
            this.flyingSpeed = 0.02f;
            super.travel(var0);
            return;
        }
        this.setYRot(var1.getYRot());
        this.yRotO = this.getYRot();
        this.setXRot(var1.getXRot() * 0.5f);
        this.setRot(this.getYRot(), this.getXRot());
        this.yHeadRot = this.yBodyRot = this.getYRot();
        float var2 = var1.xxa * 0.5f;
        float var3 = var1.zza;
        if (var3 <= 0.0f) {
            var3 *= 0.25f;
            this.gallopSoundCounter = 0;
        }
        if (this.onGround && this.playerJumpPendingScale == 0.0f && this.isStanding() && !this.allowStandSliding) {
            var2 = 0.0f;
            var3 = 0.0f;
        }
        if (this.playerJumpPendingScale > 0.0f && !this.isJumping() && this.onGround) {
            double var4 = this.getCustomJump() * (double)this.playerJumpPendingScale * (double)this.getBlockJumpFactor();
            double var6 = var4 + this.getJumpBoostPower();
            Vec3D var8 = this.getDeltaMovement();
            this.setDeltaMovement(var8.x, var6, var8.z);
            this.setIsJumping(true);
            this.hasImpulse = true;
            if (var3 > 0.0f) {
                float var9 = MathHelper.sin(this.getYRot() * ((float)Math.PI / 180));
                float var10 = MathHelper.cos(this.getYRot() * ((float)Math.PI / 180));
                this.setDeltaMovement(this.getDeltaMovement().add(-0.4f * var9 * this.playerJumpPendingScale, 0.0, 0.4f * var10 * this.playerJumpPendingScale));
            }
            this.playerJumpPendingScale = 0.0f;
        }
        this.flyingSpeed = this.getSpeed() * 0.1f;
        if (this.isControlledByLocalInstance()) {
            this.setSpeed((float)this.getAttributeValue(GenericAttributes.MOVEMENT_SPEED));
            super.travel(new Vec3D(var2, var0.y, var3));
        } else if (var1 instanceof EntityHuman) {
            this.setDeltaMovement(Vec3D.ZERO);
        }
        if (this.onGround) {
            this.playerJumpPendingScale = 0.0f;
            this.setIsJumping(false);
        }
        this.calculateEntityAnimation(this, false);
        this.tryCheckInsideBlocks();
    }

    protected void playJumpSound() {
        this.playSound(SoundEffects.HORSE_JUMP, 0.4f, 1.0f);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putBoolean("EatingHaystack", this.isEating());
        var0.putBoolean("Bred", this.isBred());
        var0.putInt("Temper", this.getTemper());
        var0.putBoolean("Tame", this.isTamed());
        if (this.getOwnerUUID() != null) {
            var0.putUUID("Owner", this.getOwnerUUID());
        }
        if (!this.inventory.getItem(0).isEmpty()) {
            var0.put("SaddleItem", this.inventory.getItem(0).save(new NBTTagCompound()));
        }
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        Object var2;
        UUID var1;
        super.readAdditionalSaveData(var0);
        this.setEating(var0.getBoolean("EatingHaystack"));
        this.setBred(var0.getBoolean("Bred"));
        this.setTemper(var0.getInt("Temper"));
        this.setTamed(var0.getBoolean("Tame"));
        if (var0.hasUUID("Owner")) {
            var1 = var0.getUUID("Owner");
        } else {
            var2 = var0.getString("Owner");
            var1 = NameReferencingFileConverter.convertMobOwnerIfNecessary(this.getServer(), (String)var2);
        }
        if (var1 != null) {
            this.setOwnerUUID(var1);
        }
        if (var0.contains("SaddleItem", 10) && ((ItemStack)(var2 = ItemStack.of(var0.getCompound("SaddleItem")))).is(Items.SADDLE)) {
            this.inventory.setItem(0, (ItemStack)var2);
        }
        this.updateContainerEquipment();
    }

    @Override
    public boolean canMate(EntityAnimal var0) {
        return false;
    }

    protected boolean canParent() {
        return !this.isVehicle() && !this.isPassenger() && this.isTamed() && !this.isBaby() && this.getHealth() >= this.getMaxHealth() && this.isInLove();
    }

    @Override
    @Nullable
    public EntityAgeable getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        return null;
    }

    protected void setOffspringAttributes(EntityAgeable var0, EntityHorseAbstract var1) {
        double var2 = this.getAttributeBaseValue(GenericAttributes.MAX_HEALTH) + var0.getAttributeBaseValue(GenericAttributes.MAX_HEALTH) + (double)this.generateRandomMaxHealth(this.random);
        var1.getAttribute(GenericAttributes.MAX_HEALTH).setBaseValue(var2 / 3.0);
        double var4 = this.getAttributeBaseValue(GenericAttributes.JUMP_STRENGTH) + var0.getAttributeBaseValue(GenericAttributes.JUMP_STRENGTH) + this.generateRandomJumpStrength(this.random);
        var1.getAttribute(GenericAttributes.JUMP_STRENGTH).setBaseValue(var4 / 3.0);
        double var6 = this.getAttributeBaseValue(GenericAttributes.MOVEMENT_SPEED) + var0.getAttributeBaseValue(GenericAttributes.MOVEMENT_SPEED) + this.generateRandomSpeed(this.random);
        var1.getAttribute(GenericAttributes.MOVEMENT_SPEED).setBaseValue(var6 / 3.0);
    }

    public float getEatAnim(float var0) {
        return MathHelper.lerp(var0, this.eatAnimO, this.eatAnim);
    }

    public float getStandAnim(float var0) {
        return MathHelper.lerp(var0, this.standAnimO, this.standAnim);
    }

    public float getMouthAnim(float var0) {
        return MathHelper.lerp(var0, this.mouthAnimO, this.mouthAnim);
    }

    @Override
    public void onPlayerJump(int var0) {
        if (!this.isSaddled()) {
            return;
        }
        if (var0 < 0) {
            var0 = 0;
        } else {
            this.allowStandSliding = true;
            this.stand();
        }
        this.playerJumpPendingScale = var0 >= 90 ? 1.0f : 0.4f + 0.4f * (float)var0 / 90.0f;
    }

    @Override
    public boolean canJump() {
        return this.isSaddled();
    }

    @Override
    public void handleStartJump(int var0) {
        this.allowStandSliding = true;
        this.stand();
        this.playJumpSound();
    }

    @Override
    public void handleStopJump() {
    }

    protected void spawnTamingParticles(boolean var0) {
        ParticleType var1 = var0 ? Particles.HEART : Particles.SMOKE;
        for (int var2 = 0; var2 < 7; ++var2) {
            double var3 = this.random.nextGaussian() * 0.02;
            double var5 = this.random.nextGaussian() * 0.02;
            double var7 = this.random.nextGaussian() * 0.02;
            this.level.addParticle(var1, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), var3, var5, var7);
        }
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 7) {
            this.spawnTamingParticles(true);
        } else if (var0 == 6) {
            this.spawnTamingParticles(false);
        } else {
            super.handleEntityEvent(var0);
        }
    }

    @Override
    public void positionRider(Entity var0) {
        super.positionRider(var0);
        if (var0 instanceof EntityInsentient) {
            EntityInsentient var1 = (EntityInsentient)var0;
            this.yBodyRot = var1.yBodyRot;
        }
        if (this.standAnimO > 0.0f) {
            float var1 = MathHelper.sin(this.yBodyRot * ((float)Math.PI / 180));
            float var2 = MathHelper.cos(this.yBodyRot * ((float)Math.PI / 180));
            float var3 = 0.7f * this.standAnimO;
            float var4 = 0.15f * this.standAnimO;
            var0.setPos(this.getX() + (double)(var3 * var1), this.getY() + this.getPassengersRidingOffset() + var0.getMyRidingOffset() + (double)var4, this.getZ() - (double)(var3 * var2));
            if (var0 instanceof EntityLiving) {
                ((EntityLiving)var0).yBodyRot = this.yBodyRot;
            }
        }
    }

    protected float generateRandomMaxHealth(RandomSource var0) {
        return 15.0f + (float)var0.nextInt(8) + (float)var0.nextInt(9);
    }

    protected double generateRandomJumpStrength(RandomSource var0) {
        return (double)0.4f + var0.nextDouble() * 0.2 + var0.nextDouble() * 0.2 + var0.nextDouble() * 0.2;
    }

    protected double generateRandomSpeed(RandomSource var0) {
        return ((double)0.45f + var0.nextDouble() * 0.3 + var0.nextDouble() * 0.3 + var0.nextDouble() * 0.3) * 0.25;
    }

    @Override
    public boolean onClimbable() {
        return false;
    }

    @Override
    protected float getStandingEyeHeight(EntityPose var0, EntitySize var1) {
        return var1.height * 0.95f;
    }

    public boolean canWearArmor() {
        return false;
    }

    public boolean isWearingArmor() {
        return !this.getItemBySlot(EnumItemSlot.CHEST).isEmpty();
    }

    public boolean isArmor(ItemStack var0) {
        return false;
    }

    private SlotAccess createEquipmentSlotAccess(final int var0, final Predicate<ItemStack> var1) {
        return new SlotAccess(){

            @Override
            public ItemStack get() {
                return EntityHorseAbstract.this.inventory.getItem(var0);
            }

            @Override
            public boolean set(ItemStack var02) {
                if (!var1.test(var02)) {
                    return false;
                }
                EntityHorseAbstract.this.inventory.setItem(var0, var02);
                EntityHorseAbstract.this.updateContainerEquipment();
                return true;
            }
        };
    }

    @Override
    public SlotAccess getSlot(int var02) {
        int var2;
        int var1 = var02 - 400;
        if (var1 >= 0 && var1 < 2 && var1 < this.inventory.getContainerSize()) {
            if (var1 == 0) {
                return this.createEquipmentSlotAccess(var1, var0 -> var0.isEmpty() || var0.is(Items.SADDLE));
            }
            if (var1 == 1) {
                if (!this.canWearArmor()) {
                    return SlotAccess.NULL;
                }
                return this.createEquipmentSlotAccess(var1, var0 -> var0.isEmpty() || this.isArmor((ItemStack)var0));
            }
        }
        if ((var2 = var02 - 500 + 2) >= 2 && var2 < this.inventory.getContainerSize()) {
            return SlotAccess.forContainer(this.inventory, var2);
        }
        return super.getSlot(var02);
    }

    @Override
    @Nullable
    public EntityLiving getControllingPassenger() {
        Entity entity;
        if (this.isSaddled() && (entity = this.getFirstPassenger()) instanceof EntityLiving) {
            EntityLiving var0 = (EntityLiving)entity;
            return var0;
        }
        return null;
    }

    @Nullable
    private Vec3D getDismountLocationInDirection(Vec3D var0, EntityLiving var1) {
        double var2 = this.getX() + var0.x;
        double var4 = this.getBoundingBox().minY;
        double var6 = this.getZ() + var0.z;
        BlockPosition.MutableBlockPosition var8 = new BlockPosition.MutableBlockPosition();
        block0: for (EntityPose var10 : var1.getDismountPoses()) {
            var8.set(var2, var4, var6);
            double var11 = this.getBoundingBox().maxY + 0.75;
            do {
                Vec3D var16;
                AxisAlignedBB var15;
                double var13 = this.level.getBlockFloorHeight(var8);
                if ((double)var8.getY() + var13 > var11) continue block0;
                if (DismountUtil.isBlockFloorValid(var13) && DismountUtil.canDismountTo(this.level, var1, (var15 = var1.getLocalBoundsForPose(var10)).move(var16 = new Vec3D(var2, (double)var8.getY() + var13, var6)))) {
                    var1.setPose(var10);
                    return var16;
                }
                var8.move(EnumDirection.UP);
            } while ((double)var8.getY() < var11);
        }
        return null;
    }

    @Override
    public Vec3D getDismountLocationForPassenger(EntityLiving var0) {
        Vec3D var1 = EntityHorseAbstract.getCollisionHorizontalEscapeVector(this.getBbWidth(), var0.getBbWidth(), this.getYRot() + (var0.getMainArm() == EnumMainHand.RIGHT ? 90.0f : -90.0f));
        Vec3D var2 = this.getDismountLocationInDirection(var1, var0);
        if (var2 != null) {
            return var2;
        }
        Vec3D var3 = EntityHorseAbstract.getCollisionHorizontalEscapeVector(this.getBbWidth(), var0.getBbWidth(), this.getYRot() + (var0.getMainArm() == EnumMainHand.LEFT ? 90.0f : -90.0f));
        Vec3D var4 = this.getDismountLocationInDirection(var3, var0);
        if (var4 != null) {
            return var4;
        }
        return this.position();
    }

    protected void randomizeAttributes(RandomSource var0) {
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3, @Nullable NBTTagCompound var4) {
        if (var3 == null) {
            var3 = new EntityAgeable.a(0.2f);
        }
        this.randomizeAttributes(var0.getRandom());
        return super.finalizeSpawn(var0, var1, var2, var3, var4);
    }

    public boolean hasInventoryChanged(IInventory var0) {
        return this.inventory != var0;
    }

    @Override
    @Nullable
    public /* synthetic */ Entity getControllingPassenger() {
        return this.getControllingPassenger();
    }
}

