/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.allay;

import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.allay.AllayAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.vibrations.VibrationListener;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class Allay
extends EntityCreature
implements InventoryCarrier,
VibrationListener.b {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int GAME_EVENT_LISTENER_RANGE = 16;
    private static final BaseBlockPosition ITEM_PICKUP_REACH = new BaseBlockPosition(1, 1, 1);
    private static final int ANIMATION_DURATION = 5;
    private static final float PATHFINDING_BOUNDING_BOX_PADDING = 0.5f;
    protected static final ImmutableList<SensorType<? extends Sensor<? super Allay>>> SENSOR_TYPES = ImmutableList.of(SensorType.NEAREST_LIVING_ENTITIES, SensorType.NEAREST_PLAYERS, SensorType.HURT_BY, SensorType.NEAREST_ITEMS);
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of(MemoryModuleType.PATH, MemoryModuleType.LOOK_TARGET, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.WALK_TARGET, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.HURT_BY, MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, MemoryModuleType.LIKED_PLAYER, MemoryModuleType.LIKED_NOTEBLOCK_POSITION, MemoryModuleType.LIKED_NOTEBLOCK_COOLDOWN_TICKS, MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS, MemoryModuleType.IS_PANICKING, (Object[])new MemoryModuleType[0]);
    public static final ImmutableList<Float> THROW_SOUND_PITCHES = ImmutableList.of((Object)Float.valueOf(0.5625f), (Object)Float.valueOf(0.625f), (Object)Float.valueOf(0.75f), (Object)Float.valueOf(0.9375f), (Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.125f), (Object)Float.valueOf(1.25f), (Object)Float.valueOf(1.5f), (Object)Float.valueOf(1.875f), (Object)Float.valueOf(2.0f), (Object)Float.valueOf(2.25f), (Object[])new Float[]{Float.valueOf(2.5f), Float.valueOf(3.0f), Float.valueOf(3.75f), Float.valueOf(4.0f)});
    private final DynamicGameEventListener<VibrationListener> dynamicGameEventListener;
    private final InventorySubcontainer inventory = new InventorySubcontainer(1);
    private float holdingItemAnimationTicks;
    private float holdingItemAnimationTicks0;

    public Allay(EntityTypes<? extends Allay> var0, World var1) {
        super((EntityTypes<? extends EntityCreature>)var0, var1);
        this.moveControl = new ControllerMoveFlying(this, 20, true);
        this.setCanPickUpLoot(this.canPickUpLoot());
        this.dynamicGameEventListener = new DynamicGameEventListener<VibrationListener>(new VibrationListener(new EntityPositionSource(this, this.getEyeHeight()), 16, this, null, 0.0f, 0));
    }

    protected BehaviorController.b<Allay> brainProvider() {
        return BehaviorController.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    @Override
    protected BehaviorController<?> makeBrain(Dynamic<?> var0) {
        return AllayAi.makeBrain(this.brainProvider().makeBrain(var0));
    }

    public BehaviorController<Allay> getBrain() {
        return super.getBrain();
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MAX_HEALTH, 20.0).add(GenericAttributes.FLYING_SPEED, 0.1f).add(GenericAttributes.MOVEMENT_SPEED, 0.1f).add(GenericAttributes.ATTACK_DAMAGE, 2.0).add(GenericAttributes.FOLLOW_RANGE, 48.0);
    }

    @Override
    protected NavigationAbstract createNavigation(World var0) {
        NavigationFlying var1 = new NavigationFlying(this, var0);
        var1.setCanOpenDoors(false);
        var1.setCanFloat(true);
        var1.setCanPassDoors(true);
        return var1;
    }

    @Override
    public void travel(Vec3D var0) {
        if (this.isEffectiveAi() || this.isControlledByLocalInstance()) {
            if (this.isInWater()) {
                this.moveRelative(0.02f, var0);
                this.move(EnumMoveType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale(0.8f));
            } else if (this.isInLava()) {
                this.moveRelative(0.02f, var0);
                this.move(EnumMoveType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
            } else {
                this.moveRelative(this.getSpeed(), var0);
                this.move(EnumMoveType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale(0.91f));
            }
        }
        this.calculateEntityAnimation(this, false);
    }

    @Override
    protected float getStandingEyeHeight(EntityPose var0, EntitySize var1) {
        return var1.height * 0.6f;
    }

    @Override
    public boolean causeFallDamage(float var0, float var1, DamageSource var2) {
        return false;
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        Entity entity = var0.getEntity();
        if (entity instanceof EntityHuman) {
            EntityHuman var2 = (EntityHuman)entity;
            Optional<UUID> var3 = this.getBrain().getMemory(MemoryModuleType.LIKED_PLAYER);
            if (var3.isPresent() && var2.getUUID().equals(var3.get())) {
                return false;
            }
        }
        return super.hurt(var0, var1);
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
    }

    @Override
    protected void checkFallDamage(double var0, boolean var2, IBlockData var3, BlockPosition var4) {
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return this.hasItemInSlot(EnumItemSlot.MAINHAND) ? SoundEffects.ALLAY_AMBIENT_WITH_ITEM : SoundEffects.ALLAY_AMBIENT_WITHOUT_ITEM;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.ALLAY_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.ALLAY_DEATH;
    }

    @Override
    protected float getSoundVolume() {
        return 0.4f;
    }

    @Override
    protected void customServerAiStep() {
        this.level.getProfiler().push("allayBrain");
        this.getBrain().tick((WorldServer)this.level, this);
        this.level.getProfiler().pop();
        this.level.getProfiler().push("allayActivityUpdate");
        AllayAi.updateActivity(this);
        this.level.getProfiler().pop();
        super.customServerAiStep();
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.level.isClientSide && this.isAlive() && this.tickCount % 10 == 0) {
            this.heal(1.0f);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level.isClientSide) {
            this.holdingItemAnimationTicks0 = this.holdingItemAnimationTicks;
            this.holdingItemAnimationTicks = this.hasItemInHand() ? MathHelper.clamp(this.holdingItemAnimationTicks + 1.0f, 0.0f, 5.0f) : MathHelper.clamp(this.holdingItemAnimationTicks - 1.0f, 0.0f, 5.0f);
        } else {
            this.dynamicGameEventListener.getListener().tick(this.level);
        }
    }

    @Override
    public boolean canPickUpLoot() {
        return !this.isOnPickupCooldown() && this.hasItemInHand();
    }

    public boolean hasItemInHand() {
        return !this.getItemInHand(EnumHand.MAIN_HAND).isEmpty();
    }

    @Override
    public boolean canTakeItem(ItemStack var0) {
        return false;
    }

    private boolean isOnPickupCooldown() {
        return this.getBrain().checkMemory(MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS, MemoryStatus.VALUE_PRESENT);
    }

    @Override
    protected EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        ItemStack var3 = this.getItemInHand(EnumHand.MAIN_HAND);
        if (var3.isEmpty() && !var2.isEmpty()) {
            ItemStack var4 = var2.copy();
            var4.setCount(1);
            this.setItemInHand(EnumHand.MAIN_HAND, var4);
            if (!var0.getAbilities().instabuild) {
                var2.shrink(1);
            }
            this.level.playSound(var0, this, SoundEffects.ALLAY_ITEM_GIVEN, SoundCategory.NEUTRAL, 2.0f, 1.0f);
            this.getBrain().setMemory(MemoryModuleType.LIKED_PLAYER, var0.getUUID());
            return EnumInteractionResult.SUCCESS;
        }
        if (!var3.isEmpty() && var1 == EnumHand.MAIN_HAND && var2.isEmpty()) {
            this.setItemSlot(EnumItemSlot.MAINHAND, ItemStack.EMPTY);
            this.level.playSound(var0, this, SoundEffects.ALLAY_ITEM_TAKEN, SoundCategory.NEUTRAL, 2.0f, 1.0f);
            this.swing(EnumHand.MAIN_HAND);
            for (ItemStack var5 : this.getInventory().removeAllItems()) {
                BehaviorUtil.throwItem(this, var5, this.position());
            }
            this.getBrain().eraseMemory(MemoryModuleType.LIKED_PLAYER);
            var0.addItem(var3);
            return EnumInteractionResult.SUCCESS;
        }
        return super.mobInteract(var0, var1);
    }

    @Override
    public InventorySubcontainer getInventory() {
        return this.inventory;
    }

    @Override
    protected BaseBlockPosition getPickupReach() {
        return ITEM_PICKUP_REACH;
    }

    @Override
    public boolean wantsToPickUp(ItemStack var0) {
        ItemStack var1 = this.getItemInHand(EnumHand.MAIN_HAND);
        return !var1.isEmpty() && var1.sameItemStackIgnoreDurability(var0) && this.inventory.canAddItem(var0);
    }

    @Override
    protected void pickUpItem(EntityItem var0) {
        InventoryCarrier.pickUpItem(this, this, var0);
    }

    @Override
    protected void sendDebugPackets() {
        super.sendDebugPackets();
        PacketDebug.sendEntityBrain(this);
    }

    @Override
    public boolean isFlapping() {
        return !this.isOnGround();
    }

    @Override
    public void updateDynamicGameEventListener(BiConsumer<DynamicGameEventListener<?>, WorldServer> var0) {
        World world = this.level;
        if (world instanceof WorldServer) {
            WorldServer var1 = (WorldServer)world;
            var0.accept(this.dynamicGameEventListener, var1);
        }
    }

    public boolean isFlying() {
        return this.animationSpeed > 0.3f;
    }

    public float getHoldingItemAnimationProgress(float var0) {
        return MathHelper.lerp(var0, this.holdingItemAnimationTicks0, this.holdingItemAnimationTicks) / 5.0f;
    }

    @Override
    protected void dropEquipment() {
        super.dropEquipment();
        this.inventory.removeAllItems().forEach(this::spawnAtLocation);
        ItemStack var0 = this.getItemBySlot(EnumItemSlot.MAINHAND);
        if (!var0.isEmpty() && !EnchantmentManager.hasVanishingCurse(var0)) {
            this.spawnAtLocation(var0);
            this.setItemSlot(EnumItemSlot.MAINHAND, ItemStack.EMPTY);
        }
    }

    @Override
    public boolean removeWhenFarAway(double var0) {
        return false;
    }

    @Override
    public boolean shouldListen(WorldServer var0, GameEventListener var1, BlockPosition var2, GameEvent var3, GameEvent.a var4) {
        if (this.level != var0 || this.isRemoved() || this.isNoAi()) {
            return false;
        }
        if (!this.brain.hasMemoryValue(MemoryModuleType.LIKED_NOTEBLOCK_POSITION)) {
            return true;
        }
        Optional<GlobalPos> var5 = this.brain.getMemory(MemoryModuleType.LIKED_NOTEBLOCK_POSITION);
        return var5.isPresent() && var5.get().dimension() == var0.dimension() && var5.get().pos().equals(var2);
    }

    @Override
    public void onSignalReceive(WorldServer var0, GameEventListener var1, BlockPosition var2, GameEvent var3, @Nullable Entity var4, @Nullable Entity var5, float var6) {
        if (var3 == GameEvent.NOTE_BLOCK_PLAY) {
            AllayAi.hearNoteblock(this, new BlockPosition(var2));
        }
    }

    @Override
    public TagKey<GameEvent> getListenableEvents() {
        return GameEventTags.ALLAY_CAN_LISTEN;
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.put("Inventory", this.inventory.createTag());
        VibrationListener.codec(this).encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.dynamicGameEventListener.getListener()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var1 -> var0.put("listener", (NBTBase)var1));
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var02) {
        super.readAdditionalSaveData(var02);
        this.inventory.fromTag(var02.getList("Inventory", 10));
        if (var02.contains("listener", 10)) {
            VibrationListener.codec(this).parse(new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var02.getCompound("listener"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var0 -> this.dynamicGameEventListener.updateListener((VibrationListener)var0, this.level));
        }
    }

    @Override
    protected boolean shouldStayCloseToLeashHolder() {
        return false;
    }

    @Override
    public Iterable<BlockPosition> iteratePathfindingStartNodeCandidatePositions() {
        AxisAlignedBB var0 = this.getBoundingBox();
        int var1 = MathHelper.floor(var0.minX - 0.5);
        int var2 = MathHelper.floor(var0.maxX + 0.5);
        int var3 = MathHelper.floor(var0.minZ - 0.5);
        int var4 = MathHelper.floor(var0.maxZ + 0.5);
        int var5 = MathHelper.floor(var0.minY - 0.5);
        int var6 = MathHelper.floor(var0.maxY + 0.5);
        return BlockPosition.betweenClosed(var1, var5, var3, var2, var6, var4);
    }

    @Override
    public Vec3D getLeashOffset() {
        return new Vec3D(0.0, (double)this.getEyeHeight() * 0.6, (double)this.getBbWidth() * 0.1);
    }
}

