/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.player.EntityHuman;

public class SensorNearestPlayers
extends Sensor<EntityLiving> {
    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(MemoryModuleType.NEAREST_PLAYERS, MemoryModuleType.NEAREST_VISIBLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER);
    }

    @Override
    protected void doTick(WorldServer var0, EntityLiving var12) {
        List var2 = var0.players().stream().filter(IEntitySelector.NO_SPECTATORS).filter(var1 -> var12.closerThan((Entity)var1, 16.0)).sorted(Comparator.comparingDouble(var12::distanceToSqr)).collect(Collectors.toList());
        BehaviorController<?> var3 = var12.getBrain();
        var3.setMemory(MemoryModuleType.NEAREST_PLAYERS, var2);
        List var4 = var2.stream().filter(var1 -> SensorNearestPlayers.isEntityTargetable(var12, var1)).collect(Collectors.toList());
        var3.setMemory(MemoryModuleType.NEAREST_VISIBLE_PLAYER, var4.isEmpty() ? null : (EntityHuman)var4.get(0));
        Optional<EntityHuman> var5 = var4.stream().filter(var1 -> SensorNearestPlayers.isEntityAttackable(var12, var1)).findFirst();
        var3.setMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, var5);
    }
}

