/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.item.EntityItem;

public class SensorNearestItems
extends Sensor<EntityInsentient> {
    private static final long XZ_RANGE = 32L;
    private static final long Y_RANGE = 16L;
    public static final int MAX_DISTANCE_TO_WANTED_ITEM = 32;

    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM);
    }

    @Override
    protected void doTick(WorldServer var02, EntityInsentient var12) {
        BehaviorController<?> var2 = var12.getBrain();
        List<EntityItem> var3 = var02.getEntitiesOfClass(EntityItem.class, var12.getBoundingBox().inflate(32.0, 16.0, 32.0), var0 -> true);
        var3.sort(Comparator.comparingDouble(var12::distanceToSqr));
        Optional<EntityItem> var4 = var3.stream().filter(var1 -> var12.wantsToPickUp(var1.getItem())).filter(var1 -> var1.closerThan(var12, 32.0)).filter(var12::hasLineOfSight).findFirst();
        var2.setMemory(MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, var4);
    }
}

