/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior.warden;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.Unit;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.warden.Warden;

public class TryToSniff
extends Behavior<Warden> {
    private static final IntProvider SNIFF_COOLDOWN = UniformInt.of(100, 200);

    public TryToSniff() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.SNIFF_COOLDOWN, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.NEAREST_ATTACKABLE, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.DISTURBANCE_LOCATION, (Object)((Object)MemoryStatus.VALUE_ABSENT)));
    }

    @Override
    protected void start(WorldServer var0, Warden var1, long var2) {
        BehaviorController<Warden> var4 = var1.getBrain();
        var4.setMemory(MemoryModuleType.IS_SNIFFING, Unit.INSTANCE);
        var4.setMemoryWithExpiry(MemoryModuleType.SNIFF_COOLDOWN, Unit.INSTANCE, SNIFF_COOLDOWN.sample(var0.getRandom()));
        var4.eraseMemory(MemoryModuleType.WALK_TARGET);
        var1.setPose(EntityPose.SNIFFING);
    }
}

