/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class GoToTargetLocation<E extends EntityInsentient>
extends Behavior<E> {
    private final MemoryModuleType<BlockPosition> locationMemory;
    private final int closeEnoughDist;
    private final float speedModifier;

    public GoToTargetLocation(MemoryModuleType<BlockPosition> var0, int var1, float var2) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(var0, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED)));
        this.locationMemory = var0;
        this.closeEnoughDist = var1;
        this.speedModifier = var2;
    }

    @Override
    protected void start(WorldServer var0, EntityInsentient var1, long var2) {
        BlockPosition var4 = this.getTargetLocation(var1);
        boolean var5 = var4.closerThan(var1.blockPosition(), this.closeEnoughDist);
        if (!var5) {
            BehaviorUtil.setWalkAndLookTargetMemories((EntityLiving)var1, GoToTargetLocation.getNearbyPos(var1, var4), this.speedModifier, this.closeEnoughDist);
        }
    }

    private static BlockPosition getNearbyPos(EntityInsentient var0, BlockPosition var1) {
        RandomSource var2 = var0.level.random;
        return var1.offset(GoToTargetLocation.getRandomOffset(var2), 0, GoToTargetLocation.getRandomOffset(var2));
    }

    private static int getRandomOffset(RandomSource var0) {
        return var0.nextInt(3) - 1;
    }

    private BlockPosition getTargetLocation(EntityInsentient var0) {
        return var0.getBrain().getMemory(this.locationMemory).get();
    }
}

