/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.phys.Vec3D;

public class BehaviorWalkAwayBlock
extends Behavior<EntityVillager> {
    private final MemoryModuleType<GlobalPos> memoryType;
    private final float speedModifier;
    private final int closeEnoughDist;
    private final int tooFarDistance;
    private final int tooLongUnreachableDuration;

    public BehaviorWalkAwayBlock(MemoryModuleType<GlobalPos> var0, float var1, int var2, int var3, int var4) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), var0, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
        this.memoryType = var0;
        this.speedModifier = var1;
        this.closeEnoughDist = var2;
        this.tooFarDistance = var3;
        this.tooLongUnreachableDuration = var4;
    }

    private void dropPOI(EntityVillager var0, long var1) {
        BehaviorController<EntityVillager> var3 = var0.getBrain();
        var0.releasePoi(this.memoryType);
        var3.eraseMemory(this.memoryType);
        var3.setMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, var1);
    }

    @Override
    protected void start(WorldServer var0, EntityVillager var1, long var2) {
        BehaviorController<EntityVillager> var4 = var1.getBrain();
        var4.getMemory(this.memoryType).ifPresent(var5 -> {
            if (this.wrongDimension(var0, (GlobalPos)var5) || this.tiredOfTryingToFindTarget(var0, var1)) {
                this.dropPOI(var1, var2);
            } else if (this.tooFar(var1, (GlobalPos)var5)) {
                int var7;
                Vec3D var6 = null;
                int var8 = 1000;
                for (var7 = 0; var7 < 1000 && (var6 == null || this.tooFar(var1, GlobalPos.of(var0.dimension(), new BlockPosition(var6)))); ++var7) {
                    var6 = DefaultRandomPos.getPosTowards(var1, 15, 7, Vec3D.atBottomCenterOf(var5.pos()), 1.5707963705062866);
                }
                if (var7 == 1000) {
                    this.dropPOI(var1, var2);
                    return;
                }
                var4.setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(var6, this.speedModifier, this.closeEnoughDist));
            } else if (!this.closeEnough(var0, var1, (GlobalPos)var5)) {
                var4.setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(var5.pos(), this.speedModifier, this.closeEnoughDist));
            }
        });
    }

    private boolean tiredOfTryingToFindTarget(WorldServer var0, EntityVillager var1) {
        Optional<Long> var2 = var1.getBrain().getMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        if (var2.isPresent()) {
            return var0.getGameTime() - var2.get() > (long)this.tooLongUnreachableDuration;
        }
        return false;
    }

    private boolean tooFar(EntityVillager var0, GlobalPos var1) {
        return var1.pos().distManhattan(var0.blockPosition()) > this.tooFarDistance;
    }

    private boolean wrongDimension(WorldServer var0, GlobalPos var1) {
        return var1.dimension() != var0.dimension();
    }

    private boolean closeEnough(WorldServer var0, EntityVillager var1, GlobalPos var2) {
        return var2.dimension() == var0.dimension() && var2.pos().distManhattan(var1.blockPosition()) <= this.closeEnoughDist;
    }
}

