/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;

public class BehaviorStrollInside
extends Behavior<EntityCreature> {
    private final float speedModifier;

    public BehaviorStrollInside(float var0) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)));
        this.speedModifier = var0;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityCreature var1) {
        return !var0.canSeeSky(var1.blockPosition());
    }

    @Override
    protected void start(WorldServer var0, EntityCreature var12, long var22) {
        BlockPosition var4 = var12.blockPosition();
        List var5 = BlockPosition.betweenClosedStream(var4.offset(-1, -1, -1), var4.offset(1, 1, 1)).map(BlockPosition::immutable).collect(Collectors.toList());
        Collections.shuffle(var5);
        Optional<BlockPosition> var6 = var5.stream().filter(var1 -> !var0.canSeeSky((BlockPosition)var1)).filter(var2 -> var0.loadedAndEntityCanStandOn((BlockPosition)var2, var12)).filter(var2 -> var0.noCollision(var12)).findFirst();
        var6.ifPresent(var1 -> var12.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget((BlockPosition)var1, this.speedModifier, 0)));
    }
}

