/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.Vec3D;

public class BehaviorOutside
extends Behavior<EntityLiving> {
    private final float speedModifier;

    public BehaviorOutside(float var0) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)));
        this.speedModifier = var0;
    }

    @Override
    protected void start(WorldServer var02, EntityLiving var1, long var2) {
        Optional<Vec3D> var4 = Optional.ofNullable(this.getOutdoorPosition(var02, var1));
        if (var4.isPresent()) {
            var1.getBrain().setMemory(MemoryModuleType.WALK_TARGET, var4.map(var0 -> new MemoryTarget((Vec3D)var0, this.speedModifier, 0)));
        }
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityLiving var1) {
        return !var0.canSeeSky(var1.blockPosition());
    }

    @Nullable
    private Vec3D getOutdoorPosition(WorldServer var0, EntityLiving var1) {
        RandomSource var2 = var1.getRandom();
        BlockPosition var3 = var1.blockPosition();
        for (int var4 = 0; var4 < 10; ++var4) {
            BlockPosition var5 = var3.offset(var2.nextInt(20) - 10, var2.nextInt(6) - 3, var2.nextInt(20) - 10);
            if (!BehaviorOutside.hasNoBlocksAbove(var0, var1, var5)) continue;
            return Vec3D.atBottomCenterOf(var5);
        }
        return null;
    }

    public static boolean hasNoBlocksAbove(WorldServer var0, EntityLiving var1, BlockPosition var2) {
        return var0.canSeeSky(var2) && (double)var0.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING, var2).getY() <= var1.getY();
    }
}

