/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.phys.Vec3D;

public class BehaviorNearestVillage
extends Behavior<EntityVillager> {
    private final float speedModifier;
    private final int closeEnoughDistance;

    public BehaviorNearestVillage(float var0, int var1) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)));
        this.speedModifier = var0;
        this.closeEnoughDistance = var1;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityVillager var1) {
        return !var0.isVillage(var1.blockPosition());
    }

    @Override
    protected void start(WorldServer var0, EntityVillager var12, long var2) {
        VillagePlace var4 = var0.getPoiManager();
        int var5 = var4.sectionsToVillage(SectionPosition.of(var12.blockPosition()));
        Vec3D var6 = null;
        for (int var7 = 0; var7 < 5; ++var7) {
            Vec3D var8 = LandRandomPos.getPos(var12, 15, 7, var1 -> -var4.sectionsToVillage(SectionPosition.of(var1)));
            if (var8 == null) continue;
            int var9 = var4.sectionsToVillage(SectionPosition.of(new BlockPosition(var8)));
            if (var9 < var5) {
                var6 = var8;
                break;
            }
            if (var9 != var5) continue;
            var6 = var8;
        }
        if (var6 != null) {
            var12.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(var6, this.speedModifier, this.closeEnoughDistance));
        }
    }
}

