/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;

public class BehaviorLookInteract
extends Behavior<EntityLiving> {
    private final EntityTypes<?> type;
    private final int interactionRangeSqr;
    private final Predicate<EntityLiving> targetFilter;
    private final Predicate<EntityLiving> selfFilter;

    public BehaviorLookInteract(EntityTypes<?> var0, int var1, Predicate<EntityLiving> var2, Predicate<EntityLiving> var3) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.INTERACTION_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
        this.type = var0;
        this.interactionRangeSqr = var1 * var1;
        this.targetFilter = var3;
        this.selfFilter = var2;
    }

    public BehaviorLookInteract(EntityTypes<?> var02, int var1) {
        this(var02, var1, var0 -> true, var0 -> true);
    }

    @Override
    public boolean checkExtraStartConditions(WorldServer var0, EntityLiving var1) {
        return this.selfFilter.test(var1) && this.getVisibleEntities(var1).contains(this::isMatchingTarget);
    }

    @Override
    public void start(WorldServer var0, EntityLiving var13, long var2) {
        super.start(var0, var13, var2);
        BehaviorController<?> var4 = var13.getBrain();
        var4.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).flatMap(var12 -> var12.findClosest(var1 -> var1.distanceToSqr(var13) <= (double)this.interactionRangeSqr && this.isMatchingTarget((EntityLiving)var1))).ifPresent(var1 -> {
            var4.setMemory(MemoryModuleType.INTERACTION_TARGET, var1);
            var4.setMemory(MemoryModuleType.LOOK_TARGET, new BehaviorPositionEntity((Entity)var1, true));
        });
    }

    private boolean isMatchingTarget(EntityLiving var0) {
        return this.type.equals(var0.getType()) && this.targetFilter.test(var0);
    }

    private NearestVisibleLivingEntities getVisibleEntities(EntityLiving var0) {
        return var0.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).get();
    }
}

