/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;

public class BehaviorHome
extends Behavior<EntityLiving> {
    private final float speedModifier;
    private final int radius;
    private final int closeEnoughDist;
    private Optional<BlockPosition> currentPos = Optional.empty();

    public BehaviorHome(int var0, float var1, int var2) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.HOME, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.HIDING_PLACE, (Object)((Object)MemoryStatus.REGISTERED)));
        this.radius = var0;
        this.speedModifier = var1;
        this.closeEnoughDist = var2;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var02, EntityLiving var1) {
        Optional<BlockPosition> var2 = var02.getPoiManager().find(var0 -> var0.is(PoiTypes.HOME), var0 -> true, var1.blockPosition(), this.closeEnoughDist + 1, VillagePlace.Occupancy.ANY);
        this.currentPos = var2.isPresent() && var2.get().closerToCenterThan(var1.position(), this.closeEnoughDist) ? var2 : Optional.empty();
        return true;
    }

    @Override
    protected void start(WorldServer var02, EntityLiving var1, long var2) {
        Optional<GlobalPos> var6;
        BehaviorController<?> var4 = var1.getBrain();
        Optional<BlockPosition> var5 = this.currentPos;
        if (var5.isEmpty() && (var5 = var02.getPoiManager().getRandom(var0 -> var0.is(PoiTypes.HOME), var0 -> true, VillagePlace.Occupancy.ANY, var1.blockPosition(), this.radius, var1.getRandom())).isEmpty() && (var6 = var4.getMemory(MemoryModuleType.HOME)).isPresent()) {
            var5 = Optional.of(var6.get().pos());
        }
        if (var5.isPresent()) {
            var4.eraseMemory(MemoryModuleType.PATH);
            var4.eraseMemory(MemoryModuleType.LOOK_TARGET);
            var4.eraseMemory(MemoryModuleType.BREED_TARGET);
            var4.eraseMemory(MemoryModuleType.INTERACTION_TARGET);
            var4.setMemory(MemoryModuleType.HIDING_PLACE, GlobalPos.of(var02.dimension(), var5.get()));
            if (!var5.get().closerToCenterThan(var1.position(), this.closeEnoughDist)) {
                var4.setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(var5.get(), this.speedModifier, this.closeEnoughDist));
            }
        }
    }
}

