/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.google.common.collect.ComparisonChain;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.EntityLiving;
import org.slf4j.Logger;

public class MobEffect
implements Comparable<MobEffect> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final MobEffectList effect;
    int duration;
    private int amplifier;
    private boolean ambient;
    private boolean noCounter;
    private boolean visible;
    private boolean showIcon;
    @Nullable
    private MobEffect hiddenEffect;
    private Optional<a> factorData;

    public MobEffect(MobEffectList var0) {
        this(var0, 0, 0);
    }

    public MobEffect(MobEffectList var0, int var1) {
        this(var0, var1, 0);
    }

    public MobEffect(MobEffectList var0, int var1, int var2) {
        this(var0, var1, var2, false, true);
    }

    public MobEffect(MobEffectList var0, int var1, int var2, boolean var3, boolean var4) {
        this(var0, var1, var2, var3, var4, var4);
    }

    public MobEffect(MobEffectList var0, int var1, int var2, boolean var3, boolean var4, boolean var5) {
        this(var0, var1, var2, var3, var4, var5, null, var0.createFactorData());
    }

    public MobEffect(MobEffectList var0, int var1, int var2, boolean var3, boolean var4, boolean var5, @Nullable MobEffect var6, Optional<a> var7) {
        this.effect = var0;
        this.duration = var1;
        this.amplifier = var2;
        this.ambient = var3;
        this.visible = var4;
        this.showIcon = var5;
        this.hiddenEffect = var6;
        this.factorData = var7;
    }

    public MobEffect(MobEffect var0) {
        this.effect = var0.effect;
        this.factorData = this.effect.createFactorData();
        this.setDetailsFrom(var0);
    }

    public Optional<a> getFactorData() {
        return this.factorData;
    }

    void setDetailsFrom(MobEffect var0) {
        this.duration = var0.duration;
        this.amplifier = var0.amplifier;
        this.ambient = var0.ambient;
        this.visible = var0.visible;
        this.showIcon = var0.showIcon;
    }

    public boolean update(MobEffect var0) {
        if (this.effect != var0.effect) {
            LOGGER.warn("This method should only be called for matching effects!");
        }
        int var12 = this.duration;
        boolean var2 = false;
        if (var0.amplifier > this.amplifier) {
            if (var0.duration < this.duration) {
                MobEffect var3 = this.hiddenEffect;
                this.hiddenEffect = new MobEffect(this);
                this.hiddenEffect.hiddenEffect = var3;
            }
            this.amplifier = var0.amplifier;
            this.duration = var0.duration;
            var2 = true;
        } else if (var0.duration > this.duration) {
            if (var0.amplifier == this.amplifier) {
                this.duration = var0.duration;
                var2 = true;
            } else if (this.hiddenEffect == null) {
                this.hiddenEffect = new MobEffect(var0);
            } else {
                this.hiddenEffect.update(var0);
            }
        }
        if (!var0.ambient && this.ambient || var2) {
            this.ambient = var0.ambient;
            var2 = true;
        }
        if (var0.visible != this.visible) {
            this.visible = var0.visible;
            var2 = true;
        }
        if (var0.showIcon != this.showIcon) {
            this.showIcon = var0.showIcon;
            var2 = true;
        }
        if (var12 != this.duration) {
            this.factorData.ifPresent(var1 -> var1.effectChangedTimestamp += this.duration - var12);
            var2 = true;
        }
        return var2;
    }

    public MobEffectList getEffect() {
        return this.effect;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public boolean isAmbient() {
        return this.ambient;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean showIcon() {
        return this.showIcon;
    }

    public boolean tick(EntityLiving var02, Runnable var1) {
        if (this.duration > 0) {
            if (this.effect.isDurationEffectTick(this.duration, this.amplifier)) {
                this.applyEffect(var02);
            }
            this.tickDownDuration();
            if (this.duration == 0 && this.hiddenEffect != null) {
                this.setDetailsFrom(this.hiddenEffect);
                this.hiddenEffect = this.hiddenEffect.hiddenEffect;
                var1.run();
            }
        }
        this.factorData.ifPresent(var0 -> var0.update(this));
        return this.duration > 0;
    }

    private int tickDownDuration() {
        if (this.hiddenEffect != null) {
            this.hiddenEffect.tickDownDuration();
        }
        return --this.duration;
    }

    public void applyEffect(EntityLiving var0) {
        if (this.duration > 0) {
            this.effect.applyEffectTick(var0, this.amplifier);
        }
    }

    public String getDescriptionId() {
        return this.effect.getDescriptionId();
    }

    public String toString() {
        String var0 = this.amplifier > 0 ? this.getDescriptionId() + " x " + (this.amplifier + 1) + ", Duration: " + this.duration : this.getDescriptionId() + ", Duration: " + this.duration;
        if (!this.visible) {
            var0 = var0 + ", Particles: false";
        }
        if (!this.showIcon) {
            var0 = var0 + ", Show Icon: false";
        }
        return var0;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof MobEffect) {
            MobEffect var1 = (MobEffect)var0;
            return this.duration == var1.duration && this.amplifier == var1.amplifier && this.ambient == var1.ambient && this.effect.equals(var1.effect);
        }
        return false;
    }

    public int hashCode() {
        int var0 = this.effect.hashCode();
        var0 = 31 * var0 + this.duration;
        var0 = 31 * var0 + this.amplifier;
        var0 = 31 * var0 + (this.ambient ? 1 : 0);
        return var0;
    }

    public NBTTagCompound save(NBTTagCompound var0) {
        var0.putInt("Id", MobEffectList.getId(this.getEffect()));
        this.writeDetailsTo(var0);
        return var0;
    }

    private void writeDetailsTo(NBTTagCompound var0) {
        var0.putByte("Amplifier", (byte)this.getAmplifier());
        var0.putInt("Duration", this.getDuration());
        var0.putBoolean("Ambient", this.isAmbient());
        var0.putBoolean("ShowParticles", this.isVisible());
        var0.putBoolean("ShowIcon", this.showIcon());
        if (this.hiddenEffect != null) {
            NBTTagCompound var1 = new NBTTagCompound();
            this.hiddenEffect.save(var1);
            var0.put("HiddenEffect", var1);
        }
        this.factorData.ifPresent(var12 -> a.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, var12).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var1 -> var0.put("FactorCalculationData", (NBTBase)var1)));
    }

    @Nullable
    public static MobEffect load(NBTTagCompound var0) {
        int var1 = var0.getInt("Id");
        MobEffectList var2 = MobEffectList.byId(var1);
        if (var2 == null) {
            return null;
        }
        return MobEffect.loadSpecifiedEffect(var2, var0);
    }

    private static MobEffect loadSpecifiedEffect(MobEffectList var0, NBTTagCompound var1) {
        byte var2 = var1.getByte("Amplifier");
        int var3 = var1.getInt("Duration");
        boolean var4 = var1.getBoolean("Ambient");
        boolean var5 = true;
        if (var1.contains("ShowParticles", 1)) {
            var5 = var1.getBoolean("ShowParticles");
        }
        boolean var6 = var5;
        if (var1.contains("ShowIcon", 1)) {
            var6 = var1.getBoolean("ShowIcon");
        }
        MobEffect var7 = null;
        if (var1.contains("HiddenEffect", 10)) {
            var7 = MobEffect.loadSpecifiedEffect(var0, var1.getCompound("HiddenEffect"));
        }
        Optional var8 = var1.contains("FactorCalculationData", 10) ? a.CODEC.parse(new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var1.getCompound("FactorCalculationData"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)) : Optional.empty();
        return new MobEffect(var0, var3, Math.max(var2, 0), var4, var5, var6, var7, var8);
    }

    public void setNoCounter(boolean var0) {
        this.noCounter = var0;
    }

    public boolean isNoCounter() {
        return this.noCounter;
    }

    @Override
    public int compareTo(MobEffect var0) {
        int var1 = 32147;
        if (this.getDuration() > 32147 && var0.getDuration() > 32147 || this.isAmbient() && var0.isAmbient()) {
            return ComparisonChain.start().compare(Boolean.valueOf(this.isAmbient()), Boolean.valueOf(var0.isAmbient())).compare(this.getEffect().getColor(), var0.getEffect().getColor()).result();
        }
        return ComparisonChain.start().compare(Boolean.valueOf(this.isAmbient()), Boolean.valueOf(var0.isAmbient())).compare(this.getDuration(), var0.getDuration()).compare(this.getEffect().getColor(), var0.getEffect().getColor()).result();
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.compareTo((MobEffect)object);
    }

    public static class a {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("padding_duration").forGetter(var0 -> var0.paddingDuration), (App)Codec.FLOAT.fieldOf("factor_start").orElse((Object)Float.valueOf(0.0f)).forGetter(var0 -> Float.valueOf(var0.factorStart)), (App)Codec.FLOAT.fieldOf("factor_target").orElse((Object)Float.valueOf(1.0f)).forGetter(var0 -> Float.valueOf(var0.factorTarget)), (App)Codec.FLOAT.fieldOf("factor_current").orElse((Object)Float.valueOf(0.0f)).forGetter(var0 -> Float.valueOf(var0.factorCurrent)), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("effect_changed_timestamp").orElse((Object)0).forGetter(var0 -> var0.effectChangedTimestamp), (App)Codec.FLOAT.fieldOf("factor_previous_frame").orElse((Object)Float.valueOf(0.0f)).forGetter(var0 -> Float.valueOf(var0.factorPreviousFrame)), (App)Codec.BOOL.fieldOf("had_effect_last_tick").orElse((Object)false).forGetter(var0 -> var0.hadEffectLastTick)).apply((Applicative)var02, a::new));
        private final int paddingDuration;
        private float factorStart;
        private float factorTarget;
        private float factorCurrent;
        int effectChangedTimestamp;
        private float factorPreviousFrame;
        private boolean hadEffectLastTick;

        public a(int var0, float var1, float var2, float var3, int var4, float var5, boolean var6) {
            this.paddingDuration = var0;
            this.factorStart = var1;
            this.factorTarget = var2;
            this.factorCurrent = var3;
            this.effectChangedTimestamp = var4;
            this.factorPreviousFrame = var5;
            this.hadEffectLastTick = var6;
        }

        public a(int var0) {
            this(var0, 0.0f, 1.0f, 0.0f, 0, 0.0f, false);
        }

        public void update(MobEffect var0) {
            boolean var1;
            this.factorPreviousFrame = this.factorCurrent;
            boolean bl = var1 = var0.duration > this.paddingDuration;
            if (this.hadEffectLastTick != var1) {
                this.hadEffectLastTick = var1;
                this.effectChangedTimestamp = var0.duration;
                this.factorStart = this.factorCurrent;
                this.factorTarget = var1 ? 1.0f : 0.0f;
            }
            float var2 = MathHelper.clamp(((float)this.effectChangedTimestamp - (float)var0.duration) / (float)this.paddingDuration, 0.0f, 1.0f);
            this.factorCurrent = MathHelper.lerp(var2, this.factorStart, this.factorTarget);
        }

        public float getFactor(EntityLiving var0, float var1) {
            if (var0.isRemoved()) {
                this.factorPreviousFrame = this.factorCurrent;
            }
            return MathHelper.lerp(var1, this.factorPreviousFrame, this.factorCurrent);
        }
    }
}

