/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.worldupdate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMaps;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenCustomHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.slf4j.Logger;

public class WorldUpgrader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setDaemon(true).build();
    private final GeneratorSettings worldGenSettings;
    private final boolean eraseCache;
    private final Convertable.ConversionSession levelStorage;
    private final Thread thread;
    private final DataFixer dataFixer;
    private volatile boolean running = true;
    private volatile boolean finished;
    private volatile float progress;
    private volatile int totalChunks;
    private volatile int converted;
    private volatile int skipped;
    private final Object2FloatMap<ResourceKey<World>> progressMap = Object2FloatMaps.synchronize((Object2FloatMap)new Object2FloatOpenCustomHashMap(SystemUtils.identityStrategy()));
    private volatile IChatBaseComponent status = IChatBaseComponent.translatable("optimizeWorld.stage.counting");
    private static final Pattern REGEX = Pattern.compile("^r\\.(-?[0-9]+)\\.(-?[0-9]+)\\.mca$");
    private final WorldPersistentData overworldDataStorage;

    public WorldUpgrader(Convertable.ConversionSession var02, DataFixer var12, GeneratorSettings var2, boolean var3) {
        this.worldGenSettings = var2;
        this.eraseCache = var3;
        this.dataFixer = var12;
        this.levelStorage = var02;
        this.overworldDataStorage = new WorldPersistentData(this.levelStorage.getDimensionPath(World.OVERWORLD).resolve("data").toFile(), var12);
        this.thread = THREAD_FACTORY.newThread(this::work);
        this.thread.setUncaughtExceptionHandler((var0, var1) -> {
            LOGGER.error("Error upgrading world", var1);
            this.status = IChatBaseComponent.translatable("optimizeWorld.stage.failed");
            this.finished = true;
        });
        this.thread.start();
    }

    public void cancel() {
        this.running = false;
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void work() {
        ImmutableMap.Builder var4;
        ResourceKey var32;
        this.totalChunks = 0;
        ImmutableMap.Builder var0 = ImmutableMap.builder();
        ImmutableSet<ResourceKey<World>> var1 = this.worldGenSettings.levels();
        for (ResourceKey var32 : var1) {
            var4 = this.getAllChunkPos(var32);
            var0.put((Object)var32, var4.listIterator());
            this.totalChunks += var4.size();
        }
        if (this.totalChunks == 0) {
            this.finished = true;
            return;
        }
        float var2 = this.totalChunks;
        var32 = var0.build();
        var4 = ImmutableMap.builder();
        for (ResourceKey var6 : var1) {
            Path var7 = this.levelStorage.getDimensionPath(var6);
            var4.put((Object)var6, (Object)new IChunkLoader(var7.resolve("region"), this.dataFixer, true));
        }
        ImmutableMap var5 = var4.build();
        long var6 = SystemUtils.getMillis();
        this.status = IChatBaseComponent.translatable("optimizeWorld.stage.upgrading");
        while (this.running) {
            boolean var8 = false;
            float var9 = 0.0f;
            for (ResourceKey var11 : var1) {
                ListIterator var12 = (ListIterator)var32.get(var11);
                IChunkLoader var13 = (IChunkLoader)var5.get((Object)var11);
                if (var12.hasNext()) {
                    ChunkCoordIntPair var14 = (ChunkCoordIntPair)var12.next();
                    boolean var15 = false;
                    try {
                        NBTTagCompound var16 = var13.read(var14).join().orElse(null);
                        if (var16 != null) {
                            boolean var21;
                            int var17 = IChunkLoader.getVersion(var16);
                            ChunkGenerator var18 = this.worldGenSettings.dimensions().get(GeneratorSettings.levelToLevelStem(var11)).generator();
                            NBTTagCompound var19 = var13.upgradeChunkTag(var11, () -> this.overworldDataStorage, var16, var18.getTypeNameForDataFixer());
                            ChunkCoordIntPair var20 = new ChunkCoordIntPair(var19.getInt("xPos"), var19.getInt("zPos"));
                            if (!var20.equals(var14)) {
                                LOGGER.warn("Chunk {} has invalid position {}", (Object)var14, (Object)var20);
                            }
                            boolean bl = var21 = var17 < SharedConstants.getCurrentVersion().getWorldVersion();
                            if (this.eraseCache) {
                                var21 = var21 || var19.contains("Heightmaps");
                                var19.remove("Heightmaps");
                                var21 = var21 || var19.contains("isLightOn");
                                var19.remove("isLightOn");
                                NBTTagList var22 = var19.getList("sections", 10);
                                for (int var23 = 0; var23 < var22.size(); ++var23) {
                                    NBTTagCompound var24 = var22.getCompound(var23);
                                    var21 = var21 || var24.contains("BlockLight");
                                    var24.remove("BlockLight");
                                    var21 = var21 || var24.contains("SkyLight");
                                    var24.remove("SkyLight");
                                }
                            }
                            if (var21) {
                                var13.write(var14, var19);
                                var15 = true;
                            }
                        }
                    }
                    catch (CompletionException | ReportedException var16) {
                        Throwable var17 = var16.getCause();
                        if (var17 instanceof IOException) {
                            LOGGER.error("Error upgrading chunk {}", (Object)var14, (Object)var17);
                        }
                        throw var16;
                    }
                    if (var15) {
                        ++this.converted;
                    } else {
                        ++this.skipped;
                    }
                    var8 = true;
                }
                float var14 = (float)var12.nextIndex() / var2;
                this.progressMap.put((Object)var11, var14);
                var9 += var14;
            }
            this.progress = var9;
            if (var8) continue;
            this.running = false;
        }
        this.status = IChatBaseComponent.translatable("optimizeWorld.stage.finished");
        for (IChunkLoader var9 : var5.values()) {
            try {
                var9.close();
            }
            catch (IOException var10) {
                LOGGER.error("Error upgrading chunk", (Throwable)var10);
            }
        }
        this.overworldDataStorage.save();
        var6 = SystemUtils.getMillis() - var6;
        LOGGER.info("World optimizaton finished after {} ms", (Object)var6);
        this.finished = true;
    }

    private List<ChunkCoordIntPair> getAllChunkPos(ResourceKey<World> var02) {
        File var12 = this.levelStorage.getDimensionPath(var02).toFile();
        File var2 = new File(var12, "region");
        File[] var3 = var2.listFiles((var0, var1) -> var1.endsWith(".mca"));
        if (var3 == null) {
            return ImmutableList.of();
        }
        ArrayList var4 = Lists.newArrayList();
        for (File var8 : var3) {
            Matcher var9 = REGEX.matcher(var8.getName());
            if (!var9.matches()) continue;
            int var10 = Integer.parseInt(var9.group(1)) << 5;
            int var11 = Integer.parseInt(var9.group(2)) << 5;
            try (RegionFile var122 = new RegionFile(var8.toPath(), var2.toPath(), true);){
                for (int var13 = 0; var13 < 32; ++var13) {
                    for (int var14 = 0; var14 < 32; ++var14) {
                        ChunkCoordIntPair var15 = new ChunkCoordIntPair(var13 + var10, var14 + var11);
                        if (!var122.doesChunkExist(var15)) continue;
                        var4.add(var15);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return var4;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public ImmutableSet<ResourceKey<World>> levels() {
        return this.worldGenSettings.levels();
    }

    public float dimensionProgress(ResourceKey<World> var0) {
        return this.progressMap.getFloat(var0);
    }

    public float getProgress() {
        return this.progress;
    }

    public int getTotalChunks() {
        return this.totalChunks;
    }

    public int getConverted() {
        return this.converted;
    }

    public int getSkipped() {
        return this.skipped;
    }

    public IChatBaseComponent getStatus() {
        return this.status;
    }
}

