/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public abstract class ItemStackTagFix
extends DataFix {
    private final String name;
    private final Predicate<String> idFilter;

    public ItemStackTagFix(Schema var0, String var1, Predicate<String> var2) {
        super(var0, false);
        this.name = var1;
        this.idFilter = var2;
    }

    public final TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(DataConverterTypes.ITEM_STACK);
        OpticFinder var1 = DSL.fieldFinder((String)"id", (Type)DSL.named((String)DataConverterTypes.ITEM_NAME.typeName(), DataConverterSchemaNamed.namespacedString()));
        OpticFinder var22 = var0.findField("tag");
        return this.fixTypeEverywhereTyped(this.name, var0, var2 -> {
            Optional var3 = var2.getOptional(var1);
            if (var3.isPresent() && this.idFilter.test((String)((Pair)var3.get()).getSecond())) {
                return var2.updateTyped(var22, var0 -> var0.update(DSL.remainderFinder(), this::fixItemStackTag));
            }
            return var2;
        });
    }

    protected abstract <T> Dynamic<T> fixItemStackTag(Dynamic<T> var1);
}

