/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.datafix.fixes.DataConverterSignText;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.apache.commons.lang3.StringUtils;

public class DataConverterBook
extends DataFix {
    public DataConverterBook(Schema var0, boolean var1) {
        super(var0, var1);
    }

    public Dynamic<?> fixTag(Dynamic<?> var0) {
        return var0.update("pages", var1 -> (Dynamic)DataFixUtils.orElse((Optional)var1.asStreamOpt().map(var02 -> var02.map(var0 -> {
            if (!var0.asString().result().isPresent()) {
                return var0;
            }
            Object var1 = var0.asString("");
            IChatBaseComponent var2 = null;
            if ("null".equals(var1) || StringUtils.isEmpty((CharSequence)var1)) {
                var2 = CommonComponents.EMPTY;
            } else if (var1.charAt(0) == '\"' && var1.charAt(var1.length() - 1) == '\"' || var1.charAt(0) == '{' && var1.charAt(var1.length() - 1) == '}') {
                try {
                    var2 = ChatDeserializer.fromJson(DataConverterSignText.GSON, var1, IChatBaseComponent.class, true);
                    if (var2 == null) {
                        var2 = CommonComponents.EMPTY;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (var2 == null) {
                    try {
                        var2 = IChatBaseComponent.ChatSerializer.fromJson(var1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (var2 == null) {
                    try {
                        var2 = IChatBaseComponent.ChatSerializer.fromJsonLenient(var1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (var2 == null) {
                    var2 = IChatBaseComponent.literal(var1);
                }
            } else {
                var2 = IChatBaseComponent.literal(var1);
            }
            return var0.createString(IChatBaseComponent.ChatSerializer.toJson(var2));
        })).map(arg_0 -> ((Dynamic)var0).createList(arg_0)).result(), (Object)var0.emptyList()));
    }

    public TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(DataConverterTypes.ITEM_STACK);
        OpticFinder var12 = var0.findField("tag");
        return this.fixTypeEverywhereTyped("ItemWrittenBookPagesStrictJsonFix", var0, var1 -> var1.updateTyped(var12, var0 -> var0.update(DSL.remainderFinder(), this::fixTag)));
    }
}

