/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import java.util.Map;
import java.util.Objects;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class DataConverterBiomeBase
extends DataFix {
    private final String name;
    private final Map<String, String> biomes;

    public DataConverterBiomeBase(Schema var0, boolean var1, String var2, Map<String, String> var3) {
        super(var0, var1);
        this.biomes = var3;
        this.name = var2;
    }

    protected TypeRewriteRule makeRule() {
        Type var02 = DSL.named((String)DataConverterTypes.BIOME.typeName(), DataConverterSchemaNamed.namespacedString());
        if (!Objects.equals(var02, this.getInputSchema().getType(DataConverterTypes.BIOME))) {
            throw new IllegalStateException("Biome type is not what was expected.");
        }
        return this.fixTypeEverywhere(this.name, var02, var0 -> var02 -> var02.mapSecond(var0 -> this.biomes.getOrDefault(var0, (String)var0)));
    }
}

