/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

public class ArraySetSorted<T>
extends AbstractSet<T> {
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private final Comparator<T> comparator;
    T[] contents;
    int size;

    private ArraySetSorted(int var0, Comparator<T> var1) {
        this.comparator = var1;
        if (var0 < 0) {
            throw new IllegalArgumentException("Initial capacity (" + var0 + ") is negative");
        }
        this.contents = ArraySetSorted.castRawArray(new Object[var0]);
    }

    public static <T extends Comparable<T>> ArraySetSorted<T> create() {
        return ArraySetSorted.create(10);
    }

    public static <T extends Comparable<T>> ArraySetSorted<T> create(int var0) {
        return new ArraySetSorted(var0, Comparator.naturalOrder());
    }

    public static <T> ArraySetSorted<T> create(Comparator<T> var0) {
        return ArraySetSorted.create(var0, 10);
    }

    public static <T> ArraySetSorted<T> create(Comparator<T> var0, int var1) {
        return new ArraySetSorted<T>(var1, var0);
    }

    private static <T> T[] castRawArray(Object[] var0) {
        return var0;
    }

    private int findIndex(T var0) {
        return Arrays.binarySearch(this.contents, 0, this.size, var0, this.comparator);
    }

    private static int getInsertionPosition(int var0) {
        return -var0 - 1;
    }

    @Override
    public boolean add(T var0) {
        int var1 = this.findIndex(var0);
        if (var1 >= 0) {
            return false;
        }
        int var2 = ArraySetSorted.getInsertionPosition(var1);
        this.addInternal(var0, var2);
        return true;
    }

    private void grow(int var0) {
        if (var0 <= this.contents.length) {
            return;
        }
        if (this.contents != ObjectArrays.DEFAULT_EMPTY_ARRAY) {
            var0 = (int)Math.max(Math.min((long)this.contents.length + (long)(this.contents.length >> 1), 0x7FFFFFF7L), (long)var0);
        } else if (var0 < 10) {
            var0 = 10;
        }
        Object[] var1 = new Object[var0];
        System.arraycopy(this.contents, 0, var1, 0, this.size);
        this.contents = ArraySetSorted.castRawArray(var1);
    }

    private void addInternal(T var0, int var1) {
        this.grow(this.size + 1);
        if (var1 != this.size) {
            System.arraycopy(this.contents, var1, this.contents, var1 + 1, this.size - var1);
        }
        this.contents[var1] = var0;
        ++this.size;
    }

    void removeInternal(int var0) {
        --this.size;
        if (var0 != this.size) {
            System.arraycopy(this.contents, var0 + 1, this.contents, var0, this.size - var0);
        }
        this.contents[this.size] = null;
    }

    private T getInternal(int var0) {
        return this.contents[var0];
    }

    public T addOrGet(T var0) {
        int var1 = this.findIndex(var0);
        if (var1 >= 0) {
            return this.getInternal(var1);
        }
        this.addInternal(var0, ArraySetSorted.getInsertionPosition(var1));
        return var0;
    }

    @Override
    public boolean remove(Object var0) {
        int var1 = this.findIndex(var0);
        if (var1 >= 0) {
            this.removeInternal(var1);
            return true;
        }
        return false;
    }

    @Nullable
    public T get(T var0) {
        int var1 = this.findIndex(var0);
        if (var1 >= 0) {
            return this.getInternal(var1);
        }
        return null;
    }

    public T first() {
        return this.getInternal(0);
    }

    public T last() {
        return this.getInternal(this.size - 1);
    }

    @Override
    public boolean contains(Object var0) {
        int var1 = this.findIndex(var0);
        return var1 >= 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new a();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.contents.clone();
    }

    @Override
    public <U> U[] toArray(U[] var0) {
        if (var0.length < this.size) {
            return Arrays.copyOf(this.contents, this.size, var0.getClass());
        }
        System.arraycopy(this.contents, 0, var0, 0, this.size);
        if (var0.length > this.size) {
            var0[this.size] = null;
        }
        return var0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.contents, 0, this.size, null);
        this.size = 0;
    }

    @Override
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof ArraySetSorted) {
            ArraySetSorted var1 = (ArraySetSorted)var0;
            if (this.comparator.equals(var1.comparator)) {
                return this.size == var1.size && Arrays.equals(this.contents, var1.contents);
            }
        }
        return super.equals(var0);
    }

    class a
    implements Iterator<T> {
        private int index;
        private int last = -1;

        a() {
        }

        @Override
        public boolean hasNext() {
            return this.index < ArraySetSorted.this.size;
        }

        @Override
        public T next() {
            if (this.index >= ArraySetSorted.this.size) {
                throw new NoSuchElementException();
            }
            this.last = this.index++;
            return ArraySetSorted.this.contents[this.last];
        }

        @Override
        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            ArraySetSorted.this.removeInternal(this.last);
            --this.index;
            this.last = -1;
        }
    }
}

