/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.tags.TagDataPack;
import net.minecraft.util.profiling.GameProfilerFiller;

public class TagRegistry
implements IReloadListener {
    private static final Map<ResourceKey<? extends IRegistry<?>>, String> CUSTOM_REGISTRY_DIRECTORIES = Map.of(IRegistry.BLOCK_REGISTRY, "tags/blocks", IRegistry.ENTITY_TYPE_REGISTRY, "tags/entity_types", IRegistry.FLUID_REGISTRY, "tags/fluids", IRegistry.GAME_EVENT_REGISTRY, "tags/game_events", IRegistry.ITEM_REGISTRY, "tags/items");
    private final IRegistryCustom registryAccess;
    private List<a<?>> results = List.of();

    public TagRegistry(IRegistryCustom var0) {
        this.registryAccess = var0;
    }

    public List<a<?>> getResult() {
        return this.results;
    }

    public static String getTagDir(ResourceKey<? extends IRegistry<?>> var0) {
        String var1 = CUSTOM_REGISTRY_DIRECTORIES.get(var0);
        if (var1 != null) {
            return var1;
        }
        return "tags/" + var0.location().getPath();
    }

    @Override
    public CompletableFuture<Void> reload(IReloadListener.a var0, IResourceManager var12, GameProfilerFiller var22, GameProfilerFiller var3, Executor var4, Executor var5) {
        List<CompletableFuture> var6 = this.registryAccess.registries().map(var2 -> this.createLoader(var12, var4, (IRegistryCustom.d)var2)).toList();
        return ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])var6.toArray(CompletableFuture[]::new)).thenCompose(var0::wait)).thenAcceptAsync(var1 -> {
            this.results = var6.stream().map(CompletableFuture::join).collect(Collectors.toUnmodifiableList());
        }, var5);
    }

    private <T> CompletableFuture<a<T>> createLoader(IResourceManager var0, Executor var1, IRegistryCustom.d<T> var22) {
        ResourceKey var3 = var22.key();
        IRegistry var4 = var22.value();
        TagDataPack var5 = new TagDataPack(var2 -> var4.getHolder(ResourceKey.create(var3, var2)), TagRegistry.getTagDir(var3));
        return CompletableFuture.supplyAsync(() -> new a(var3, var5.loadAndBuild(var0)), var1);
    }

    public record a<T>(ResourceKey<? extends IRegistry<T>> key, Map<MinecraftKey, Collection<Holder<T>>> tags) {
    }
}

