/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.stats.Counter;
import net.minecraft.stats.Statistic;

public class StatisticWrapper<T>
implements Iterable<Statistic<T>> {
    private final IRegistry<T> registry;
    private final Map<T, Statistic<T>> map = new IdentityHashMap<T, Statistic<T>>();
    @Nullable
    private IChatBaseComponent displayName;

    public StatisticWrapper(IRegistry<T> var0) {
        this.registry = var0;
    }

    public boolean contains(T var0) {
        return this.map.containsKey(var0);
    }

    public Statistic<T> get(T var0, Counter var12) {
        return this.map.computeIfAbsent(var0, var1 -> new Statistic<Object>(this, var1, var12));
    }

    public IRegistry<T> getRegistry() {
        return this.registry;
    }

    @Override
    public Iterator<Statistic<T>> iterator() {
        return this.map.values().iterator();
    }

    public Statistic<T> get(T var0) {
        return this.get(var0, Counter.DEFAULT);
    }

    public String getTranslationKey() {
        return "stat_type." + IRegistry.STAT_TYPE.getKey(this).toString().replace(':', '.');
    }

    public IChatBaseComponent getDisplayName() {
        if (this.displayName == null) {
            this.displayName = IChatBaseComponent.translatable(this.getTranslationKey());
        }
        return this.displayName;
    }
}

