/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutStatistic;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticManager;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.EntityHuman;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

public class ServerStatisticManager
extends StatisticManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final MinecraftServer server;
    private final File file;
    private final Set<Statistic<?>> dirty = Sets.newHashSet();

    public ServerStatisticManager(MinecraftServer var0, File var1) {
        this.server = var0;
        this.file = var1;
        if (var1.isFile()) {
            try {
                this.parseLocal(var0.getFixerUpper(), FileUtils.readFileToString((File)var1));
            }
            catch (IOException var2) {
                LOGGER.error("Couldn't read statistics file {}", (Object)var1, (Object)var2);
            }
            catch (JsonParseException var2) {
                LOGGER.error("Couldn't parse statistics file {}", (Object)var1, (Object)var2);
            }
        }
    }

    public void save() {
        try {
            FileUtils.writeStringToFile((File)this.file, (String)this.toJson());
        }
        catch (IOException var0) {
            LOGGER.error("Couldn't save stats", (Throwable)var0);
        }
    }

    @Override
    public void setValue(EntityHuman var0, Statistic<?> var1, int var2) {
        super.setValue(var0, var1, var2);
        this.dirty.add(var1);
    }

    private Set<Statistic<?>> getDirty() {
        HashSet var0 = Sets.newHashSet(this.dirty);
        this.dirty.clear();
        return var0;
    }

    public void parseLocal(DataFixer var0, String var1) {
        try (JsonReader var2 = new JsonReader((Reader)new StringReader(var1));){
            var2.setLenient(false);
            JsonElement var3 = Streams.parse((JsonReader)var2);
            if (var3.isJsonNull()) {
                LOGGER.error("Unable to parse Stat data from {}", (Object)this.file);
                return;
            }
            NBTTagCompound var4 = ServerStatisticManager.fromJson(var3.getAsJsonObject());
            if (!var4.contains("DataVersion", 99)) {
                var4.putInt("DataVersion", 1343);
            }
            if ((var4 = GameProfileSerializer.update(var0, DataFixTypes.STATS, var4, var4.getInt("DataVersion"))).contains("stats", 10)) {
                NBTTagCompound var5 = var4.getCompound("stats");
                for (String var7 : var5.getAllKeys()) {
                    if (!var5.contains(var7, 10)) continue;
                    SystemUtils.ifElse(IRegistry.STAT_TYPE.getOptional(new MinecraftKey(var7)), var22 -> {
                        NBTTagCompound var3 = var5.getCompound(var7);
                        for (String var5 : var3.getAllKeys()) {
                            if (var3.contains(var5, 99)) {
                                SystemUtils.ifElse(this.getStat((StatisticWrapper)var22, var5), var2 -> this.stats.put(var2, var3.getInt(var5)), () -> LOGGER.warn("Invalid statistic in {}: Don't know what {} is", (Object)this.file, (Object)var5));
                                continue;
                            }
                            LOGGER.warn("Invalid statistic value in {}: Don't know what {} is for key {}", new Object[]{this.file, var3.get(var5), var5});
                        }
                    }, () -> LOGGER.warn("Invalid statistic type in {}: Don't know what {} is", (Object)this.file, (Object)var7));
                }
            }
        }
        catch (JsonParseException | IOException var23) {
            LOGGER.error("Unable to parse Stat data from {}", (Object)this.file, (Object)var23);
        }
    }

    private <T> Optional<Statistic<T>> getStat(StatisticWrapper<T> var0, String var1) {
        return Optional.ofNullable(MinecraftKey.tryParse(var1)).flatMap(var0.getRegistry()::getOptional).map(var0::get);
    }

    private static NBTTagCompound fromJson(JsonObject var0) {
        NBTTagCompound var1 = new NBTTagCompound();
        for (Map.Entry var3 : var0.entrySet()) {
            JsonPrimitive var5;
            JsonElement var4 = (JsonElement)var3.getValue();
            if (var4.isJsonObject()) {
                var1.put((String)var3.getKey(), ServerStatisticManager.fromJson(var4.getAsJsonObject()));
                continue;
            }
            if (!var4.isJsonPrimitive() || !(var5 = var4.getAsJsonPrimitive()).isNumber()) continue;
            var1.putInt((String)var3.getKey(), var5.getAsInt());
        }
        return var1;
    }

    protected String toJson() {
        HashMap var02 = Maps.newHashMap();
        for (Object var22 : this.stats.object2IntEntrySet()) {
            Statistic statistic = (Statistic)var22.getKey();
            var02.computeIfAbsent(statistic.getType(), var0 -> new JsonObject()).addProperty(ServerStatisticManager.getKey(statistic).toString(), (Number)var22.getIntValue());
        }
        JsonObject var1 = new JsonObject();
        for (Map.Entry entry : var02.entrySet()) {
            var1.add(IRegistry.STAT_TYPE.getKey((StatisticWrapper)entry.getKey()).toString(), (JsonElement)entry.getValue());
        }
        JsonObject var2 = new JsonObject();
        var2.add("stats", (JsonElement)var1);
        var2.addProperty("DataVersion", (Number)SharedConstants.getCurrentVersion().getWorldVersion());
        return var2.toString();
    }

    private static <T> MinecraftKey getKey(Statistic<T> var0) {
        return var0.getType().getRegistry().getKey(var0.getValue());
    }

    public void markAllDirty() {
        this.dirty.addAll((Collection<Statistic<?>>)this.stats.keySet());
    }

    public void sendStats(EntityPlayer var0) {
        Object2IntOpenHashMap var1 = new Object2IntOpenHashMap();
        for (Statistic<?> var3 : this.getDirty()) {
            var1.put(var3, this.getValue(var3));
        }
        var0.connection.send(new PacketPlayOutStatistic((Object2IntMap<Statistic<?>>)var1));
    }
}

