/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.slf4j.Logger;

public class ResourceManagerFallback
implements IResourceManager {
    static final Logger LOGGER = LogUtils.getLogger();
    protected final List<c> fallbacks = Lists.newArrayList();
    final EnumResourcePackType type;
    private final String namespace;

    public ResourceManagerFallback(EnumResourcePackType var0, String var1) {
        this.type = var0;
        this.namespace = var1;
    }

    public void push(IResourcePack var0) {
        this.pushInternal(var0.getName(), var0, null);
    }

    public void push(IResourcePack var0, Predicate<MinecraftKey> var1) {
        this.pushInternal(var0.getName(), var0, var1);
    }

    public void pushFilterOnly(String var0, Predicate<MinecraftKey> var1) {
        this.pushInternal(var0, null, var1);
    }

    private void pushInternal(String var0, @Nullable IResourcePack var1, @Nullable Predicate<MinecraftKey> var2) {
        this.fallbacks.add(new c(var0, var1, var2));
    }

    @Override
    public Set<String> getNamespaces() {
        return ImmutableSet.of((Object)this.namespace);
    }

    @Override
    public Optional<IResource> getResource(MinecraftKey var0) {
        if (!this.isValidLocation(var0)) {
            return Optional.empty();
        }
        for (int var1 = this.fallbacks.size() - 1; var1 >= 0; --var1) {
            c var2 = this.fallbacks.get(var1);
            IResourcePack var3 = var2.resources;
            if (var3 != null && var3.hasResource(this.type, var0)) {
                return Optional.of(new IResource(var3.getName(), this.createResourceGetter(var0, var3), this.createStackMetadataFinder(var0, var1)));
            }
            if (!var2.isFiltered(var0)) continue;
            LOGGER.warn("Resource {} not found, but was filtered by pack {}", (Object)var0, (Object)var2.name);
            return Optional.empty();
        }
        return Optional.empty();
    }

    IResource.a<InputStream> createResourceGetter(MinecraftKey var0, IResourcePack var1) {
        if (LOGGER.isDebugEnabled()) {
            return () -> {
                InputStream var2 = var1.getResource(this.type, var0);
                return new b(var2, var0, var1.getName());
            };
        }
        return () -> var1.getResource(this.type, var0);
    }

    private boolean isValidLocation(MinecraftKey var0) {
        return !var0.getPath().contains("..");
    }

    @Override
    public List<IResource> getResourceStack(MinecraftKey var0) {
        if (!this.isValidLocation(var0)) {
            return List.of();
        }
        ArrayList var1 = Lists.newArrayList();
        MinecraftKey var2 = ResourceManagerFallback.getMetadataLocation(var0);
        String var3 = null;
        for (c var5 : this.fallbacks) {
            IResourcePack var6;
            if (var5.isFiltered(var0)) {
                if (!var1.isEmpty()) {
                    var3 = var5.name;
                }
                var1.clear();
            } else if (var5.isFiltered(var2)) {
                var1.forEach(d::ignoreMeta);
            }
            if ((var6 = var5.resources) == null || !var6.hasResource(this.type, var0)) continue;
            var1.add(new d(var0, var2, var6));
        }
        if (var1.isEmpty() && var3 != null) {
            LOGGER.info("Resource {} was filtered by pack {}", (Object)var0, var3);
        }
        return var1.stream().map(d::create).toList();
    }

    @Override
    public Map<MinecraftKey, IResource> listResources(String var0, Predicate<MinecraftKey> var1) {
        Object2IntOpenHashMap var2 = new Object2IntOpenHashMap();
        int var3 = this.fallbacks.size();
        for (int var4 = 0; var4 < var3; ++var4) {
            c var5 = this.fallbacks.get(var4);
            var5.filterAll((Collection<MinecraftKey>)var2.keySet());
            if (var5.resources == null) continue;
            for (MinecraftKey var7 : var5.resources.getResources(this.type, this.namespace, var0, var1)) {
                var2.put((Object)var7, var4);
            }
        }
        TreeMap var4 = Maps.newTreeMap();
        for (Object2IntMap.Entry var6 : Object2IntMaps.fastIterable((Object2IntMap)var2)) {
            int var7 = var6.getIntValue();
            MinecraftKey var8 = (MinecraftKey)var6.getKey();
            IResourcePack var9 = this.fallbacks.get((int)var7).resources;
            var4.put(var8, new IResource(var9.getName(), this.createResourceGetter(var8, var9), this.createStackMetadataFinder(var8, var7)));
        }
        return var4;
    }

    private IResource.a<ResourceMetadata> createStackMetadataFinder(MinecraftKey var0, int var1) {
        return () -> {
            MinecraftKey var2 = ResourceManagerFallback.getMetadataLocation(var0);
            for (int var3 = this.fallbacks.size() - 1; var3 >= var1; --var3) {
                c var4 = this.fallbacks.get(var3);
                IResourcePack var5 = var4.resources;
                if (var5 != null && var5.hasResource(this.type, var2)) {
                    try (InputStream var6 = var5.getResource(this.type, var2);){
                        ResourceMetadata resourceMetadata = ResourceMetadata.fromJsonStream(var6);
                        return resourceMetadata;
                    }
                }
                if (var4.isFiltered(var2)) break;
            }
            return ResourceMetadata.EMPTY;
        };
    }

    private static void applyPackFiltersToExistingResources(c var0, Map<MinecraftKey, a> var1) {
        Iterator<Map.Entry<MinecraftKey, a>> var2 = var1.entrySet().iterator();
        while (var2.hasNext()) {
            Map.Entry<MinecraftKey, a> var3 = var2.next();
            MinecraftKey var4 = var3.getKey();
            a var5 = var3.getValue();
            if (var0.isFiltered(var4)) {
                var2.remove();
                continue;
            }
            if (!var0.isFiltered(var5.metadataLocation())) continue;
            var5.entries.forEach(d::ignoreMeta);
        }
    }

    private void listPackResources(c var0, String var12, Predicate<MinecraftKey> var2, Map<MinecraftKey, a> var3) {
        IResourcePack var4 = var0.resources;
        if (var4 == null) {
            return;
        }
        for (MinecraftKey var6 : var4.getResources(this.type, this.namespace, var12, var2)) {
            MinecraftKey var7 = ResourceManagerFallback.getMetadataLocation(var6);
            var3.computeIfAbsent(var6, var1 -> new a(var7, Lists.newArrayList())).entries().add(new d(var6, var7, var4));
        }
    }

    @Override
    public Map<MinecraftKey, List<IResource>> listResourceStacks(String var0, Predicate<MinecraftKey> var12) {
        HashMap var22 = Maps.newHashMap();
        for (c var4 : this.fallbacks) {
            ResourceManagerFallback.applyPackFiltersToExistingResources(var4, var22);
            this.listPackResources(var4, var0, var12, var22);
        }
        TreeMap var3 = Maps.newTreeMap();
        var22.forEach((var1, var2) -> var3.put(var1, var2.createThunks()));
        return var3;
    }

    @Override
    public Stream<IResourcePack> listPacks() {
        return this.fallbacks.stream().map(var0 -> var0.resources).filter(Objects::nonNull);
    }

    static MinecraftKey getMetadataLocation(MinecraftKey var0) {
        return new MinecraftKey(var0.getNamespace(), var0.getPath() + ".mcmeta");
    }

    static final class c
    extends Record {
        final String name;
        @Nullable
        final IResourcePack resources;
        @Nullable
        private final Predicate<MinecraftKey> filter;

        c(String var0, @Nullable IResourcePack var1, @Nullable Predicate<MinecraftKey> var2) {
            this.name = var0;
            this.resources = var1;
            this.filter = var2;
        }

        public void filterAll(Collection<MinecraftKey> var0) {
            if (this.filter != null) {
                var0.removeIf(this.filter);
            }
        }

        public boolean isFiltered(MinecraftKey var0) {
            return this.filter != null && this.filter.test(var0);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "name;resources;filter", "name", "resources", "filter"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "name;resources;filter", "name", "resources", "filter"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "name;resources;filter", "name", "resources", "filter"}, this, var0);
        }

        public String name() {
            return this.name;
        }

        @Nullable
        public IResourcePack resources() {
            return this.resources;
        }

        @Nullable
        public Predicate<MinecraftKey> filter() {
            return this.filter;
        }
    }

    class d {
        private final MinecraftKey location;
        private final MinecraftKey metadataLocation;
        private final IResourcePack source;
        private boolean shouldGetMeta = true;

        d(MinecraftKey var1, MinecraftKey var2, IResourcePack var3) {
            this.source = var3;
            this.location = var1;
            this.metadataLocation = var2;
        }

        public void ignoreMeta() {
            this.shouldGetMeta = false;
        }

        public IResource create() {
            String var0 = this.source.getName();
            if (this.shouldGetMeta) {
                return new IResource(var0, ResourceManagerFallback.this.createResourceGetter(this.location, this.source), () -> {
                    if (this.source.hasResource(ResourceManagerFallback.this.type, this.metadataLocation)) {
                        try (InputStream var0 = this.source.getResource(ResourceManagerFallback.this.type, this.metadataLocation);){
                            ResourceMetadata resourceMetadata = ResourceMetadata.fromJsonStream(var0);
                            return resourceMetadata;
                        }
                    }
                    return ResourceMetadata.EMPTY;
                });
            }
            return new IResource(var0, ResourceManagerFallback.this.createResourceGetter(this.location, this.source));
        }
    }

    static final class a
    extends Record {
        private final MinecraftKey metadataLocation;
        final List<d> entries;

        a(MinecraftKey var0, List<d> var1) {
            this.metadataLocation = var0;
            this.entries = var1;
        }

        List<IResource> createThunks() {
            return this.entries().stream().map(d::create).toList();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "metadataLocation;entries", "metadataLocation", "entries"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "metadataLocation;entries", "metadataLocation", "entries"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "metadataLocation;entries", "metadataLocation", "entries"}, this, var0);
        }

        public MinecraftKey metadataLocation() {
            return this.metadataLocation;
        }

        public List<d> entries() {
            return this.entries;
        }
    }

    static class b
    extends FilterInputStream {
        private final String message;
        private boolean closed;

        public b(InputStream var0, MinecraftKey var1, String var2) {
            super(var0);
            ByteArrayOutputStream var3 = new ByteArrayOutputStream();
            new Exception().printStackTrace(new PrintStream(var3));
            this.message = "Leaked resource: '" + var1 + "' loaded from pack: '" + var2 + "'\n" + var3;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.closed = true;
        }

        protected void finalize() throws Throwable {
            if (!this.closed) {
                LOGGER.warn(this.message);
            }
            super.finalize();
        }
    }
}

