/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.server.level.EntityPlayer;

public record FilteredText<T>(T raw, @Nullable T filtered) {
    public static final FilteredText<String> EMPTY_STRING = FilteredText.passThrough("");

    public static <T> FilteredText<T> passThrough(T var0) {
        return new FilteredText<T>(var0, var0);
    }

    public static <T> FilteredText<T> fullyFiltered(T var0) {
        return new FilteredText<Object>(var0, null);
    }

    public <U> FilteredText<U> map(Function<T, U> var0) {
        return new FilteredText<U>(var0.apply(this.raw), SystemUtils.mapNullable(this.filtered, var0));
    }

    public boolean isFiltered() {
        return !this.raw.equals(this.filtered);
    }

    public boolean isFullyFiltered() {
        return this.filtered == null;
    }

    public T filteredOrElse(T var0) {
        return this.filtered != null ? this.filtered : var0;
    }

    @Nullable
    public T filter(EntityPlayer var0, EntityPlayer var1) {
        return var0.shouldFilterMessageTo(var1) ? this.filtered : this.raw;
    }

    @Nullable
    public T filter(CommandListenerWrapper var0, EntityPlayer var1) {
        EntityPlayer var2 = var0.getPlayer();
        return var2 != null ? this.filter(var2, var1) : this.raw;
    }
}

