/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutViewCentre;
import net.minecraft.server.level.ChunkMapDistance;
import net.minecraft.server.level.ChunkTaskQueue;
import net.minecraft.server.level.ChunkTaskQueueSorter;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.TickingTracker;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.thread.IAsyncTaskHandler;
import net.minecraft.util.thread.Mailbox;
import net.minecraft.util.thread.ThreadedMailbox;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.storage.ChunkRegionLoader;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class PlayerChunkMap
extends IChunkLoader
implements PlayerChunk.e {
    private static final byte CHUNK_TYPE_REPLACEABLE = -1;
    private static final byte CHUNK_TYPE_UNKNOWN = 0;
    private static final byte CHUNK_TYPE_FULL = 1;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int CHUNK_SAVED_PER_TICK = 200;
    private static final int CHUNK_SAVED_EAGERLY_PER_TICK = 20;
    private static final int EAGER_CHUNK_SAVE_COOLDOWN_IN_MILLIS = 10000;
    private static final int MIN_VIEW_DISTANCE = 3;
    public static final int MAX_VIEW_DISTANCE = 33;
    public static final int MAX_CHUNK_DISTANCE = 33 + ChunkStatus.maxDistance();
    public static final int FORCED_TICKET_LEVEL = 31;
    public final Long2ObjectLinkedOpenHashMap<PlayerChunk> updatingChunkMap = new Long2ObjectLinkedOpenHashMap();
    public volatile Long2ObjectLinkedOpenHashMap<PlayerChunk> visibleChunkMap = this.updatingChunkMap.clone();
    private final Long2ObjectLinkedOpenHashMap<PlayerChunk> pendingUnloads = new Long2ObjectLinkedOpenHashMap();
    private final LongSet entitiesInLevel = new LongOpenHashSet();
    public final WorldServer level;
    private final LightEngineThreaded lightEngine;
    private final IAsyncTaskHandler<Runnable> mainThreadExecutor;
    public ChunkGenerator generator;
    private RandomState randomState;
    private final Supplier<WorldPersistentData> overworldDataStorage;
    private final VillagePlace poiManager;
    public final LongSet toDrop = new LongOpenHashSet();
    private boolean modified;
    private final ChunkTaskQueueSorter queueSorter;
    private final Mailbox<ChunkTaskQueueSorter.a<Runnable>> worldgenMailbox;
    private final Mailbox<ChunkTaskQueueSorter.a<Runnable>> mainThreadMailbox;
    public final WorldLoadListener progressListener;
    private final ChunkStatusUpdateListener chunkStatusListener;
    public final a distanceManager;
    private final AtomicInteger tickingGenerated = new AtomicInteger();
    private final StructureTemplateManager structureTemplateManager;
    private final String storageName;
    private final PlayerMap playerMap = new PlayerMap();
    public final Int2ObjectMap<EntityTracker> entityMap = new Int2ObjectOpenHashMap();
    private final Long2ByteMap chunkTypeCache = new Long2ByteOpenHashMap();
    private final Long2LongMap chunkSaveCooldowns = new Long2LongOpenHashMap();
    private final Queue<Runnable> unloadQueue = Queues.newConcurrentLinkedQueue();
    int viewDistance;

    public PlayerChunkMap(WorldServer var0, Convertable.ConversionSession var1, DataFixer var2, StructureTemplateManager var3, Executor var4, IAsyncTaskHandler<Runnable> var5, ILightAccess var6, ChunkGenerator var7, WorldLoadListener var8, ChunkStatusUpdateListener var9, Supplier<WorldPersistentData> var10, int var11, boolean var12) {
        super(var1.getDimensionPath(var0.dimension()).resolve("region"), var2, var12);
        Object var14;
        this.structureTemplateManager = var3;
        Path var13 = var1.getDimensionPath(var0.dimension());
        this.storageName = var13.getFileName().toString();
        this.level = var0;
        this.generator = var7;
        if (var7 instanceof ChunkGeneratorAbstract) {
            var14 = (ChunkGeneratorAbstract)var7;
            this.randomState = RandomState.create(((ChunkGeneratorAbstract)var14).generatorSettings().value(), var0.registryAccess().registryOrThrow(IRegistry.NOISE_REGISTRY), var0.getSeed());
        } else {
            this.randomState = RandomState.create(GeneratorSettingBase.dummy(), var0.registryAccess().registryOrThrow(IRegistry.NOISE_REGISTRY), var0.getSeed());
        }
        this.mainThreadExecutor = var5;
        var14 = ThreadedMailbox.create(var4, "worldgen");
        Mailbox<Runnable> var15 = Mailbox.of("main", var5::tell);
        this.progressListener = var8;
        this.chunkStatusListener = var9;
        ThreadedMailbox<Runnable> var16 = ThreadedMailbox.create(var4, "light");
        this.queueSorter = new ChunkTaskQueueSorter((List<Mailbox<?>>)ImmutableList.of((Object)var14, var15, var16), var4, Integer.MAX_VALUE);
        this.worldgenMailbox = this.queueSorter.getProcessor(var14, false);
        this.mainThreadMailbox = this.queueSorter.getProcessor(var15, false);
        this.lightEngine = new LightEngineThreaded(var6, this, this.level.dimensionType().hasSkyLight(), var16, this.queueSorter.getProcessor(var16, false));
        this.distanceManager = new a(var4, var5);
        this.overworldDataStorage = var10;
        this.poiManager = new VillagePlace(var13.resolve("poi"), var2, var12, var0.registryAccess(), var0);
        this.setViewDistance(var11);
    }

    protected ChunkGenerator generator() {
        return this.generator;
    }

    protected RandomState randomState() {
        return this.randomState;
    }

    public void debugReloadGenerator() {
        DataResult var02 = ChunkGenerator.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.generator);
        DataResult var1 = var02.flatMap(var0 -> ChunkGenerator.CODEC.parse((DynamicOps)JsonOps.INSTANCE, var0));
        var1.result().ifPresent(var0 -> {
            this.generator = var0;
        });
    }

    private static double euclideanDistanceSquared(ChunkCoordIntPair var0, Entity var1) {
        double var2 = SectionPosition.sectionToBlockCoord(var0.x, 8);
        double var4 = SectionPosition.sectionToBlockCoord(var0.z, 8);
        double var6 = var2 - var1.getX();
        double var8 = var4 - var1.getZ();
        return var6 * var6 + var8 * var8;
    }

    public static boolean isChunkInRange(int var0, int var1, int var2, int var3, int var4) {
        int var13;
        int var14;
        int var5 = Math.max(0, Math.abs(var0 - var2) - 1);
        int var6 = Math.max(0, Math.abs(var1 - var3) - 1);
        long var7 = Math.max(0, Math.max(var5, var6) - 1);
        long var9 = Math.min(var5, var6);
        long var11 = var9 * var9 + var7 * var7;
        return var11 <= (long)(var14 = (var13 = var4 - 1) * var13);
    }

    private static boolean isChunkOnRangeBorder(int var0, int var1, int var2, int var3, int var4) {
        if (!PlayerChunkMap.isChunkInRange(var0, var1, var2, var3, var4)) {
            return false;
        }
        if (!PlayerChunkMap.isChunkInRange(var0 + 1, var1, var2, var3, var4)) {
            return true;
        }
        if (!PlayerChunkMap.isChunkInRange(var0, var1 + 1, var2, var3, var4)) {
            return true;
        }
        if (!PlayerChunkMap.isChunkInRange(var0 - 1, var1, var2, var3, var4)) {
            return true;
        }
        return !PlayerChunkMap.isChunkInRange(var0, var1 - 1, var2, var3, var4);
    }

    protected LightEngineThreaded getLightEngine() {
        return this.lightEngine;
    }

    @Nullable
    protected PlayerChunk getUpdatingChunkIfPresent(long var0) {
        return (PlayerChunk)this.updatingChunkMap.get(var0);
    }

    @Nullable
    protected PlayerChunk getVisibleChunkIfPresent(long var0) {
        return (PlayerChunk)this.visibleChunkMap.get(var0);
    }

    protected IntSupplier getChunkQueueLevel(long var0) {
        return () -> {
            PlayerChunk var2 = this.getVisibleChunkIfPresent(var0);
            if (var2 == null) {
                return ChunkTaskQueue.PRIORITY_LEVEL_COUNT - 1;
            }
            return Math.min(var2.getQueueLevel(), ChunkTaskQueue.PRIORITY_LEVEL_COUNT - 1);
        };
    }

    public String getChunkDebugData(ChunkCoordIntPair var0) {
        PlayerChunk var1 = this.getVisibleChunkIfPresent(var0.toLong());
        if (var1 == null) {
            return "null";
        }
        String var2 = var1.getTicketLevel() + "\n";
        ChunkStatus var3 = var1.getLastAvailableStatus();
        IChunkAccess var4 = var1.getLastAvailable();
        if (var3 != null) {
            var2 = var2 + "St: \u00a7" + var3.getIndex() + var3 + "\u00a7r\n";
        }
        if (var4 != null) {
            var2 = var2 + "Ch: \u00a7" + var4.getStatus().getIndex() + var4.getStatus() + "\u00a7r\n";
        }
        PlayerChunk.State var5 = var1.getFullStatus();
        var2 = var2 + "\u00a7" + var5.ordinal() + var5;
        return var2 + "\u00a7r";
    }

    private CompletableFuture<Either<List<IChunkAccess>, PlayerChunk.Failure>> getChunkRangeFuture(ChunkCoordIntPair var0, final int var1, IntFunction<ChunkStatus> var2) {
        ArrayList<CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>> var32 = new ArrayList<CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>>();
        ArrayList<PlayerChunk> var4 = new ArrayList<PlayerChunk>();
        int var5 = var0.x;
        int var6 = var0.z;
        for (int var7 = -var1; var7 <= var1; ++var7) {
            for (int var8 = -var1; var8 <= var1; ++var8) {
                int var9 = Math.max(Math.abs(var8), Math.abs(var7));
                final ChunkCoordIntPair chunkCoordIntPair = new ChunkCoordIntPair(var5 + var8, var6 + var7);
                long var11 = chunkCoordIntPair.toLong();
                PlayerChunk var13 = this.getUpdatingChunkIfPresent(var11);
                if (var13 == null) {
                    return CompletableFuture.completedFuture(Either.right((Object)new PlayerChunk.Failure(){

                        public String toString() {
                            return "Unloaded " + chunkCoordIntPair;
                        }
                    }));
                }
                ChunkStatus var14 = var2.apply(var9);
                CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> var15 = var13.getOrScheduleFuture(var14, this);
                var4.add(var13);
                var32.add(var15);
            }
        }
        CompletableFuture var7 = SystemUtils.sequence(var32);
        CompletionStage var8 = var7.thenApply(var3 -> {
            ArrayList var4 = Lists.newArrayList();
            int var5 = 0;
            for (final Either var7 : var3) {
                if (var7 == null) {
                    throw this.debugFuturesAndCreateReportedException(new IllegalStateException("At least one of the chunk futures were null"), "n/a");
                }
                Optional var8 = var7.left();
                if (!var8.isPresent()) {
                    final int var9 = var5;
                    return Either.right((Object)new PlayerChunk.Failure(){

                        public String toString() {
                            return "Unloaded " + new ChunkCoordIntPair(var5 + var9 % (var1 * 2 + 1), var6 + var9 / (var1 * 2 + 1)) + " " + var7.right().get();
                        }
                    });
                }
                var4.add((IChunkAccess)var8.get());
                ++var5;
            }
            return Either.left((Object)var4);
        });
        for (PlayerChunk playerChunk : var4) {
            playerChunk.addSaveDependency("getChunkRangeFuture " + var0 + " " + var1, (CompletableFuture<?>)var8);
        }
        return var8;
    }

    public ReportedException debugFuturesAndCreateReportedException(IllegalStateException var0, String var12) {
        StringBuilder var2 = new StringBuilder();
        Consumer<PlayerChunk> var3 = var1 -> var1.getAllFutures().forEach(var2 -> {
            ChunkStatus var3 = (ChunkStatus)var2.getFirst();
            CompletableFuture var4 = (CompletableFuture)var2.getSecond();
            if (var4 != null && var4.isDone() && var4.join() == null) {
                var2.append(var1.getPos()).append(" - status: ").append(var3).append(" future: ").append(var4).append(System.lineSeparator());
            }
        });
        var2.append("Updating:").append(System.lineSeparator());
        this.updatingChunkMap.values().forEach(var3);
        var2.append("Visible:").append(System.lineSeparator());
        this.visibleChunkMap.values().forEach(var3);
        CrashReport var4 = CrashReport.forThrowable(var0, "Chunk loading");
        CrashReportSystemDetails var5 = var4.addCategory("Chunk loading");
        var5.setDetail("Details", var12);
        var5.setDetail("Futures", var2);
        return new ReportedException(var4);
    }

    public CompletableFuture<Either<Chunk, PlayerChunk.Failure>> prepareEntityTickingChunk(ChunkCoordIntPair var03) {
        return this.getChunkRangeFuture(var03, 2, var0 -> ChunkStatus.FULL).thenApplyAsync(var02 -> var02.mapLeft(var0 -> (Chunk)var0.get(var0.size() / 2)), (Executor)this.mainThreadExecutor);
    }

    @Nullable
    PlayerChunk updateChunkScheduling(long var0, int var2, @Nullable PlayerChunk var3, int var4) {
        if (var4 > MAX_CHUNK_DISTANCE && var2 > MAX_CHUNK_DISTANCE) {
            return var3;
        }
        if (var3 != null) {
            var3.setTicketLevel(var2);
        }
        if (var3 != null) {
            if (var2 > MAX_CHUNK_DISTANCE) {
                this.toDrop.add(var0);
            } else {
                this.toDrop.remove(var0);
            }
        }
        if (var2 <= MAX_CHUNK_DISTANCE && var3 == null) {
            var3 = (PlayerChunk)this.pendingUnloads.remove(var0);
            if (var3 != null) {
                var3.setTicketLevel(var2);
            } else {
                var3 = new PlayerChunk(new ChunkCoordIntPair(var0), var2, this.level, this.lightEngine, this.queueSorter, this);
            }
            this.updatingChunkMap.put(var0, (Object)var3);
            this.modified = true;
        }
        return var3;
    }

    @Override
    public void close() throws IOException {
        try {
            this.queueSorter.close();
            this.poiManager.close();
        }
        finally {
            super.close();
        }
    }

    protected void saveAllChunks(boolean var02) {
        if (var02) {
            List var12 = this.visibleChunkMap.values().stream().filter(PlayerChunk::wasAccessibleSinceLastSave).peek(PlayerChunk::refreshAccessibility).collect(Collectors.toList());
            MutableBoolean var2 = new MutableBoolean();
            do {
                var2.setFalse();
                var12.stream().map(var0 -> {
                    CompletableFuture<IChunkAccess> var1;
                    do {
                        var1 = var0.getChunkToSave();
                        this.mainThreadExecutor.managedBlock(var1::isDone);
                    } while (var1 != var0.getChunkToSave());
                    return var1.join();
                }).filter(var0 -> var0 instanceof ProtoChunkExtension || var0 instanceof Chunk).filter(this::save).forEach(var1 -> var2.setTrue());
            } while (var2.isTrue());
            this.processUnloads(() -> true);
            this.flushWorker();
        } else {
            this.visibleChunkMap.values().forEach(this::saveChunkIfNeeded);
        }
    }

    protected void tick(BooleanSupplier var0) {
        GameProfilerFiller var1 = this.level.getProfiler();
        var1.push("poi");
        this.poiManager.tick(var0);
        var1.popPush("chunk_unload");
        if (!this.level.noSave()) {
            this.processUnloads(var0);
        }
        var1.pop();
    }

    public boolean hasWork() {
        return this.lightEngine.hasLightWork() || !this.pendingUnloads.isEmpty() || !this.updatingChunkMap.isEmpty() || this.poiManager.hasWork() || !this.toDrop.isEmpty() || !this.unloadQueue.isEmpty() || this.queueSorter.hasWork() || this.distanceManager.hasTickets();
    }

    private void processUnloads(BooleanSupplier var0) {
        Runnable var3;
        LongIterator var1 = this.toDrop.iterator();
        int var2 = 0;
        while (var1.hasNext() && (var0.getAsBoolean() || var2 < 200 || this.toDrop.size() > 2000)) {
            long var32 = var1.nextLong();
            PlayerChunk var5 = (PlayerChunk)this.updatingChunkMap.remove(var32);
            if (var5 != null) {
                this.pendingUnloads.put(var32, (Object)var5);
                this.modified = true;
                ++var2;
                this.scheduleUnload(var32, var5);
            }
            var1.remove();
        }
        for (int var4 = Math.max(0, this.unloadQueue.size() - 2000); (var0.getAsBoolean() || var4 > 0) && (var3 = this.unloadQueue.poll()) != null; --var4) {
            var3.run();
        }
        int var5 = 0;
        ObjectIterator var6 = this.visibleChunkMap.values().iterator();
        while (var5 < 20 && var0.getAsBoolean() && var6.hasNext()) {
            if (!this.saveChunkIfNeeded((PlayerChunk)var6.next())) continue;
            ++var5;
        }
    }

    private void scheduleUnload(long var0, PlayerChunk var22) {
        CompletableFuture<IChunkAccess> var3 = var22.getChunkToSave();
        ((CompletableFuture)var3.thenAcceptAsync(var4 -> {
            CompletableFuture<IChunkAccess> var5 = var22.getChunkToSave();
            if (var5 != var3) {
                this.scheduleUnload(var0, var22);
                return;
            }
            if (this.pendingUnloads.remove(var0, (Object)var22) && var4 != null) {
                if (var4 instanceof Chunk) {
                    ((Chunk)var4).setLoaded(false);
                }
                this.save((IChunkAccess)var4);
                if (this.entitiesInLevel.remove(var0) && var4 instanceof Chunk) {
                    Chunk var6 = (Chunk)var4;
                    this.level.unload(var6);
                }
                this.lightEngine.updateChunkStatus(var4.getPos());
                this.lightEngine.tryScheduleUpdate();
                this.progressListener.onStatusChange(var4.getPos(), null);
                this.chunkSaveCooldowns.remove(var4.getPos().toLong());
            }
        }, this.unloadQueue::add)).whenComplete((var1, var2) -> {
            if (var2 != null) {
                LOGGER.error("Failed to save chunk {}", (Object)var22.getPos(), var2);
            }
        });
    }

    protected boolean promoteChunkMap() {
        if (!this.modified) {
            return false;
        }
        this.visibleChunkMap = this.updatingChunkMap.clone();
        this.modified = false;
        return true;
    }

    public CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> schedule(PlayerChunk var0, ChunkStatus var12) {
        Optional var3;
        ChunkCoordIntPair var2 = var0.getPos();
        if (var12 == ChunkStatus.EMPTY) {
            return this.scheduleChunkLoad(var2);
        }
        if (var12 == ChunkStatus.LIGHT) {
            this.distanceManager.addTicket(TicketType.LIGHT, var2, 33 + ChunkStatus.getDistance(ChunkStatus.LIGHT), var2);
        }
        if ((var3 = var0.getOrScheduleFuture(var12.getParent(), this).getNow(PlayerChunk.UNLOADED_CHUNK).left()).isPresent() && ((IChunkAccess)var3.get()).getStatus().isOrAfter(var12)) {
            CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> var4 = var12.load(this.level, this.structureTemplateManager, this.lightEngine, var1 -> this.protoChunkToFullChunk(var0), (IChunkAccess)var3.get());
            this.progressListener.onStatusChange(var2, var12);
            return var4;
        }
        return this.scheduleChunkGeneration(var0, var12);
    }

    private CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> scheduleChunkLoad(ChunkCoordIntPair var0) {
        return ((CompletableFuture)((CompletableFuture)this.readChunk(var0).thenApply(var12 -> var12.filter(var1 -> {
            boolean var2 = PlayerChunkMap.isChunkDataValid(var1);
            if (!var2) {
                LOGGER.error("Chunk file at {} is missing level data, skipping", (Object)var0);
            }
            return var2;
        }))).thenApplyAsync(var1 -> {
            this.level.getProfiler().incrementCounter("chunkLoad");
            if (var1.isPresent()) {
                ProtoChunk var2 = ChunkRegionLoader.read(this.level, this.poiManager, var0, (NBTTagCompound)var1.get());
                this.markPosition(var0, ((IChunkAccess)var2).getStatus().getChunkType());
                return Either.left((Object)var2);
            }
            return Either.left((Object)this.createEmptyChunk(var0));
        }, (Executor)this.mainThreadExecutor)).exceptionallyAsync(var1 -> this.handleChunkLoadFailure((Throwable)var1, var0), (Executor)this.mainThreadExecutor);
    }

    private static boolean isChunkDataValid(NBTTagCompound var0) {
        return var0.contains("Status", 8);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Either<IChunkAccess, PlayerChunk.Failure> handleChunkLoadFailure(Throwable var0, ChunkCoordIntPair var1) {
        if (!(var0 instanceof ReportedException)) {
            if (!(var0 instanceof IOException)) return Either.left((Object)this.createEmptyChunk(var1));
            LOGGER.error("Couldn't load chunk {}", (Object)var1, (Object)var0);
            return Either.left((Object)this.createEmptyChunk(var1));
        }
        ReportedException var2 = (ReportedException)var0;
        Throwable var3 = var2.getCause();
        if (var3 instanceof IOException) {
            LOGGER.error("Couldn't load chunk {}", (Object)var1, (Object)var3);
            return Either.left((Object)this.createEmptyChunk(var1));
        }
        this.markPositionReplaceable(var1);
        throw var2;
    }

    private IChunkAccess createEmptyChunk(ChunkCoordIntPair var0) {
        this.markPositionReplaceable(var0);
        return new ProtoChunk(var0, ChunkConverter.EMPTY, this.level, this.level.registryAccess().registryOrThrow(IRegistry.BIOME_REGISTRY), null);
    }

    private void markPositionReplaceable(ChunkCoordIntPair var0) {
        this.chunkTypeCache.put(var0.toLong(), (byte)-1);
    }

    private byte markPosition(ChunkCoordIntPair var0, ChunkStatus.Type var1) {
        return this.chunkTypeCache.put(var0.toLong(), var1 == ChunkStatus.Type.PROTOCHUNK ? (byte)-1 : 1);
    }

    private CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> scheduleChunkGeneration(PlayerChunk var0, ChunkStatus var12) {
        ChunkCoordIntPair var2 = var0.getPos();
        CompletableFuture<Either<List<IChunkAccess>, PlayerChunk.Failure>> var3 = this.getChunkRangeFuture(var2, var12.getRange(), var1 -> this.getDependencyStatus(var12, var1));
        this.level.getProfiler().incrementCounter(() -> "chunkGenerate " + var12.getName());
        Executor var4 = var1 -> this.worldgenMailbox.tell(ChunkTaskQueueSorter.message(var0, var1));
        return var3.thenComposeAsync(var42 -> (CompletionStage)var42.map(var4 -> {
            try {
                CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> var5 = var12.generate(var4, this.level, this.generator, this.structureTemplateManager, this.lightEngine, var1 -> this.protoChunkToFullChunk(var0), (List<IChunkAccess>)var4, false);
                this.progressListener.onStatusChange(var2, var12);
                return var5;
            }
            catch (Exception var5) {
                var5.getStackTrace();
                CrashReport var6 = CrashReport.forThrowable(var5, "Exception generating new chunk");
                CrashReportSystemDetails var7 = var6.addCategory("Chunk to be generated");
                var7.setDetail("Location", String.format("%d,%d", var0.x, var0.z));
                var7.setDetail("Position hash", ChunkCoordIntPair.asLong(var0.x, var0.z));
                var7.setDetail("Generator", this.generator);
                this.mainThreadExecutor.execute(() -> {
                    throw new ReportedException(var6);
                });
                throw new ReportedException(var6);
            }
        }, var1 -> {
            this.releaseLightTicket(var2);
            return CompletableFuture.completedFuture(Either.right((Object)var1));
        }), var4);
    }

    protected void releaseLightTicket(ChunkCoordIntPair var0) {
        this.mainThreadExecutor.tell(SystemUtils.name(() -> this.distanceManager.removeTicket(TicketType.LIGHT, var0, 33 + ChunkStatus.getDistance(ChunkStatus.LIGHT), var0), () -> "release light ticket " + var0));
    }

    private ChunkStatus getDependencyStatus(ChunkStatus var0, int var1) {
        ChunkStatus var2 = var1 == 0 ? var0.getParent() : ChunkStatus.getStatusAroundFullChunk(ChunkStatus.getDistance(var0) + var1);
        return var2;
    }

    private static void postLoadProtoChunk(WorldServer var0, List<NBTTagCompound> var1) {
        if (!var1.isEmpty()) {
            var0.addWorldGenChunkEntities(EntityTypes.loadEntitiesRecursive(var1, var0));
        }
    }

    private CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> protoChunkToFullChunk(PlayerChunk var0) {
        CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> var12 = var0.getFutureIfPresentUnchecked(ChunkStatus.FULL.getParent());
        return var12.thenApplyAsync(var1 -> {
            ChunkStatus var2 = PlayerChunk.getStatus(var0.getTicketLevel());
            if (!var2.isOrAfter(ChunkStatus.FULL)) {
                return PlayerChunk.UNLOADED_CHUNK;
            }
            return var1.mapLeft(var12 -> {
                Chunk var4;
                ChunkCoordIntPair var2 = var0.getPos();
                ProtoChunk var3 = (ProtoChunk)var12;
                if (var3 instanceof ProtoChunkExtension) {
                    var4 = ((ProtoChunkExtension)var3).getWrapped();
                } else {
                    var4 = new Chunk(this.level, var3, var1 -> PlayerChunkMap.postLoadProtoChunk(this.level, var3.getEntities()));
                    var0.replaceProtoChunk(new ProtoChunkExtension(var4, false));
                }
                var4.setFullStatus(() -> PlayerChunk.getFullChunkStatus(var0.getTicketLevel()));
                var4.runPostLoad();
                if (this.entitiesInLevel.add(var2.toLong())) {
                    var4.setLoaded(true);
                    var4.registerAllBlockEntitiesAfterLevelLoad();
                    var4.registerTickContainerInLevel(this.level);
                }
                return var4;
            });
        }, var1 -> this.mainThreadMailbox.tell(ChunkTaskQueueSorter.message(var1, var0.getPos().toLong(), var0::getTicketLevel)));
    }

    public CompletableFuture<Either<Chunk, PlayerChunk.Failure>> prepareTickingChunk(PlayerChunk var03) {
        ChunkCoordIntPair var13 = var03.getPos();
        CompletableFuture<Either<List<IChunkAccess>, PlayerChunk.Failure>> var2 = this.getChunkRangeFuture(var13, 1, var0 -> ChunkStatus.FULL);
        CompletionStage var3 = ((CompletableFuture)var2.thenApplyAsync(var02 -> var02.mapLeft(var0 -> (Chunk)var0.get(var0.size() / 2)), var1 -> this.mainThreadMailbox.tell(ChunkTaskQueueSorter.message(var03, var1)))).thenApplyAsync(var02 -> var02.ifLeft(var0 -> {
            var0.postProcessGeneration();
            this.level.startTickingChunk((Chunk)var0);
        }), (Executor)this.mainThreadExecutor);
        ((CompletableFuture)var3).thenAcceptAsync(var12 -> var12.ifLeft(var1 -> {
            this.tickingGenerated.getAndIncrement();
            MutableObject var22 = new MutableObject();
            this.getPlayers(var13, false).forEach(var2 -> this.playerLoadedChunk((EntityPlayer)var2, (MutableObject<ClientboundLevelChunkWithLightPacket>)var22, (Chunk)var1));
        }), var1 -> this.mainThreadMailbox.tell(ChunkTaskQueueSorter.message(var03, var1)));
        return var3;
    }

    public CompletableFuture<Either<Chunk, PlayerChunk.Failure>> prepareAccessibleChunk(PlayerChunk var0) {
        return this.getChunkRangeFuture(var0.getPos(), 1, ChunkStatus::getStatusAroundFullChunk).thenApplyAsync(var02 -> var02.mapLeft(var0 -> {
            Chunk var1 = (Chunk)var0.get(var0.size() / 2);
            return var1;
        }), var1 -> this.mainThreadMailbox.tell(ChunkTaskQueueSorter.message(var0, var1)));
    }

    public int getTickingGenerated() {
        return this.tickingGenerated.get();
    }

    private boolean saveChunkIfNeeded(PlayerChunk var0) {
        if (!var0.wasAccessibleSinceLastSave()) {
            return false;
        }
        IChunkAccess var1 = var0.getChunkToSave().getNow(null);
        if (var1 instanceof ProtoChunkExtension || var1 instanceof Chunk) {
            long var2 = var1.getPos().toLong();
            long var4 = this.chunkSaveCooldowns.getOrDefault(var2, -1L);
            long var6 = System.currentTimeMillis();
            if (var6 < var4) {
                return false;
            }
            boolean var8 = this.save(var1);
            var0.refreshAccessibility();
            if (var8) {
                this.chunkSaveCooldowns.put(var2, var6 + 10000L);
            }
            return var8;
        }
        return false;
    }

    public boolean save(IChunkAccess var0) {
        this.poiManager.flush(var0.getPos());
        if (!var0.isUnsaved()) {
            return false;
        }
        var0.setUnsaved(false);
        ChunkCoordIntPair var1 = var0.getPos();
        try {
            ChunkStatus var2 = var0.getStatus();
            if (var2.getChunkType() != ChunkStatus.Type.LEVELCHUNK) {
                if (this.isExistingChunkFull(var1)) {
                    return false;
                }
                if (var2 == ChunkStatus.EMPTY && var0.getAllStarts().values().stream().noneMatch(StructureStart::isValid)) {
                    return false;
                }
            }
            this.level.getProfiler().incrementCounter("chunkSave");
            NBTTagCompound var3 = ChunkRegionLoader.write(this.level, var0);
            this.write(var1, var3);
            this.markPosition(var1, var2.getChunkType());
            return true;
        }
        catch (Exception var2) {
            LOGGER.error("Failed to save chunk {},{}", new Object[]{var1.x, var1.z, var2});
            return false;
        }
    }

    private boolean isExistingChunkFull(ChunkCoordIntPair var0) {
        NBTTagCompound var2;
        byte var1 = this.chunkTypeCache.get(var0.toLong());
        if (var1 != 0) {
            return var1 == 1;
        }
        try {
            var2 = this.readChunk(var0).join().orElse(null);
            if (var2 == null) {
                this.markPositionReplaceable(var0);
                return false;
            }
        }
        catch (Exception var3) {
            LOGGER.error("Failed to read chunk {}", (Object)var0, (Object)var3);
            this.markPositionReplaceable(var0);
            return false;
        }
        ChunkStatus.Type var3 = ChunkRegionLoader.getChunkTypeFromTag(var2);
        return this.markPosition(var0, var3) == 1;
    }

    protected void setViewDistance(int var0) {
        int var1 = MathHelper.clamp(var0 + 1, 3, 33);
        if (var1 != this.viewDistance) {
            int var2 = this.viewDistance;
            this.viewDistance = var1;
            this.distanceManager.updatePlayerTickets(this.viewDistance + 1);
            for (PlayerChunk var4 : this.updatingChunkMap.values()) {
                ChunkCoordIntPair var5 = var4.getPos();
                MutableObject var6 = new MutableObject();
                this.getPlayers(var5, false).forEach(var3 -> {
                    SectionPosition var4 = var3.getLastSectionPos();
                    boolean var5 = PlayerChunkMap.isChunkInRange(var0.x, var0.z, var4.x(), var4.z(), var2);
                    boolean var6 = PlayerChunkMap.isChunkInRange(var0.x, var0.z, var4.x(), var4.z(), this.viewDistance);
                    this.updateChunkTracking((EntityPlayer)var3, var5, (MutableObject<ClientboundLevelChunkWithLightPacket>)var6, var5, var6);
                });
            }
        }
    }

    protected void updateChunkTracking(EntityPlayer var0, ChunkCoordIntPair var1, MutableObject<ClientboundLevelChunkWithLightPacket> var2, boolean var3, boolean var4) {
        PlayerChunk var5;
        if (var0.level != this.level) {
            return;
        }
        if (var4 && !var3 && (var5 = this.getVisibleChunkIfPresent(var1.toLong())) != null) {
            Chunk var6 = var5.getTickingChunk();
            if (var6 != null) {
                this.playerLoadedChunk(var0, var2, var6);
            }
            PacketDebug.sendPoiPacketsForChunk(this.level, var1);
        }
        if (!var4 && var3) {
            var0.untrackChunk(var1);
        }
    }

    public int size() {
        return this.visibleChunkMap.size();
    }

    public ChunkMapDistance getDistanceManager() {
        return this.distanceManager;
    }

    protected Iterable<PlayerChunk> getChunks() {
        return Iterables.unmodifiableIterable((Iterable)this.visibleChunkMap.values());
    }

    void dumpChunks(Writer var02) throws IOException {
        CSVWriter var1 = CSVWriter.builder().addColumn("x").addColumn("z").addColumn("level").addColumn("in_memory").addColumn("status").addColumn("full_status").addColumn("accessible_ready").addColumn("ticking_ready").addColumn("entity_ticking_ready").addColumn("ticket").addColumn("spawning").addColumn("block_entity_count").addColumn("ticking_ticket").addColumn("ticking_level").addColumn("block_ticks").addColumn("fluid_ticks").build(var02);
        TickingTracker var2 = this.distanceManager.tickingTracker();
        for (Long2ObjectMap.Entry var4 : this.visibleChunkMap.long2ObjectEntrySet()) {
            long var5 = var4.getLongKey();
            ChunkCoordIntPair var7 = new ChunkCoordIntPair(var5);
            PlayerChunk var8 = (PlayerChunk)var4.getValue();
            Optional<IChunkAccess> var9 = Optional.ofNullable(var8.getLastAvailable());
            Optional<Object> var10 = var9.flatMap(var0 -> var0 instanceof Chunk ? Optional.of((Chunk)var0) : Optional.empty());
            var1.writeRow(var7.x, var7.z, var8.getTicketLevel(), var9.isPresent(), var9.map(IChunkAccess::getStatus).orElse(null), var10.map(Chunk::getFullStatus).orElse(null), PlayerChunkMap.printFuture(var8.getFullChunkFuture()), PlayerChunkMap.printFuture(var8.getTickingChunkFuture()), PlayerChunkMap.printFuture(var8.getEntityTickingChunkFuture()), this.distanceManager.getTicketDebugString(var5), this.anyPlayerCloseEnoughForSpawning(var7), var10.map(var0 -> var0.getBlockEntities().size()).orElse(0), var2.getTicketDebugString(var5), var2.getLevel(var5), var10.map(var0 -> var0.getBlockTicks().count()).orElse(0), var10.map(var0 -> var0.getFluidTicks().count()).orElse(0));
        }
    }

    private static String printFuture(CompletableFuture<Either<Chunk, PlayerChunk.Failure>> var02) {
        try {
            Either var1 = var02.getNow(null);
            if (var1 != null) {
                return (String)var1.map(var0 -> "done", var0 -> "unloaded");
            }
            return "not completed";
        }
        catch (CompletionException var1) {
            return "failed " + var1.getCause().getMessage();
        }
        catch (CancellationException var1) {
            return "cancelled";
        }
    }

    private CompletableFuture<Optional<NBTTagCompound>> readChunk(ChunkCoordIntPair var02) {
        return this.read(var02).thenApplyAsync(var0 -> var0.map(this::upgradeChunkTag), (Executor)SystemUtils.backgroundExecutor());
    }

    private NBTTagCompound upgradeChunkTag(NBTTagCompound var0) {
        return this.upgradeChunkTag(this.level.dimension(), this.overworldDataStorage, var0, this.generator.getTypeNameForDataFixer());
    }

    boolean anyPlayerCloseEnoughForSpawning(ChunkCoordIntPair var0) {
        long var1 = var0.toLong();
        if (!this.distanceManager.hasPlayersNearby(var1)) {
            return false;
        }
        for (EntityPlayer var4 : this.playerMap.getPlayers(var1)) {
            if (!this.playerIsCloseEnoughForSpawning(var4, var0)) continue;
            return true;
        }
        return false;
    }

    public List<EntityPlayer> getPlayersCloseForSpawning(ChunkCoordIntPair var0) {
        long var1 = var0.toLong();
        if (!this.distanceManager.hasPlayersNearby(var1)) {
            return List.of();
        }
        ImmutableList.Builder var3 = ImmutableList.builder();
        for (EntityPlayer var5 : this.playerMap.getPlayers(var1)) {
            if (!this.playerIsCloseEnoughForSpawning(var5, var0)) continue;
            var3.add((Object)var5);
        }
        return var3.build();
    }

    private boolean playerIsCloseEnoughForSpawning(EntityPlayer var0, ChunkCoordIntPair var1) {
        if (var0.isSpectator()) {
            return false;
        }
        double var2 = PlayerChunkMap.euclideanDistanceSquared(var1, var0);
        return var2 < 16384.0;
    }

    private boolean skipPlayer(EntityPlayer var0) {
        return var0.isSpectator() && !this.level.getGameRules().getBoolean(GameRules.RULE_SPECTATORSGENERATECHUNKS);
    }

    void updatePlayerStatus(EntityPlayer var0, boolean var1) {
        boolean var2 = this.skipPlayer(var0);
        boolean var3 = this.playerMap.ignoredOrUnknown(var0);
        int var4 = SectionPosition.blockToSectionCoord(var0.getBlockX());
        int var5 = SectionPosition.blockToSectionCoord(var0.getBlockZ());
        if (var1) {
            this.playerMap.addPlayer(ChunkCoordIntPair.asLong(var4, var5), var0, var2);
            this.updatePlayerPos(var0);
            if (!var2) {
                this.distanceManager.addPlayer(SectionPosition.of(var0), var0);
            }
        } else {
            SectionPosition var6 = var0.getLastSectionPos();
            this.playerMap.removePlayer(var6.chunk().toLong(), var0);
            if (!var3) {
                this.distanceManager.removePlayer(var6, var0);
            }
        }
        for (int var6 = var4 - this.viewDistance - 1; var6 <= var4 + this.viewDistance + 1; ++var6) {
            for (int var7 = var5 - this.viewDistance - 1; var7 <= var5 + this.viewDistance + 1; ++var7) {
                if (!PlayerChunkMap.isChunkInRange(var6, var7, var4, var5, this.viewDistance)) continue;
                ChunkCoordIntPair var8 = new ChunkCoordIntPair(var6, var7);
                this.updateChunkTracking(var0, var8, (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), !var1, var1);
            }
        }
    }

    private SectionPosition updatePlayerPos(EntityPlayer var0) {
        SectionPosition var1 = SectionPosition.of(var0);
        var0.setLastSectionPos(var1);
        var0.connection.send(new PacketPlayOutViewCentre(var1.x(), var1.z()));
        return var1;
    }

    public void move(EntityPlayer var0) {
        boolean var11;
        for (EntityTracker var2 : this.entityMap.values()) {
            if (var2.entity == var0) {
                var2.updatePlayers(this.level.players());
                continue;
            }
            var2.updatePlayer(var0);
        }
        int var1 = SectionPosition.blockToSectionCoord(var0.getBlockX());
        int var2 = SectionPosition.blockToSectionCoord(var0.getBlockZ());
        SectionPosition var3 = var0.getLastSectionPos();
        SectionPosition var4 = SectionPosition.of(var0);
        long var5 = var3.chunk().toLong();
        long var7 = var4.chunk().toLong();
        boolean var9 = this.playerMap.ignored(var0);
        boolean var10 = this.skipPlayer(var0);
        boolean bl = var11 = var3.asLong() != var4.asLong();
        if (var11 || var9 != var10) {
            this.updatePlayerPos(var0);
            if (!var9) {
                this.distanceManager.removePlayer(var3, var0);
            }
            if (!var10) {
                this.distanceManager.addPlayer(var4, var0);
            }
            if (!var9 && var10) {
                this.playerMap.ignorePlayer(var0);
            }
            if (var9 && !var10) {
                this.playerMap.unIgnorePlayer(var0);
            }
            if (var5 != var7) {
                this.playerMap.updatePlayer(var5, var7, var0);
            }
        }
        int var12 = var3.x();
        int var13 = var3.z();
        if (Math.abs(var12 - var1) <= this.viewDistance * 2 && Math.abs(var13 - var2) <= this.viewDistance * 2) {
            int var14 = Math.min(var1, var12) - this.viewDistance - 1;
            int var15 = Math.min(var2, var13) - this.viewDistance - 1;
            int var16 = Math.max(var1, var12) + this.viewDistance + 1;
            int var17 = Math.max(var2, var13) + this.viewDistance + 1;
            for (int var18 = var14; var18 <= var16; ++var18) {
                for (int var19 = var15; var19 <= var17; ++var19) {
                    boolean var20 = PlayerChunkMap.isChunkInRange(var18, var19, var12, var13, this.viewDistance);
                    boolean var21 = PlayerChunkMap.isChunkInRange(var18, var19, var1, var2, this.viewDistance);
                    this.updateChunkTracking(var0, new ChunkCoordIntPair(var18, var19), (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), var20, var21);
                }
            }
        } else {
            boolean var17;
            boolean var16;
            int var15;
            int var14;
            for (var14 = var12 - this.viewDistance - 1; var14 <= var12 + this.viewDistance + 1; ++var14) {
                for (var15 = var13 - this.viewDistance - 1; var15 <= var13 + this.viewDistance + 1; ++var15) {
                    if (!PlayerChunkMap.isChunkInRange(var14, var15, var12, var13, this.viewDistance)) continue;
                    var16 = true;
                    var17 = false;
                    this.updateChunkTracking(var0, new ChunkCoordIntPair(var14, var15), (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), true, false);
                }
            }
            for (var14 = var1 - this.viewDistance - 1; var14 <= var1 + this.viewDistance + 1; ++var14) {
                for (var15 = var2 - this.viewDistance - 1; var15 <= var2 + this.viewDistance + 1; ++var15) {
                    if (!PlayerChunkMap.isChunkInRange(var14, var15, var1, var2, this.viewDistance)) continue;
                    var16 = false;
                    var17 = true;
                    this.updateChunkTracking(var0, new ChunkCoordIntPair(var14, var15), (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), false, true);
                }
            }
        }
    }

    @Override
    public List<EntityPlayer> getPlayers(ChunkCoordIntPair var0, boolean var1) {
        Set<EntityPlayer> var2 = this.playerMap.getPlayers(var0.toLong());
        ImmutableList.Builder var3 = ImmutableList.builder();
        for (EntityPlayer var5 : var2) {
            SectionPosition var6 = var5.getLastSectionPos();
            if ((!var1 || !PlayerChunkMap.isChunkOnRangeBorder(var0.x, var0.z, var6.x(), var6.z(), this.viewDistance)) && (var1 || !PlayerChunkMap.isChunkInRange(var0.x, var0.z, var6.x(), var6.z(), this.viewDistance))) continue;
            var3.add((Object)var5);
        }
        return var3.build();
    }

    protected void addEntity(Entity var0) {
        if (var0 instanceof EntityComplexPart) {
            return;
        }
        EntityTypes<?> var1 = var0.getType();
        int var2 = var1.clientTrackingRange() * 16;
        if (var2 == 0) {
            return;
        }
        int var3 = var1.updateInterval();
        if (this.entityMap.containsKey(var0.getId())) {
            throw SystemUtils.pauseInIde(new IllegalStateException("Entity is already tracked!"));
        }
        EntityTracker var4 = new EntityTracker(var0, var2, var3, var1.trackDeltas());
        this.entityMap.put(var0.getId(), (Object)var4);
        var4.updatePlayers(this.level.players());
        if (var0 instanceof EntityPlayer) {
            EntityPlayer var5 = (EntityPlayer)var0;
            this.updatePlayerStatus(var5, true);
            for (EntityTracker var7 : this.entityMap.values()) {
                if (var7.entity == var5) continue;
                var7.updatePlayer(var5);
            }
        }
    }

    protected void removeEntity(Entity var0) {
        Object var1;
        if (var0 instanceof EntityPlayer) {
            var1 = (EntityPlayer)var0;
            this.updatePlayerStatus((EntityPlayer)var1, false);
            for (EntityTracker var3 : this.entityMap.values()) {
                var3.removePlayer((EntityPlayer)var1);
            }
        }
        if ((var1 = (EntityTracker)this.entityMap.remove(var0.getId())) != null) {
            ((EntityTracker)var1).broadcastRemoved();
        }
    }

    protected void tick() {
        ArrayList var0 = Lists.newArrayList();
        List<EntityPlayer> var1 = this.level.players();
        for (EntityTracker var3 : this.entityMap.values()) {
            boolean var6;
            SectionPosition var4 = var3.lastSectionPos;
            SectionPosition var5 = SectionPosition.of(var3.entity);
            boolean bl = var6 = !Objects.equals(var4, var5);
            if (var6) {
                var3.updatePlayers(var1);
                Entity var7 = var3.entity;
                if (var7 instanceof EntityPlayer) {
                    var0.add((EntityPlayer)var7);
                }
                var3.lastSectionPos = var5;
            }
            if (!var6 && !this.distanceManager.inEntityTickingRange(var5.chunk().toLong())) continue;
            var3.serverEntity.sendChanges();
        }
        if (!var0.isEmpty()) {
            for (EntityTracker var3 : this.entityMap.values()) {
                var3.updatePlayers(var0);
            }
        }
    }

    public void broadcast(Entity var0, Packet<?> var1) {
        EntityTracker var2 = (EntityTracker)this.entityMap.get(var0.getId());
        if (var2 != null) {
            var2.broadcast(var1);
        }
    }

    protected void broadcastAndSend(Entity var0, Packet<?> var1) {
        EntityTracker var2 = (EntityTracker)this.entityMap.get(var0.getId());
        if (var2 != null) {
            var2.broadcastAndSend(var1);
        }
    }

    private void playerLoadedChunk(EntityPlayer var0, MutableObject<ClientboundLevelChunkWithLightPacket> var1, Chunk var2) {
        if (var1.getValue() == null) {
            var1.setValue((Object)new ClientboundLevelChunkWithLightPacket(var2, this.lightEngine, null, null, true));
        }
        var0.trackChunk(var2.getPos(), (Packet)var1.getValue());
        PacketDebug.sendPoiPacketsForChunk(this.level, var2.getPos());
        ArrayList var3 = Lists.newArrayList();
        ArrayList var4 = Lists.newArrayList();
        for (Object var6 : this.entityMap.values()) {
            Entity var7 = ((EntityTracker)var6).entity;
            if (var7 == var0 || !var7.chunkPosition().equals(var2.getPos())) continue;
            ((EntityTracker)var6).updatePlayer(var0);
            if (var7 instanceof EntityInsentient && ((EntityInsentient)var7).getLeashHolder() != null) {
                var3.add(var7);
            }
            if (var7.getPassengers().isEmpty()) continue;
            var4.add(var7);
        }
        if (!var3.isEmpty()) {
            for (Object var6 : var3) {
                var0.connection.send(new PacketPlayOutAttachEntity((Entity)var6, ((EntityInsentient)var6).getLeashHolder()));
            }
        }
        if (!var4.isEmpty()) {
            for (Object var6 : var4) {
                var0.connection.send(new PacketPlayOutMount((Entity)var6));
            }
        }
    }

    protected VillagePlace getPoiManager() {
        return this.poiManager;
    }

    public String getStorageName() {
        return this.storageName;
    }

    void onFullChunkStatusChange(ChunkCoordIntPair var0, PlayerChunk.State var1) {
        this.chunkStatusListener.onChunkStatusChange(var0, var1);
    }

    class a
    extends ChunkMapDistance {
        protected a(Executor var1, Executor var2) {
            super(var1, var2);
        }

        @Override
        protected boolean isChunkToRemove(long var0) {
            return PlayerChunkMap.this.toDrop.contains(var0);
        }

        @Override
        @Nullable
        protected PlayerChunk getChunk(long var0) {
            return PlayerChunkMap.this.getUpdatingChunkIfPresent(var0);
        }

        @Override
        @Nullable
        protected PlayerChunk updateChunkScheduling(long var0, int var2, @Nullable PlayerChunk var3, int var4) {
            return PlayerChunkMap.this.updateChunkScheduling(var0, var2, var3, var4);
        }
    }

    public class EntityTracker {
        final EntityTrackerEntry serverEntity;
        final Entity entity;
        private final int range;
        SectionPosition lastSectionPos;
        public final Set<ServerPlayerConnection> seenBy = Sets.newIdentityHashSet();

        public EntityTracker(Entity var1, int var2, int var3, boolean var4) {
            this.serverEntity = new EntityTrackerEntry(PlayerChunkMap.this.level, var1, var3, var4, this::broadcast);
            this.entity = var1;
            this.range = var2;
            this.lastSectionPos = SectionPosition.of(var1);
        }

        public boolean equals(Object var0) {
            if (var0 instanceof EntityTracker) {
                return ((EntityTracker)var0).entity.getId() == this.entity.getId();
            }
            return false;
        }

        public int hashCode() {
            return this.entity.getId();
        }

        public void broadcast(Packet<?> var0) {
            for (ServerPlayerConnection var2 : this.seenBy) {
                var2.send(var0);
            }
        }

        public void broadcastAndSend(Packet<?> var0) {
            this.broadcast(var0);
            if (this.entity instanceof EntityPlayer) {
                ((EntityPlayer)this.entity).connection.send(var0);
            }
        }

        public void broadcastRemoved() {
            for (ServerPlayerConnection var1 : this.seenBy) {
                this.serverEntity.removePairing(var1.getPlayer());
            }
        }

        public void removePlayer(EntityPlayer var0) {
            if (this.seenBy.remove(var0.connection)) {
                this.serverEntity.removePairing(var0);
            }
        }

        public void updatePlayer(EntityPlayer var0) {
            boolean var8;
            if (var0 == this.entity) {
                return;
            }
            Vec3D var1 = var0.position().subtract(this.entity.position());
            double var4 = var1.x * var1.x + var1.z * var1.z;
            double var2 = Math.min(this.getEffectiveRange(), (PlayerChunkMap.this.viewDistance - 1) * 16);
            double var6 = var2 * var2;
            boolean bl = var8 = var4 <= var6 && this.entity.broadcastToPlayer(var0);
            if (var8) {
                if (this.seenBy.add(var0.connection)) {
                    this.serverEntity.addPairing(var0);
                }
            } else if (this.seenBy.remove(var0.connection)) {
                this.serverEntity.removePairing(var0);
            }
        }

        private int scaledRange(int var0) {
            return PlayerChunkMap.this.level.getServer().getScaledTrackingDistance(var0);
        }

        private int getEffectiveRange() {
            int var0 = this.range;
            for (Entity var2 : this.entity.getIndirectPassengers()) {
                int var3 = var2.getType().clientTrackingRange() * 16;
                if (var3 <= var0) continue;
                var0 = var3;
            }
            return this.scaledRange(var0);
        }

        public void updatePlayers(List<EntityPlayer> var0) {
            for (EntityPlayer var2 : var0) {
                this.updatePlayer(var2);
            }
        }
    }
}

