/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.List;
import java.util.concurrent.Executor;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentChat;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.ChatSender;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.ScoreboardTeam;

public class CommandTeamMsg {
    private static final ChatModifier SUGGEST_STYLE = ChatModifier.EMPTY.withHoverEvent(new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_TEXT, IChatBaseComponent.translatable("chat.type.team.hover"))).withClickEvent(new ChatClickable(ChatClickable.EnumClickAction.SUGGEST_COMMAND, "/teammsg "));
    private static final SimpleCommandExceptionType ERROR_NOT_ON_TEAM = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.teammsg.failed.noteam"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        LiteralCommandNode var1 = var02.register((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("teammsg").then(net.minecraft.commands.CommandDispatcher.argument("message", ArgumentChat.message()).executes(var0 -> CommandTeamMsg.sendMessage((CommandListenerWrapper)var0.getSource(), ArgumentChat.getChatMessage((CommandContext<CommandListenerWrapper>)var0, "message")))));
        var02.register((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("tm").redirect((CommandNode)var1));
    }

    private static int sendMessage(CommandListenerWrapper var0, ArgumentChat.a var1) throws CommandSyntaxException {
        Entity var22 = var0.getEntityOrException();
        ScoreboardTeam var3 = (ScoreboardTeam)var22.getTeam();
        if (var3 == null) {
            throw ERROR_NOT_ON_TEAM.create();
        }
        IChatMutableComponent var4 = var3.getFormattedDisplayName().withStyle(SUGGEST_STYLE);
        ChatSender var52 = var0.asChatSender().withTeamName(var4);
        List<EntityPlayer> var6 = var0.getServer().getPlayerList().getPlayers().stream().filter(var2 -> var2 == var22 || var2.getTeam() == var3).toList();
        if (var6.isEmpty()) {
            return 0;
        }
        var1.resolve(var0).thenAcceptAsync(var5 -> {
            for (EntityPlayer var7 : var6) {
                if (var7 == var22) {
                    var7.sendSystemMessage(IChatBaseComponent.translatable("chat.type.team.sent", var4, var0.getDisplayName(), ((PlayerChatMessage)var5.raw()).serverContent()));
                    continue;
                }
                PlayerChatMessage var8 = (PlayerChatMessage)var5.filter(var0, var7);
                if (var8 == null) continue;
                var7.sendChatMessage(var8, var52, ChatMessageType.TEAM_MSG_COMMAND);
            }
        }, (Executor)var0.getServer());
        return var6.size();
    }
}

