/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.datafixers.util.Pair;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.server.DataPackResources;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.resources.IReloadableResourceManager;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.DataPackConfiguration;

public class WorldLoader {
    public static <D, R> CompletableFuture<R> load(a var0, d<D> var12, c<D, R> var22, Executor var3, Executor var42) {
        try {
            Pair<DataPackConfiguration, IReloadableResourceManager> var5 = var0.packConfig.createResourceManager();
            IReloadableResourceManager var6 = (IReloadableResourceManager)var5.getSecond();
            Pair<D, IRegistryCustom.Dimension> var7 = var12.get(var6, (DataPackConfiguration)var5.getFirst());
            Object var8 = var7.getFirst();
            IRegistryCustom.Dimension var9 = (IRegistryCustom.Dimension)var7.getSecond();
            return ((CompletableFuture)DataPackResources.loadResources(var6, var9, var0.commandSelection(), var0.functionCompilationLevel(), var3, var42).whenComplete((var1, var2) -> {
                if (var2 != null) {
                    var6.close();
                }
            })).thenApplyAsync(var4 -> {
                var4.updateRegistryTags(var9);
                return var22.create(var6, (DataPackResources)var4, var9, (Object)var8);
            }, var42);
        }
        catch (Exception var5) {
            return CompletableFuture.failedFuture(var5);
        }
    }

    public static final class a
    extends Record {
        final b packConfig;
        private final CommandDispatcher.ServerType commandSelection;
        private final int functionCompilationLevel;

        public a(b var0, CommandDispatcher.ServerType var1, int var2) {
            this.packConfig = var0;
            this.commandSelection = var1;
            this.functionCompilationLevel = var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "packConfig;commandSelection;functionCompilationLevel", "packConfig", "commandSelection", "functionCompilationLevel"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "packConfig;commandSelection;functionCompilationLevel", "packConfig", "commandSelection", "functionCompilationLevel"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "packConfig;commandSelection;functionCompilationLevel", "packConfig", "commandSelection", "functionCompilationLevel"}, this, var0);
        }

        public b packConfig() {
            return this.packConfig;
        }

        public CommandDispatcher.ServerType commandSelection() {
            return this.commandSelection;
        }

        public int functionCompilationLevel() {
            return this.functionCompilationLevel;
        }
    }

    public record b(ResourcePackRepository packRepository, DataPackConfiguration initialDataPacks, boolean safeMode) {
        public Pair<DataPackConfiguration, IReloadableResourceManager> createResourceManager() {
            DataPackConfiguration var0 = MinecraftServer.configurePackRepository(this.packRepository, this.initialDataPacks, this.safeMode);
            List<IResourcePack> var1 = this.packRepository.openAllSelected();
            ResourceManager var2 = new ResourceManager(EnumResourcePackType.SERVER_DATA, var1);
            return Pair.of((Object)var0, (Object)var2);
        }
    }

    @FunctionalInterface
    public static interface d<D> {
        public Pair<D, IRegistryCustom.Dimension> get(IResourceManager var1, DataPackConfiguration var2);
    }

    @FunctionalInterface
    public static interface c<D, R> {
        public R create(IReloadableResourceManager var1, DataPackResources var2, IRegistryCustom.Dimension var3, D var4);
    }
}

