/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;

public class HolderSetCodec<E>
implements Codec<HolderSet<E>> {
    private final ResourceKey<? extends IRegistry<E>> registryKey;
    private final Codec<Holder<E>> elementCodec;
    private final Codec<List<Holder<E>>> homogenousListCodec;
    private final Codec<Either<TagKey<E>, List<Holder<E>>>> registryAwareCodec;

    private static <E> Codec<List<Holder<E>>> homogenousList(Codec<Holder<E>> var03, boolean var1) {
        Function var2 = ExtraCodecs.ensureHomogenous(Holder::kind);
        Codec var3 = var03.listOf().flatXmap(var2, var2);
        if (var1) {
            return var3;
        }
        return Codec.either((Codec)var3, var03).xmap(var02 -> (List)var02.map(var0 -> var0, List::of), var0 -> var0.size() == 1 ? Either.right((Object)((Holder)var0.get(0))) : Either.left((Object)var0));
    }

    public static <E> Codec<HolderSet<E>> create(ResourceKey<? extends IRegistry<E>> var0, Codec<Holder<E>> var1, boolean var2) {
        return new HolderSetCodec<E>(var0, var1, var2);
    }

    private HolderSetCodec(ResourceKey<? extends IRegistry<E>> var0, Codec<Holder<E>> var1, boolean var2) {
        this.registryKey = var0;
        this.elementCodec = var1;
        this.homogenousListCodec = HolderSetCodec.homogenousList(var1, var2);
        this.registryAwareCodec = Codec.either(TagKey.hashedCodec(var0), this.homogenousListCodec);
    }

    public <T> DataResult<Pair<HolderSet<E>, T>> decode(DynamicOps<T> var0, T var1) {
        RegistryOps var2;
        Optional var3;
        if (var0 instanceof RegistryOps && (var3 = (var2 = (RegistryOps)var0).registry(this.registryKey)).isPresent()) {
            IRegistry var4 = var3.get();
            return this.registryAwareCodec.decode(var0, var1).map(var12 -> var12.mapFirst(var1 -> (HolderSet)var1.map(var4::getOrCreateTag, HolderSet::direct)));
        }
        return this.decodeWithoutRegistry(var0, var1);
    }

    public <T> DataResult<T> encode(HolderSet<E> var0, DynamicOps<T> var1, T var2) {
        RegistryOps var3;
        Optional var4;
        if (var1 instanceof RegistryOps && (var4 = (var3 = (RegistryOps)var1).registry(this.registryKey)).isPresent()) {
            if (!var0.isValidInRegistry(var4.get())) {
                return DataResult.error((String)("HolderSet " + var0 + " is not valid in current registry set"));
            }
            return this.registryAwareCodec.encode((Object)var0.unwrap().mapRight(List::copyOf), var1, var2);
        }
        return this.encodeWithoutRegistry(var0, var1, var2);
    }

    private <T> DataResult<Pair<HolderSet<E>, T>> decodeWithoutRegistry(DynamicOps<T> var02, T var1) {
        return this.elementCodec.listOf().decode(var02, var1).flatMap(var0 -> {
            ArrayList<Holder.a> var1 = new ArrayList<Holder.a>();
            for (Holder var3 : (List)var0.getFirst()) {
                if (var3 instanceof Holder.a) {
                    Holder.a var4 = (Holder.a)var3;
                    var1.add(var4);
                    continue;
                }
                return DataResult.error((String)("Can't decode element " + var3 + " without registry"));
            }
            return DataResult.success((Object)new Pair(HolderSet.direct(var1), var0.getSecond()));
        });
    }

    private <T> DataResult<T> encodeWithoutRegistry(HolderSet<E> var0, DynamicOps<T> var1, T var2) {
        return this.homogenousListCodec.encode(var0.stream().toList(), var1, var2);
    }

    public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
        return this.encode((HolderSet)object, dynamicOps, object2);
    }
}

