/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.crafting.IRecipe;

public class PacketPlayOutRecipeUpdate
implements Packet<PacketListenerPlayOut> {
    private final List<IRecipe<?>> recipes;

    public PacketPlayOutRecipeUpdate(Collection<IRecipe<?>> var0) {
        this.recipes = Lists.newArrayList(var0);
    }

    public PacketPlayOutRecipeUpdate(PacketDataSerializer var0) {
        this.recipes = var0.readList(PacketPlayOutRecipeUpdate::fromNetwork);
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeCollection(this.recipes, PacketPlayOutRecipeUpdate::toNetwork);
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleUpdateRecipes(this);
    }

    public List<IRecipe<?>> getRecipes() {
        return this.recipes;
    }

    public static IRecipe<?> fromNetwork(PacketDataSerializer var0) {
        MinecraftKey var1 = var0.readResourceLocation();
        MinecraftKey var2 = var0.readResourceLocation();
        return IRegistry.RECIPE_SERIALIZER.getOptional(var1).orElseThrow(() -> new IllegalArgumentException("Unknown recipe serializer " + var1)).fromNetwork(var2, var0);
    }

    public static <T extends IRecipe<?>> void toNetwork(PacketDataSerializer var0, T var1) {
        var0.writeResourceLocation(IRegistry.RECIPE_SERIALIZER.getKey(var1.getSerializer()));
        var0.writeResourceLocation(var1.getId());
        var1.getSerializer().toNetwork(var0, var1);
    }
}

