/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.util.UtilColor;

public class PacketPlayInChat
implements Packet<PacketListenerPlayIn> {
    public static final Duration MESSAGE_EXPIRES_AFTER = Duration.ofMinutes(5L);
    private final String message;
    private final Instant timeStamp;
    private final MinecraftEncryption.b saltSignature;
    private final boolean signedPreview;

    public PacketPlayInChat(String var0, MessageSignature var1, boolean var2) {
        this.message = UtilColor.trimChatMessage(var0);
        this.timeStamp = var1.timeStamp();
        this.saltSignature = var1.saltSignature();
        this.signedPreview = var2;
    }

    public PacketPlayInChat(PacketDataSerializer var0) {
        this.message = var0.readUtf(256);
        this.timeStamp = var0.readInstant();
        this.saltSignature = new MinecraftEncryption.b(var0);
        this.signedPreview = var0.readBoolean();
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeUtf(this.message, 256);
        var0.writeInstant(this.timeStamp);
        MinecraftEncryption.b.write(var0, this.saltSignature);
        var0.writeBoolean(this.signedPreview);
    }

    @Override
    public void handle(PacketListenerPlayIn var0) {
        var0.handleChat(this);
    }

    public String getMessage() {
        return this.message;
    }

    public MessageSignature getSignature(UUID var0) {
        return new MessageSignature(var0, this.timeStamp, this.saltSignature);
    }

    public Instant getTimeStamp() {
        return this.timeStamp;
    }

    public boolean signedPreview() {
        return this.signedPreview;
    }
}

