/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.Objects;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;

public record ClientboundSystemChatPacket(IChatBaseComponent content, int typeId) implements Packet<PacketListenerPlayOut>
{
    public ClientboundSystemChatPacket(PacketDataSerializer var0) {
        this(var0.readComponent(), var0.readVarInt());
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeComponent(this.content);
        var0.writeVarInt(this.typeId);
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleSystemChat(this);
    }

    @Override
    public boolean isSkippable() {
        return true;
    }

    public ChatMessageType resolveType(IRegistry<ChatMessageType> var0) {
        return Objects.requireNonNull((ChatMessageType)var0.byId(this.typeId), "Invalid chat type");
    }
}

