/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.ChatSender;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayInChat;
import net.minecraft.util.MinecraftEncryption;

public record ClientboundPlayerChatPacket(IChatBaseComponent signedContent, Optional<IChatBaseComponent> unsignedContent, int typeId, ChatSender sender, Instant timeStamp, MinecraftEncryption.b saltSignature) implements Packet<PacketListenerPlayOut>
{
    private static final Duration MESSAGE_EXPIRES_AFTER = PacketPlayInChat.MESSAGE_EXPIRES_AFTER.plus(Duration.ofMinutes(2L));

    public ClientboundPlayerChatPacket(PacketDataSerializer var0) {
        this(var0.readComponent(), var0.readOptional(PacketDataSerializer::readComponent), var0.readVarInt(), new ChatSender(var0), var0.readInstant(), new MinecraftEncryption.b(var0));
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeComponent(this.signedContent);
        var0.writeOptional(this.unsignedContent, PacketDataSerializer::writeComponent);
        var0.writeVarInt(this.typeId);
        this.sender.write(var0);
        var0.writeInstant(this.timeStamp);
        MinecraftEncryption.b.write(var0, this.saltSignature);
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handlePlayerChat(this);
    }

    @Override
    public boolean isSkippable() {
        return true;
    }

    public PlayerChatMessage getMessage() {
        MessageSignature var0 = new MessageSignature(this.sender.uuid(), this.timeStamp, this.saltSignature);
        return new PlayerChatMessage(this.signedContent, var0, this.unsignedContent);
    }

    private Instant getExpiresAt() {
        return this.timeStamp.plus(MESSAGE_EXPIRES_AFTER);
    }

    public boolean hasExpired(Instant var0) {
        return var0.isAfter(this.getExpiresAt());
    }

    public ChatMessageType resolveType(IRegistry<ChatMessageType> var0) {
        return Objects.requireNonNull((ChatMessageType)var0.byId(this.typeId), "Invalid chat type");
    }
}

