/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.levelgen.HeightMap;

public class ClientboundLevelChunkPacketData {
    private static final int TWO_MEGABYTES = 0x200000;
    private final NBTTagCompound heightmaps;
    private final byte[] buffer;
    private final List<a> blockEntitiesData;

    public ClientboundLevelChunkPacketData(Chunk var0) {
        this.heightmaps = new NBTTagCompound();
        for (Map.Entry<HeightMap.Type, HeightMap> entry : var0.getHeightmaps()) {
            if (!entry.getKey().sendToClient()) continue;
            this.heightmaps.put(entry.getKey().getSerializationKey(), new NBTTagLongArray(entry.getValue().getRawData()));
        }
        this.buffer = new byte[ClientboundLevelChunkPacketData.calculateChunkSize(var0)];
        ClientboundLevelChunkPacketData.extractChunkData(new PacketDataSerializer(this.getWriteBuffer()), var0);
        this.blockEntitiesData = Lists.newArrayList();
        for (Map.Entry<Object, Object> entry : var0.getBlockEntities().entrySet()) {
            this.blockEntitiesData.add(a.create((TileEntity)entry.getValue()));
        }
    }

    public ClientboundLevelChunkPacketData(PacketDataSerializer var0, int var1, int var2) {
        this.heightmaps = var0.readNbt();
        if (this.heightmaps == null) {
            throw new RuntimeException("Can't read heightmap in packet for [" + var1 + ", " + var2 + "]");
        }
        int var3 = var0.readVarInt();
        if (var3 > 0x200000) {
            throw new RuntimeException("Chunk Packet trying to allocate too much memory on read.");
        }
        this.buffer = new byte[var3];
        var0.readBytes(this.buffer);
        this.blockEntitiesData = var0.readList(a::new);
    }

    public void write(PacketDataSerializer var02) {
        var02.writeNbt(this.heightmaps);
        var02.writeVarInt(this.buffer.length);
        var02.writeBytes(this.buffer);
        var02.writeCollection(this.blockEntitiesData, (var0, var1) -> var1.write((PacketDataSerializer)((Object)var0)));
    }

    private static int calculateChunkSize(Chunk var0) {
        int var1 = 0;
        for (ChunkSection var5 : var0.getSections()) {
            var1 += var5.getSerializedSize();
        }
        return var1;
    }

    private ByteBuf getWriteBuffer() {
        ByteBuf var0 = Unpooled.wrappedBuffer((byte[])this.buffer);
        var0.writerIndex(0);
        return var0;
    }

    public static void extractChunkData(PacketDataSerializer var0, Chunk var1) {
        for (ChunkSection var5 : var1.getSections()) {
            var5.write(var0);
        }
    }

    public Consumer<b> getBlockEntitiesTagsConsumer(int var0, int var1) {
        return var2 -> this.getBlockEntitiesTags((b)var2, var0, var1);
    }

    private void getBlockEntitiesTags(b var0, int var1, int var2) {
        int var3 = 16 * var1;
        int var4 = 16 * var2;
        BlockPosition.MutableBlockPosition var5 = new BlockPosition.MutableBlockPosition();
        for (a var7 : this.blockEntitiesData) {
            int var8 = var3 + SectionPosition.sectionRelative(var7.packedXZ >> 4);
            int var9 = var4 + SectionPosition.sectionRelative(var7.packedXZ);
            var5.set(var8, var7.y, var9);
            var0.accept(var5, var7.type, var7.tag);
        }
    }

    public PacketDataSerializer getReadBuffer() {
        return new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])this.buffer));
    }

    public NBTTagCompound getHeightmaps() {
        return this.heightmaps;
    }

    static class a {
        final int packedXZ;
        final int y;
        final TileEntityTypes<?> type;
        @Nullable
        final NBTTagCompound tag;

        private a(int var0, int var1, TileEntityTypes<?> var2, @Nullable NBTTagCompound var3) {
            this.packedXZ = var0;
            this.y = var1;
            this.type = var2;
            this.tag = var3;
        }

        private a(PacketDataSerializer var0) {
            this.packedXZ = var0.readByte();
            this.y = var0.readShort();
            this.type = var0.readById(IRegistry.BLOCK_ENTITY_TYPE);
            this.tag = var0.readNbt();
        }

        void write(PacketDataSerializer var0) {
            var0.writeByte(this.packedXZ);
            var0.writeShort(this.y);
            var0.writeId(IRegistry.BLOCK_ENTITY_TYPE, this.type);
            var0.writeNbt(this.tag);
        }

        static a create(TileEntity var0) {
            NBTTagCompound var1 = var0.getUpdateTag();
            BlockPosition var2 = var0.getBlockPos();
            int var3 = SectionPosition.sectionRelative(var2.getX()) << 4 | SectionPosition.sectionRelative(var2.getZ());
            return new a(var3, var2.getY(), var0.getType(), var1.isEmpty() ? null : var1);
        }
    }

    @FunctionalInterface
    public static interface b {
        public void accept(BlockPosition var1, TileEntityTypes<?> var2, @Nullable NBTTagCompound var3);
    }
}

