/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import java.util.Optional;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.world.entity.player.ProfilePublicKey;

public record PlayerChatMessage(IChatBaseComponent signedContent, MessageSignature signature, Optional<IChatBaseComponent> unsignedContent) {
    public static PlayerChatMessage signed(IChatBaseComponent var0, MessageSignature var1) {
        return new PlayerChatMessage(var0, var1, Optional.empty());
    }

    public static PlayerChatMessage signed(String var0, MessageSignature var1) {
        return PlayerChatMessage.signed(IChatBaseComponent.literal(var0), var1);
    }

    public static PlayerChatMessage signed(IChatBaseComponent var0, IChatBaseComponent var1, MessageSignature var2, boolean var3) {
        if (var0.equals(var1)) {
            return PlayerChatMessage.signed(var0, var2);
        }
        if (!var3) {
            return PlayerChatMessage.signed(var0, var2).withUnsignedContent(var1);
        }
        return PlayerChatMessage.signed(var1, var2);
    }

    public static FilteredText<PlayerChatMessage> filteredSigned(FilteredText<IChatBaseComponent> var0, FilteredText<IChatBaseComponent> var1, MessageSignature var2, boolean var3) {
        IChatBaseComponent var4 = var0.raw();
        IChatBaseComponent var5 = var1.raw();
        PlayerChatMessage var6 = PlayerChatMessage.signed(var4, var5, var2, var3);
        if (var1.isFiltered()) {
            PlayerChatMessage var7 = SystemUtils.mapNullable(var1.filtered(), PlayerChatMessage::unsigned);
            return new FilteredText<PlayerChatMessage>(var6, var7);
        }
        return FilteredText.passThrough(var6);
    }

    public static PlayerChatMessage unsigned(IChatBaseComponent var0) {
        return new PlayerChatMessage(var0, MessageSignature.unsigned(), Optional.empty());
    }

    public PlayerChatMessage withUnsignedContent(IChatBaseComponent var0) {
        return new PlayerChatMessage(this.signedContent, this.signature, Optional.of(var0));
    }

    public boolean verify(ProfilePublicKey var0) {
        return this.signature.verify(var0.createSignatureValidator(), this.signedContent);
    }

    public boolean verify(EntityPlayer var0) {
        ProfilePublicKey var1 = var0.getProfilePublicKey();
        return var1 == null || this.verify(var1);
    }

    public boolean verify(CommandListenerWrapper var0) {
        EntityPlayer var1 = var0.getPlayer();
        return var1 == null || this.verify(var1);
    }

    public IChatBaseComponent serverContent() {
        return this.unsignedContent.orElse(this.signedContent);
    }
}

