/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.SignatureException;
import java.time.Instant;
import java.util.UUID;
import net.minecraft.SystemUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.util.SignatureUpdater;
import net.minecraft.util.SignatureValidator;

public record MessageSignature(UUID sender, Instant timeStamp, MinecraftEncryption.b saltSignature) {
    public static MessageSignature unsigned() {
        return new MessageSignature(SystemUtils.NIL_UUID, Instant.now(), MinecraftEncryption.b.EMPTY);
    }

    public boolean verify(SignatureValidator var0, IChatBaseComponent var12) {
        if (this.isValid()) {
            return var0.validate(var1 -> MessageSignature.updateSignature(var1, var12, this.sender, this.timeStamp, this.saltSignature.salt()), this.saltSignature.signature());
        }
        return false;
    }

    public boolean verify(SignatureValidator var0, String var1) throws SignatureException {
        return this.verify(var0, IChatBaseComponent.literal(var1));
    }

    public static void updateSignature(SignatureUpdater.a var0, IChatBaseComponent var1, UUID var2, Instant var3, long var4) throws SignatureException {
        byte[] var6 = new byte[32];
        ByteBuffer var7 = ByteBuffer.wrap(var6).order(ByteOrder.BIG_ENDIAN);
        var7.putLong(var4);
        var7.putLong(var2.getMostSignificantBits()).putLong(var2.getLeastSignificantBits());
        var7.putLong(var3.getEpochSecond());
        var0.update(var6);
        var0.update(MessageSignature.encodeContent(var1));
    }

    private static byte[] encodeContent(IChatBaseComponent var0) {
        String var1 = IChatBaseComponent.ChatSerializer.toStableJson(var0);
        return var1.getBytes(StandardCharsets.UTF_8);
    }

    public boolean isValid() {
        return this.sender != SystemUtils.NIL_UUID && this.saltSignature.isValid();
    }

    public boolean isValid(UUID var0) {
        return this.isValid() && var0.equals(this.sender);
    }
}

