/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.network.chat.ChatDecoration;
import net.minecraft.network.chat.ChatSender;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.INamable;

public record ChatMessageType(Optional<b> chat, Optional<b> overlay, Optional<a> narration) {
    public static final Codec<ChatMessageType> CODEC = RecordCodecBuilder.create((T var0) -> var0.group((App)b.CODEC.optionalFieldOf("chat").forGetter(ChatMessageType::chat), (App)b.CODEC.optionalFieldOf("overlay").forGetter(ChatMessageType::overlay), (App)a.CODEC.optionalFieldOf("narration").forGetter(ChatMessageType::narration)).apply((Applicative)var0, ChatMessageType::new));
    public static final ResourceKey<ChatMessageType> CHAT = ChatMessageType.create("chat");
    public static final ResourceKey<ChatMessageType> SYSTEM = ChatMessageType.create("system");
    public static final ResourceKey<ChatMessageType> GAME_INFO = ChatMessageType.create("game_info");
    public static final ResourceKey<ChatMessageType> SAY_COMMAND = ChatMessageType.create("say_command");
    public static final ResourceKey<ChatMessageType> MSG_COMMAND = ChatMessageType.create("msg_command");
    public static final ResourceKey<ChatMessageType> TEAM_MSG_COMMAND = ChatMessageType.create("team_msg_command");
    public static final ResourceKey<ChatMessageType> EMOTE_COMMAND = ChatMessageType.create("emote_command");
    public static final ResourceKey<ChatMessageType> TELLRAW_COMMAND = ChatMessageType.create("tellraw_command");

    private static ResourceKey<ChatMessageType> create(String var0) {
        return ResourceKey.create(IRegistry.CHAT_TYPE_REGISTRY, new MinecraftKey(var0));
    }

    public static Holder<ChatMessageType> bootstrap(IRegistry<ChatMessageType> var0) {
        RegistryGeneration.register(var0, CHAT, new ChatMessageType(Optional.of(b.decorated(ChatDecoration.withSender("chat.type.text"))), Optional.empty(), Optional.of(a.decorated(ChatDecoration.withSender("chat.type.text.narrate"), a.a.CHAT))));
        RegistryGeneration.register(var0, SYSTEM, new ChatMessageType(Optional.of(b.undecorated()), Optional.empty(), Optional.of(a.undecorated(a.a.SYSTEM))));
        RegistryGeneration.register(var0, GAME_INFO, new ChatMessageType(Optional.empty(), Optional.of(b.undecorated()), Optional.empty()));
        RegistryGeneration.register(var0, SAY_COMMAND, new ChatMessageType(Optional.of(b.decorated(ChatDecoration.withSender("chat.type.announcement"))), Optional.empty(), Optional.of(a.decorated(ChatDecoration.withSender("chat.type.text.narrate"), a.a.CHAT))));
        RegistryGeneration.register(var0, MSG_COMMAND, new ChatMessageType(Optional.of(b.decorated(ChatDecoration.directMessage("commands.message.display.incoming"))), Optional.empty(), Optional.of(a.decorated(ChatDecoration.withSender("chat.type.text.narrate"), a.a.CHAT))));
        RegistryGeneration.register(var0, TEAM_MSG_COMMAND, new ChatMessageType(Optional.of(b.decorated(ChatDecoration.teamMessage("chat.type.team.text"))), Optional.empty(), Optional.of(a.decorated(ChatDecoration.withSender("chat.type.text.narrate"), a.a.CHAT))));
        RegistryGeneration.register(var0, EMOTE_COMMAND, new ChatMessageType(Optional.of(b.decorated(ChatDecoration.withSender("chat.type.emote"))), Optional.empty(), Optional.of(a.decorated(ChatDecoration.withSender("chat.type.emote"), a.a.CHAT))));
        return RegistryGeneration.register(var0, TELLRAW_COMMAND, new ChatMessageType(Optional.of(b.undecorated()), Optional.empty(), Optional.of(a.undecorated(a.a.CHAT))));
    }

    public record b(Optional<ChatDecoration> decoration) {
        public static final Codec<b> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ChatDecoration.CODEC.optionalFieldOf("decoration").forGetter(b::decoration)).apply((Applicative)var0, b::new));

        public static b undecorated() {
            return new b(Optional.empty());
        }

        public static b decorated(ChatDecoration var0) {
            return new b(Optional.of(var0));
        }

        public IChatBaseComponent decorate(IChatBaseComponent var0, @Nullable ChatSender var1) {
            return this.decoration.map(var2 -> var2.decorate(var0, var1)).orElse(var0);
        }
    }

    public record net.minecraft.network.chat.ChatMessageType$a(Optional<ChatDecoration> decoration, a priority) {
        public static final Codec<net.minecraft.network.chat.ChatMessageType$a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ChatDecoration.CODEC.optionalFieldOf("decoration").forGetter(net.minecraft.network.chat.ChatMessageType$a::decoration), (App)a.CODEC.fieldOf("priority").forGetter(net.minecraft.network.chat.ChatMessageType$a::priority)).apply((Applicative)var0, net.minecraft.network.chat.ChatMessageType$a::new));

        public static net.minecraft.network.chat.ChatMessageType$a undecorated(a var0) {
            return new net.minecraft.network.chat.ChatMessageType$a(Optional.empty(), var0);
        }

        public static net.minecraft.network.chat.ChatMessageType$a decorated(ChatDecoration var0, a var1) {
            return new net.minecraft.network.chat.ChatMessageType$a(Optional.of(var0), var1);
        }

        public IChatBaseComponent decorate(IChatBaseComponent var0, @Nullable ChatSender var1) {
            return this.decoration.map(var2 -> var2.decorate(var0, var1)).orElse(var0);
        }

        public static final class a
        extends Enum<a>
        implements INamable {
            public static final /* enum */ a CHAT = new a("chat", false);
            public static final /* enum */ a SYSTEM = new a("system", true);
            public static final Codec<a> CODEC;
            private final String name;
            private final boolean interrupts;
            private static final /* synthetic */ a[] f;

            public static a[] values() {
                return (a[])f.clone();
            }

            public static a valueOf(String var0) {
                return Enum.valueOf(a.class, var0);
            }

            private a(String var2, boolean var3) {
                this.name = var2;
                this.interrupts = var3;
            }

            public boolean interrupts() {
                return this.interrupts;
            }

            @Override
            public String getSerializedName() {
                return this.name;
            }

            private static /* synthetic */ a[] b() {
                return new a[]{CHAT, SYSTEM};
            }

            static {
                f = a.b();
                CODEC = INamable.fromEnum(a::values);
            }
        }
    }
}

