/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.FilteredText;

@FunctionalInterface
public interface ChatDecorator {
    public static final ChatDecorator PLAIN = (var0, var1) -> CompletableFuture.completedFuture(var1);

    public CompletableFuture<IChatBaseComponent> decorate(@Nullable EntityPlayer var1, IChatBaseComponent var2);

    default public CompletableFuture<FilteredText<IChatBaseComponent>> decorateFiltered(@Nullable EntityPlayer var0, FilteredText<IChatBaseComponent> var1) {
        CompletableFuture<IChatBaseComponent> var22 = this.decorate(var0, var1.raw());
        if (!var1.isFiltered()) {
            return var22.thenApply(FilteredText::passThrough);
        }
        if (var1.filtered() == null) {
            return var22.thenApply(FilteredText::fullyFiltered);
        }
        CompletableFuture<IChatBaseComponent> var3 = this.decorate(var0, var1.filtered());
        return CompletableFuture.allOf(var22, var3).thenApply(var2 -> new FilteredText<IChatBaseComponent>((IChatBaseComponent)var22.join(), (IChatBaseComponent)var3.join()));
    }

    default public CompletableFuture<FilteredText<PlayerChatMessage>> decorateChat(@Nullable EntityPlayer var0, FilteredText<IChatBaseComponent> var1, MessageSignature var2, boolean var32) {
        return this.decorateFiltered(var0, var1).thenApply(var3 -> PlayerChatMessage.filteredSigned(var1, var3, var2, var32));
    }
}

