/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.ChatSender;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.INamable;

public record ChatDecoration(String translationKey, List<a> parameters, ChatModifier style) {
    public static final Codec<ChatDecoration> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.STRING.fieldOf("translation_key").forGetter(ChatDecoration::translationKey), (App)a.CODEC.listOf().fieldOf("parameters").forGetter(ChatDecoration::parameters), (App)ChatModifier.FORMATTING_CODEC.fieldOf("style").forGetter(ChatDecoration::style)).apply((Applicative)var0, ChatDecoration::new));

    public static ChatDecoration withSender(String var0) {
        return new ChatDecoration(var0, List.of(a.SENDER, a.CONTENT), ChatModifier.EMPTY);
    }

    public static ChatDecoration directMessage(String var0) {
        ChatModifier var1 = ChatModifier.EMPTY.withColor(EnumChatFormat.GRAY).withItalic(true);
        return new ChatDecoration(var0, List.of(a.SENDER, a.CONTENT), var1);
    }

    public static ChatDecoration teamMessage(String var0) {
        return new ChatDecoration(var0, List.of(a.TEAM_NAME, a.SENDER, a.CONTENT), ChatModifier.EMPTY);
    }

    public IChatBaseComponent decorate(IChatBaseComponent var0, @Nullable ChatSender var1) {
        Object[] var2 = this.resolveParameters(var0, var1);
        return IChatBaseComponent.translatable(this.translationKey, var2).withStyle(this.style);
    }

    private IChatBaseComponent[] resolveParameters(IChatBaseComponent var0, @Nullable ChatSender var1) {
        IChatBaseComponent[] var2 = new IChatBaseComponent[this.parameters.size()];
        for (int var3 = 0; var3 < var2.length; ++var3) {
            a var4 = this.parameters.get(var3);
            var2[var3] = var4.select(var0, var1);
        }
        return var2;
    }

    public static final class net.minecraft.network.chat.ChatDecoration$a
    extends Enum<net.minecraft.network.chat.ChatDecoration$a>
    implements INamable {
        public static final /* enum */ net.minecraft.network.chat.ChatDecoration$a SENDER = new net.minecraft.network.chat.ChatDecoration$a("sender", (var0, var1) -> var1 != null ? var1.name() : null);
        public static final /* enum */ net.minecraft.network.chat.ChatDecoration$a TEAM_NAME = new net.minecraft.network.chat.ChatDecoration$a("team_name", (var0, var1) -> var1 != null ? var1.teamName() : null);
        public static final /* enum */ net.minecraft.network.chat.ChatDecoration$a CONTENT = new net.minecraft.network.chat.ChatDecoration$a("content", (var0, var1) -> var0);
        public static final Codec<net.minecraft.network.chat.ChatDecoration$a> CODEC;
        private final String name;
        private final a selector;
        private static final /* synthetic */ net.minecraft.network.chat.ChatDecoration$a[] g;

        public static net.minecraft.network.chat.ChatDecoration$a[] values() {
            return (net.minecraft.network.chat.ChatDecoration$a[])g.clone();
        }

        public static net.minecraft.network.chat.ChatDecoration$a valueOf(String var0) {
            return Enum.valueOf(net.minecraft.network.chat.ChatDecoration$a.class, var0);
        }

        private net.minecraft.network.chat.ChatDecoration$a(String var2, a var3) {
            this.name = var2;
            this.selector = var3;
        }

        public IChatBaseComponent select(IChatBaseComponent var0, @Nullable ChatSender var1) {
            IChatBaseComponent var2 = this.selector.select(var0, var1);
            return Objects.requireNonNullElse(var2, CommonComponents.EMPTY);
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ net.minecraft.network.chat.ChatDecoration$a[] a() {
            return new net.minecraft.network.chat.ChatDecoration$a[]{SENDER, TEAM_NAME, CONTENT};
        }

        static {
            g = net.minecraft.network.chat.ChatDecoration$a.a();
            CODEC = INamable.fromEnum(net.minecraft.network.chat.ChatDecoration$a::values);
        }

        public static interface a {
            @Nullable
            public IChatBaseComponent select(IChatBaseComponent var1, @Nullable ChatSender var2);
        }
    }
}

