/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.mojang.logging.LogUtils;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.game.PacketPlayOutKickDisconnect;
import org.slf4j.Logger;

public class NetworkManagerServer
extends NetworkManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final IChatBaseComponent EXCEED_REASON = IChatBaseComponent.translatable("disconnect.exceeded_packet_rate");
    private final int rateLimitPacketsPerSecond;

    public NetworkManagerServer(int var0) {
        super(EnumProtocolDirection.SERVERBOUND);
        this.rateLimitPacketsPerSecond = var0;
    }

    @Override
    protected void tickSecond() {
        super.tickSecond();
        float var02 = this.getAverageReceivedPackets();
        if (var02 > (float)this.rateLimitPacketsPerSecond) {
            LOGGER.warn("Player exceeded rate-limit (sent {} packets per second)", (Object)Float.valueOf(var02));
            this.send(new PacketPlayOutKickDisconnect(EXCEED_REASON), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)var0 -> this.disconnect(EXCEED_REASON)));
            this.setReadOnly();
        }
    }
}

