/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.locale;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatFormatted;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.FormattedString;
import net.minecraft.util.StringDecomposer;
import org.slf4j.Logger;

public abstract class LocaleLanguage {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new Gson();
    private static final Pattern UNSUPPORTED_FORMAT_PATTERN = Pattern.compile("%(\\d+\\$)?[\\d.]*[df]");
    public static final String DEFAULT = "en_us";
    private static volatile LocaleLanguage instance = LocaleLanguage.loadDefault();

    private static LocaleLanguage loadDefault() {
        InputStream var3;
        ImmutableMap.Builder var0 = ImmutableMap.builder();
        BiConsumer<String, String> var1 = (arg_0, arg_1) -> ((ImmutableMap.Builder)var0).put(arg_0, arg_1);
        String var2 = "/assets/minecraft/lang/en_us.json";
        try {
            var3 = LocaleLanguage.class.getResourceAsStream("/assets/minecraft/lang/en_us.json");
            try {
                LocaleLanguage.loadFromJson(var3, var1);
            }
            finally {
                if (var3 != null) {
                    var3.close();
                }
            }
        }
        catch (JsonParseException | IOException var32) {
            LOGGER.error("Couldn't read strings from {}", (Object)"/assets/minecraft/lang/en_us.json", (Object)var32);
        }
        var3 = var0.build();
        return new LocaleLanguage((Map)((Object)var3)){
            final /* synthetic */ Map b;
            {
                this.b = map;
            }

            @Override
            public String getOrDefault(String var0) {
                return this.b.getOrDefault(var0, var0);
            }

            @Override
            public boolean has(String var0) {
                return this.b.containsKey(var0);
            }

            @Override
            public boolean isDefaultRightToLeft() {
                return false;
            }

            @Override
            public FormattedString getVisualOrder(IChatFormatted var0) {
                return var12 -> var0.visit((var1, var2) -> StringDecomposer.iterateFormatted(var2, var1, var12) ? Optional.empty() : IChatFormatted.STOP_ITERATION, ChatModifier.EMPTY).isPresent();
            }
        };
    }

    public static void loadFromJson(InputStream var0, BiConsumer<String, String> var1) {
        JsonObject var2 = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(var0, StandardCharsets.UTF_8), JsonObject.class);
        for (Map.Entry var4 : var2.entrySet()) {
            String var5 = UNSUPPORTED_FORMAT_PATTERN.matcher(ChatDeserializer.convertToString((JsonElement)var4.getValue(), (String)var4.getKey())).replaceAll("%$1s");
            var1.accept((String)var4.getKey(), var5);
        }
    }

    public static LocaleLanguage getInstance() {
        return instance;
    }

    public static void inject(LocaleLanguage var0) {
        instance = var0;
    }

    public abstract String getOrDefault(String var1);

    public abstract boolean has(String var1);

    public abstract boolean isDefaultRightToLeft();

    public abstract FormattedString getVisualOrder(IChatFormatted var1);

    public List<FormattedString> getVisualOrder(List<IChatFormatted> var0) {
        return (List)var0.stream().map(this::getVisualOrder).collect(ImmutableList.toImmutableList());
    }
}

