/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.blocks.ArgumentTileLocation;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.structures.DebugReportNBT;
import net.minecraft.data.structures.StructureUpdater;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyStructureMode;
import net.minecraft.world.level.levelgen.flat.GeneratorSettingsFlat;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.ticks.TickListServer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class GameTestHarnessStructures {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String DEFAULT_TEST_STRUCTURES_DIR = "gameteststructures";
    public static String testStructuresDir = "gameteststructures";
    private static final int HOW_MANY_CHUNKS_TO_LOAD_IN_EACH_DIRECTION_OF_STRUCTURE = 4;

    public static EnumBlockRotation getRotationForRotationSteps(int var0) {
        switch (var0) {
            case 0: {
                return EnumBlockRotation.NONE;
            }
            case 1: {
                return EnumBlockRotation.CLOCKWISE_90;
            }
            case 2: {
                return EnumBlockRotation.CLOCKWISE_180;
            }
            case 3: {
                return EnumBlockRotation.COUNTERCLOCKWISE_90;
            }
        }
        throw new IllegalArgumentException("rotationSteps must be a value from 0-3. Got value " + var0);
    }

    public static int getRotationStepsForRotation(EnumBlockRotation var0) {
        switch (var0) {
            case NONE: {
                return 0;
            }
            case CLOCKWISE_90: {
                return 1;
            }
            case CLOCKWISE_180: {
                return 2;
            }
            case COUNTERCLOCKWISE_90: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unknown rotation value, don't know how many steps it represents: " + var0);
    }

    public static void main(String[] var02) throws IOException {
        DispenserRegistry.bootStrap();
        Files.walk(Paths.get(testStructuresDir, new String[0]), new FileVisitOption[0]).filter(var0 -> var0.toString().endsWith(".snbt")).forEach(var0 -> {
            try {
                String var1 = Files.readString(var0);
                NBTTagCompound var2 = GameProfileSerializer.snbtToStructure(var1);
                NBTTagCompound var3 = StructureUpdater.update(var0.toString(), var2);
                DebugReportNBT.writeSnbt(CachedOutput.NO_CACHE, var0, GameProfileSerializer.structureToSnbt(var3));
            }
            catch (CommandSyntaxException | IOException var1) {
                LOGGER.error("Something went wrong upgrading: {}", var0, (Object)var1);
            }
        });
    }

    public static AxisAlignedBB getStructureBounds(TileEntityStructure var0) {
        BlockPosition var1 = var0.getBlockPos();
        BlockPosition var2 = var1.offset(var0.getStructureSize().offset(-1, -1, -1));
        BlockPosition var3 = DefinedStructure.transform(var2, EnumBlockMirror.NONE, var0.getRotation(), var1);
        return new AxisAlignedBB(var1, var3);
    }

    public static StructureBoundingBox getStructureBoundingBox(TileEntityStructure var0) {
        BlockPosition var1 = var0.getBlockPos();
        BlockPosition var2 = var1.offset(var0.getStructureSize().offset(-1, -1, -1));
        BlockPosition var3 = DefinedStructure.transform(var2, EnumBlockMirror.NONE, var0.getRotation(), var1);
        return StructureBoundingBox.fromCorners(var1, var3);
    }

    public static void addCommandBlockAndButtonToStartTest(BlockPosition var0, BlockPosition var1, EnumBlockRotation var2, WorldServer var3) {
        BlockPosition var4 = DefinedStructure.transform(var0.offset(var1), EnumBlockMirror.NONE, var2, var0);
        var3.setBlockAndUpdate(var4, Blocks.COMMAND_BLOCK.defaultBlockState());
        TileEntityCommand var5 = (TileEntityCommand)var3.getBlockEntity(var4);
        var5.getCommandBlock().setCommand("test runthis");
        BlockPosition var6 = DefinedStructure.transform(var4.offset(0, 0, -1), EnumBlockMirror.NONE, var2, var4);
        var3.setBlockAndUpdate(var6, Blocks.STONE_BUTTON.defaultBlockState().rotate(var2));
    }

    public static void createNewEmptyStructureBlock(String var0, BlockPosition var1, BaseBlockPosition var2, EnumBlockRotation var3, WorldServer var4) {
        StructureBoundingBox var5 = GameTestHarnessStructures.getStructureBoundingBox(var1, var2, var3);
        GameTestHarnessStructures.clearSpaceForStructure(var5, var1.getY(), var4);
        var4.setBlockAndUpdate(var1, Blocks.STRUCTURE_BLOCK.defaultBlockState());
        TileEntityStructure var6 = (TileEntityStructure)var4.getBlockEntity(var1);
        var6.setIgnoreEntities(false);
        var6.setStructureName(new MinecraftKey(var0));
        var6.setStructureSize(var2);
        var6.setMode(BlockPropertyStructureMode.SAVE);
        var6.setShowBoundingBox(true);
    }

    public static TileEntityStructure spawnStructure(String var0, BlockPosition var1, EnumBlockRotation var2, int var3, WorldServer var4, boolean var5) {
        BlockPosition var8;
        BaseBlockPosition var6 = GameTestHarnessStructures.getStructureTemplate(var0, var4).getSize();
        StructureBoundingBox var7 = GameTestHarnessStructures.getStructureBoundingBox(var1, var6, var2);
        if (var2 == EnumBlockRotation.NONE) {
            var8 = var1;
        } else if (var2 == EnumBlockRotation.CLOCKWISE_90) {
            var8 = var1.offset(var6.getZ() - 1, 0, 0);
        } else if (var2 == EnumBlockRotation.CLOCKWISE_180) {
            var8 = var1.offset(var6.getX() - 1, 0, var6.getZ() - 1);
        } else if (var2 == EnumBlockRotation.COUNTERCLOCKWISE_90) {
            var8 = var1.offset(0, 0, var6.getX() - 1);
        } else {
            throw new IllegalArgumentException("Invalid rotation: " + var2);
        }
        GameTestHarnessStructures.forceLoadChunks(var1, var4);
        GameTestHarnessStructures.clearSpaceForStructure(var7, var1.getY(), var4);
        TileEntityStructure var9 = GameTestHarnessStructures.createStructureBlock(var0, var8, var2, var4, var5);
        ((TickListServer)var4.getBlockTicks()).clearArea(var7);
        var4.clearBlockEvents(var7);
        return var9;
    }

    private static void forceLoadChunks(BlockPosition var0, WorldServer var1) {
        ChunkCoordIntPair var2 = new ChunkCoordIntPair(var0);
        for (int var3 = -1; var3 < 4; ++var3) {
            for (int var4 = -1; var4 < 4; ++var4) {
                int var5 = var2.x + var3;
                int var6 = var2.z + var4;
                var1.setChunkForced(var5, var6, true);
            }
        }
    }

    public static void clearSpaceForStructure(StructureBoundingBox var02, int var1, WorldServer var22) {
        StructureBoundingBox var3 = new StructureBoundingBox(var02.minX() - 2, var02.minY() - 3, var02.minZ() - 3, var02.maxX() + 3, var02.maxY() + 20, var02.maxZ() + 3);
        BlockPosition.betweenClosedStream(var3).forEach(var2 -> GameTestHarnessStructures.clearBlock(var1, var2, var22));
        ((TickListServer)var22.getBlockTicks()).clearArea(var3);
        var22.clearBlockEvents(var3);
        AxisAlignedBB var4 = new AxisAlignedBB(var3.minX(), var3.minY(), var3.minZ(), var3.maxX(), var3.maxY(), var3.maxZ());
        List<Entity> var5 = var22.getEntitiesOfClass(Entity.class, var4, var0 -> !(var0 instanceof EntityHuman));
        var5.forEach(Entity::discard);
    }

    public static StructureBoundingBox getStructureBoundingBox(BlockPosition var0, BaseBlockPosition var1, EnumBlockRotation var2) {
        BlockPosition var3 = var0.offset(var1).offset(-1, -1, -1);
        BlockPosition var4 = DefinedStructure.transform(var3, EnumBlockMirror.NONE, var2, var0);
        StructureBoundingBox var5 = StructureBoundingBox.fromCorners(var0, var4);
        int var6 = Math.min(var5.minX(), var5.maxX());
        int var7 = Math.min(var5.minZ(), var5.maxZ());
        return var5.move(var0.getX() - var6, 0, var0.getZ() - var7);
    }

    public static Optional<BlockPosition> findStructureBlockContainingPos(BlockPosition var0, int var1, WorldServer var22) {
        return GameTestHarnessStructures.findStructureBlocks(var0, var1, var22).stream().filter(var2 -> GameTestHarnessStructures.doesStructureContain(var2, var0, var22)).findFirst();
    }

    @Nullable
    public static BlockPosition findNearestStructureBlock(BlockPosition var0, int var12, WorldServer var2) {
        Comparator<BlockPosition> var3 = Comparator.comparingInt(var1 -> var1.distManhattan(var0));
        Collection<BlockPosition> var4 = GameTestHarnessStructures.findStructureBlocks(var0, var12, var2);
        Optional<BlockPosition> var5 = var4.stream().min(var3);
        return var5.orElse(null);
    }

    public static Collection<BlockPosition> findStructureBlocks(BlockPosition var0, int var1, WorldServer var2) {
        ArrayList var3 = Lists.newArrayList();
        AxisAlignedBB var4 = new AxisAlignedBB(var0);
        var4 = var4.inflate(var1);
        for (int var5 = (int)var4.minX; var5 <= (int)var4.maxX; ++var5) {
            for (int var6 = (int)var4.minY; var6 <= (int)var4.maxY; ++var6) {
                for (int var7 = (int)var4.minZ; var7 <= (int)var4.maxZ; ++var7) {
                    BlockPosition var8 = new BlockPosition(var5, var6, var7);
                    IBlockData var9 = var2.getBlockState(var8);
                    if (!var9.is(Blocks.STRUCTURE_BLOCK)) continue;
                    var3.add(var8);
                }
            }
        }
        return var3;
    }

    private static DefinedStructure getStructureTemplate(String var0, WorldServer var1) {
        StructureTemplateManager var2 = var1.getStructureManager();
        Optional<DefinedStructure> var3 = var2.get(new MinecraftKey(var0));
        if (var3.isPresent()) {
            return var3.get();
        }
        String var4 = var0 + ".snbt";
        Path var5 = Paths.get(testStructuresDir, var4);
        NBTTagCompound var6 = GameTestHarnessStructures.tryLoadStructure(var5);
        if (var6 == null) {
            throw new RuntimeException("Could not find structure file " + var5 + ", and the structure is not available in the world structures either.");
        }
        return var2.readStructure(var6);
    }

    private static TileEntityStructure createStructureBlock(String var0, BlockPosition var1, EnumBlockRotation var2, WorldServer var3, boolean var4) {
        var3.setBlockAndUpdate(var1, Blocks.STRUCTURE_BLOCK.defaultBlockState());
        TileEntityStructure var5 = (TileEntityStructure)var3.getBlockEntity(var1);
        var5.setMode(BlockPropertyStructureMode.LOAD);
        var5.setRotation(var2);
        var5.setIgnoreEntities(false);
        var5.setStructureName(new MinecraftKey(var0));
        var5.loadStructure(var3, var4);
        if (var5.getStructureSize() != BaseBlockPosition.ZERO) {
            return var5;
        }
        DefinedStructure var6 = GameTestHarnessStructures.getStructureTemplate(var0, var3);
        var5.loadStructure(var3, var4, var6);
        if (var5.getStructureSize() == BaseBlockPosition.ZERO) {
            throw new RuntimeException("Failed to load structure " + var0);
        }
        return var5;
    }

    @Nullable
    private static NBTTagCompound tryLoadStructure(Path var0) {
        try {
            BufferedReader var1 = Files.newBufferedReader(var0);
            String var2 = IOUtils.toString((Reader)var1);
            return GameProfileSerializer.snbtToStructure(var2);
        }
        catch (IOException var1) {
            return null;
        }
        catch (CommandSyntaxException var1) {
            throw new RuntimeException("Error while trying to load structure " + var0, var1);
        }
    }

    private static void clearBlock(int var0, BlockPosition var1, WorldServer var2) {
        IBlockData var3 = null;
        GeneratorSettingsFlat var4 = GeneratorSettingsFlat.getDefault(var2.registryAccess().registryOrThrow(IRegistry.BIOME_REGISTRY), var2.registryAccess().registryOrThrow(IRegistry.STRUCTURE_SET_REGISTRY));
        List<IBlockData> var5 = var4.getLayers();
        int var6 = var1.getY() - var2.getMinBuildHeight();
        if (var1.getY() < var0 && var6 > 0 && var6 <= var5.size()) {
            var3 = var5.get(var6 - 1);
        }
        if (var3 == null) {
            var3 = Blocks.AIR.defaultBlockState();
        }
        ArgumentTileLocation var7 = new ArgumentTileLocation(var3, Collections.emptySet(), null);
        var7.place(var2, var1, 2);
        var2.blockUpdated(var1, var3.getBlock());
    }

    private static boolean doesStructureContain(BlockPosition var0, BlockPosition var1, WorldServer var2) {
        TileEntityStructure var3 = (TileEntityStructure)var2.getBlockEntity(var0);
        AxisAlignedBB var4 = GameTestHarnessStructures.getStructureBounds(var3).inflate(1.0);
        return var4.contains(Vec3D.atCenterOf(var1));
    }
}

