/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.gametest.framework.GameTestHarnessAssertion;
import net.minecraft.gametest.framework.GameTestHarnessAssertionPosition;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessSequence;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockButtonAbstract;
import net.minecraft.world.level.block.BlockLever;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public class GameTestHarnessHelper {
    private final GameTestHarnessInfo testInfo;
    private boolean finalCheckAdded;

    public GameTestHarnessHelper(GameTestHarnessInfo var0) {
        this.testInfo = var0;
    }

    public WorldServer getLevel() {
        return this.testInfo.getLevel();
    }

    public IBlockData getBlockState(BlockPosition var0) {
        return this.getLevel().getBlockState(this.absolutePos(var0));
    }

    @Nullable
    public TileEntity getBlockEntity(BlockPosition var0) {
        return this.getLevel().getBlockEntity(this.absolutePos(var0));
    }

    public void killAllEntities() {
        AxisAlignedBB var02 = this.getBounds();
        List<Entity> var1 = this.getLevel().getEntitiesOfClass(Entity.class, var02.inflate(1.0), var0 -> !(var0 instanceof EntityHuman));
        var1.forEach(Entity::kill);
    }

    public EntityItem spawnItem(Item var0, float var1, float var2, float var3) {
        WorldServer var4 = this.getLevel();
        Vec3D var5 = this.absoluteVec(new Vec3D(var1, var2, var3));
        EntityItem var6 = new EntityItem(var4, var5.x, var5.y, var5.z, new ItemStack(var0, 1));
        var6.setDeltaMovement(0.0, 0.0, 0.0);
        var4.addFreshEntity(var6);
        return var6;
    }

    public <E extends Entity> E spawn(EntityTypes<E> var0, BlockPosition var1) {
        return this.spawn(var0, Vec3D.atBottomCenterOf(var1));
    }

    public <E extends Entity> E spawn(EntityTypes<E> var0, Vec3D var1) {
        WorldServer var2 = this.getLevel();
        E var3 = var0.create(var2);
        if (var3 instanceof EntityInsentient) {
            ((EntityInsentient)var3).setPersistenceRequired();
        }
        Vec3D var4 = this.absoluteVec(var1);
        ((Entity)var3).moveTo(var4.x, var4.y, var4.z, ((Entity)var3).getYRot(), ((Entity)var3).getXRot());
        var2.addFreshEntity((Entity)var3);
        return var3;
    }

    public <E extends Entity> E spawn(EntityTypes<E> var0, int var1, int var2, int var3) {
        return this.spawn(var0, new BlockPosition(var1, var2, var3));
    }

    public <E extends Entity> E spawn(EntityTypes<E> var0, float var1, float var2, float var3) {
        return this.spawn(var0, new Vec3D(var1, var2, var3));
    }

    public <E extends EntityInsentient> E spawnWithNoFreeWill(EntityTypes<E> var0, BlockPosition var1) {
        EntityInsentient var2 = (EntityInsentient)this.spawn(var0, var1);
        var2.removeFreeWill();
        return (E)var2;
    }

    public <E extends EntityInsentient> E spawnWithNoFreeWill(EntityTypes<E> var0, int var1, int var2, int var3) {
        return this.spawnWithNoFreeWill(var0, new BlockPosition(var1, var2, var3));
    }

    public <E extends EntityInsentient> E spawnWithNoFreeWill(EntityTypes<E> var0, Vec3D var1) {
        EntityInsentient var2 = (EntityInsentient)this.spawn(var0, var1);
        var2.removeFreeWill();
        return (E)var2;
    }

    public <E extends EntityInsentient> E spawnWithNoFreeWill(EntityTypes<E> var0, float var1, float var2, float var3) {
        return this.spawnWithNoFreeWill(var0, new Vec3D(var1, var2, var3));
    }

    public GameTestHarnessSequence walkTo(EntityInsentient var0, BlockPosition var1, float var2) {
        return this.startSequence().thenExecuteAfter(2, () -> {
            PathEntity var3 = var0.getNavigation().createPath(this.absolutePos(var1), 0);
            var0.getNavigation().moveTo(var3, (double)var2);
        });
    }

    public void pressButton(int var0, int var1, int var2) {
        this.pressButton(new BlockPosition(var0, var1, var2));
    }

    public void pressButton(BlockPosition var02) {
        this.assertBlockState(var02, var0 -> var0.is(TagsBlock.BUTTONS), () -> "Expected button");
        BlockPosition var1 = this.absolutePos(var02);
        IBlockData var2 = this.getLevel().getBlockState(var1);
        BlockButtonAbstract var3 = (BlockButtonAbstract)var2.getBlock();
        var3.press(var2, this.getLevel(), var1);
    }

    public void useBlock(BlockPosition var0) {
        BlockPosition var1 = this.absolutePos(var0);
        IBlockData var2 = this.getLevel().getBlockState(var1);
        var2.use(this.getLevel(), this.makeMockPlayer(), EnumHand.MAIN_HAND, new MovingObjectPositionBlock(Vec3D.atCenterOf(var1), EnumDirection.NORTH, var1, true));
    }

    public EntityLiving makeAboutToDrown(EntityLiving var0) {
        var0.setAirSupply(0);
        var0.setHealth(0.25f);
        return var0;
    }

    public EntityHuman makeMockPlayer() {
        return new EntityHuman(this.getLevel(), BlockPosition.ZERO, 0.0f, new GameProfile(UUID.randomUUID(), "test-mock-player"), null){

            @Override
            public boolean isSpectator() {
                return false;
            }

            @Override
            public boolean isCreative() {
                return true;
            }
        };
    }

    public void pullLever(int var0, int var1, int var2) {
        this.pullLever(new BlockPosition(var0, var1, var2));
    }

    public void pullLever(BlockPosition var0) {
        this.assertBlockPresent(Blocks.LEVER, var0);
        BlockPosition var1 = this.absolutePos(var0);
        IBlockData var2 = this.getLevel().getBlockState(var1);
        BlockLever var3 = (BlockLever)var2.getBlock();
        var3.pull(var2, this.getLevel(), var1);
    }

    public void pulseRedstone(BlockPosition var0, long var1) {
        this.setBlock(var0, Blocks.REDSTONE_BLOCK);
        this.runAfterDelay(var1, () -> this.setBlock(var0, Blocks.AIR));
    }

    public void destroyBlock(BlockPosition var0) {
        this.getLevel().destroyBlock(this.absolutePos(var0), false, null);
    }

    public void setBlock(int var0, int var1, int var2, Block var3) {
        this.setBlock(new BlockPosition(var0, var1, var2), var3);
    }

    public void setBlock(int var0, int var1, int var2, IBlockData var3) {
        this.setBlock(new BlockPosition(var0, var1, var2), var3);
    }

    public void setBlock(BlockPosition var0, Block var1) {
        this.setBlock(var0, var1.defaultBlockState());
    }

    public void setBlock(BlockPosition var0, IBlockData var1) {
        this.getLevel().setBlock(this.absolutePos(var0), var1, 3);
    }

    public void setNight() {
        this.setDayTime(13000);
    }

    public void setDayTime(int var0) {
        this.getLevel().setDayTime(var0);
    }

    public void assertBlockPresent(Block var0, int var1, int var2, int var3) {
        this.assertBlockPresent(var0, new BlockPosition(var1, var2, var3));
    }

    public void assertBlockPresent(Block var0, BlockPosition var1) {
        IBlockData var22 = this.getBlockState(var1);
        this.assertBlock(var1, (Block var2) -> var22.is(var0), "Expected " + var0.getName().getString() + ", got " + var22.getBlock().getName().getString());
    }

    public void assertBlockNotPresent(Block var0, int var1, int var2, int var3) {
        this.assertBlockNotPresent(var0, new BlockPosition(var1, var2, var3));
    }

    public void assertBlockNotPresent(Block var0, BlockPosition var1) {
        this.assertBlock(var1, (Block var2) -> !this.getBlockState(var1).is(var0), "Did not expect " + var0.getName().getString());
    }

    public void succeedWhenBlockPresent(Block var0, int var1, int var2, int var3) {
        this.succeedWhenBlockPresent(var0, new BlockPosition(var1, var2, var3));
    }

    public void succeedWhenBlockPresent(Block var0, BlockPosition var1) {
        this.succeedWhen(() -> this.assertBlockPresent(var0, var1));
    }

    public void assertBlock(BlockPosition var0, Predicate<Block> var1, String var2) {
        this.assertBlock(var0, var1, () -> var2);
    }

    public void assertBlock(BlockPosition var0, Predicate<Block> var12, Supplier<String> var2) {
        this.assertBlockState(var0, var1 -> var12.test(var1.getBlock()), var2);
    }

    public <T extends Comparable<T>> void assertBlockProperty(BlockPosition var0, IBlockState<T> var1, T var22) {
        this.assertBlockState(var0, var2 -> var2.hasProperty(var1) && var2.getValue(var1).equals(var22), () -> "Expected property " + var1.getName() + " to be " + var22);
    }

    public <T extends Comparable<T>> void assertBlockProperty(BlockPosition var0, IBlockState<T> var1, Predicate<T> var22, String var3) {
        this.assertBlockState(var0, var2 -> var22.test(var2.getValue(var1)), () -> var3);
    }

    public void assertBlockState(BlockPosition var0, Predicate<IBlockData> var1, Supplier<String> var2) {
        IBlockData var3 = this.getBlockState(var0);
        if (!var1.test(var3)) {
            throw new GameTestHarnessAssertionPosition(var2.get(), this.absolutePos(var0), var0, this.testInfo.getTick());
        }
    }

    public void assertEntityPresent(EntityTypes<?> var0) {
        List<Entity> var1 = this.getLevel().getEntities(var0, this.getBounds(), Entity::isAlive);
        if (var1.isEmpty()) {
            throw new GameTestHarnessAssertion("Expected " + var0.toShortString() + " to exist");
        }
    }

    public void assertEntityPresent(EntityTypes<?> var0, int var1, int var2, int var3) {
        this.assertEntityPresent(var0, new BlockPosition(var1, var2, var3));
    }

    public void assertEntityPresent(EntityTypes<?> var0, BlockPosition var1) {
        BlockPosition var2 = this.absolutePos(var1);
        List<Entity> var3 = this.getLevel().getEntities(var0, new AxisAlignedBB(var2), Entity::isAlive);
        if (var3.isEmpty()) {
            throw new GameTestHarnessAssertionPosition("Expected " + var0.toShortString(), var2, var1, this.testInfo.getTick());
        }
    }

    public void assertEntityPresent(EntityTypes<?> var0, BlockPosition var1, double var2) {
        List<?> var4 = this.getEntities(var0, var1, var2);
        if (var4.isEmpty()) {
            BlockPosition var5 = this.absolutePos(var1);
            throw new GameTestHarnessAssertionPosition("Expected " + var0.toShortString(), var5, var1, this.testInfo.getTick());
        }
    }

    public <T extends Entity> List<T> getEntities(EntityTypes<T> var0, BlockPosition var1, double var2) {
        BlockPosition var4 = this.absolutePos(var1);
        return this.getLevel().getEntities(var0, new AxisAlignedBB(var4).inflate(var2), Entity::isAlive);
    }

    public void assertEntityInstancePresent(Entity var0, int var1, int var2, int var3) {
        this.assertEntityInstancePresent(var0, new BlockPosition(var1, var2, var3));
    }

    public void assertEntityInstancePresent(Entity var0, BlockPosition var12) {
        BlockPosition var2 = this.absolutePos(var12);
        List<Entity> var3 = this.getLevel().getEntities(var0.getType(), new AxisAlignedBB(var2), Entity::isAlive);
        var3.stream().filter(var1 -> var1 == var0).findFirst().orElseThrow(() -> new GameTestHarnessAssertionPosition("Expected " + var0.getType().toShortString(), var2, var12, this.testInfo.getTick()));
    }

    public void assertItemEntityCountIs(Item var0, BlockPosition var1, double var2, int var4) {
        BlockPosition var5 = this.absolutePos(var1);
        List<EntityItem> var6 = this.getLevel().getEntities(EntityTypes.ITEM, new AxisAlignedBB(var5).inflate(var2), Entity::isAlive);
        int var7 = 0;
        for (Entity entity : var6) {
            EntityItem var10 = (EntityItem)entity;
            if (!var10.getItem().getItem().equals(var0)) continue;
            var7 += var10.getItem().getCount();
        }
        if (var7 != var4) {
            throw new GameTestHarnessAssertionPosition("Expected " + var4 + " " + var0.getDescription().getString() + " items to exist (found " + var7 + ")", var5, var1, this.testInfo.getTick());
        }
    }

    public void assertItemEntityPresent(Item var0, BlockPosition var1, double var2) {
        BlockPosition var4 = this.absolutePos(var1);
        List<EntityItem> var5 = this.getLevel().getEntities(EntityTypes.ITEM, new AxisAlignedBB(var4).inflate(var2), Entity::isAlive);
        for (Entity entity : var5) {
            EntityItem var8 = (EntityItem)entity;
            if (!var8.getItem().getItem().equals(var0)) continue;
            return;
        }
        throw new GameTestHarnessAssertionPosition("Expected " + var0.getDescription().getString() + " item", var4, var1, this.testInfo.getTick());
    }

    public void assertItemEntityNotPresent(Item var0, BlockPosition var1, double var2) {
        BlockPosition var4 = this.absolutePos(var1);
        List<EntityItem> var5 = this.getLevel().getEntities(EntityTypes.ITEM, new AxisAlignedBB(var4).inflate(var2), Entity::isAlive);
        for (Entity entity : var5) {
            EntityItem var8 = (EntityItem)entity;
            if (!var8.getItem().getItem().equals(var0)) continue;
            throw new GameTestHarnessAssertionPosition("Did not expect " + var0.getDescription().getString() + " item", var4, var1, this.testInfo.getTick());
        }
    }

    public void assertEntityNotPresent(EntityTypes<?> var0) {
        List<Entity> var1 = this.getLevel().getEntities(var0, this.getBounds(), Entity::isAlive);
        if (!var1.isEmpty()) {
            throw new GameTestHarnessAssertion("Did not expect " + var0.toShortString() + " to exist");
        }
    }

    public void assertEntityNotPresent(EntityTypes<?> var0, int var1, int var2, int var3) {
        this.assertEntityNotPresent(var0, new BlockPosition(var1, var2, var3));
    }

    public void assertEntityNotPresent(EntityTypes<?> var0, BlockPosition var1) {
        BlockPosition var2 = this.absolutePos(var1);
        List<Entity> var3 = this.getLevel().getEntities(var0, new AxisAlignedBB(var2), Entity::isAlive);
        if (!var3.isEmpty()) {
            throw new GameTestHarnessAssertionPosition("Did not expect " + var0.toShortString(), var2, var1, this.testInfo.getTick());
        }
    }

    public void assertEntityTouching(EntityTypes<?> var0, double var12, double var3, double var5) {
        Vec3D var7 = new Vec3D(var12, var3, var5);
        Vec3D var8 = this.absoluteVec(var7);
        Predicate<Entity> var9 = var1 -> var1.getBoundingBox().intersects(var8, var8);
        List<Entity> var10 = this.getLevel().getEntities(var0, this.getBounds(), var9);
        if (var10.isEmpty()) {
            throw new GameTestHarnessAssertion("Expected " + var0.toShortString() + " to touch " + var8 + " (relative " + var7 + ")");
        }
    }

    public void assertEntityNotTouching(EntityTypes<?> var0, double var12, double var3, double var5) {
        Vec3D var7 = new Vec3D(var12, var3, var5);
        Vec3D var8 = this.absoluteVec(var7);
        Predicate<Entity> var9 = var1 -> !var1.getBoundingBox().intersects(var8, var8);
        List<Entity> var10 = this.getLevel().getEntities(var0, this.getBounds(), var9);
        if (var10.isEmpty()) {
            throw new GameTestHarnessAssertion("Did not expect " + var0.toShortString() + " to touch " + var8 + " (relative " + var7 + ")");
        }
    }

    public <E extends Entity, T> void assertEntityData(BlockPosition var0, EntityTypes<E> var1, Function<? super E, T> var2, @Nullable T var3) {
        BlockPosition var4 = this.absolutePos(var0);
        List<Entity> var5 = this.getLevel().getEntities(var1, new AxisAlignedBB(var4), Entity::isAlive);
        if (var5.isEmpty()) {
            throw new GameTestHarnessAssertionPosition("Expected " + var1.toShortString(), var4, var0, this.testInfo.getTick());
        }
        for (Entity var7 : var5) {
            T var8 = var2.apply(var7);
            if (!(var8 == null ? var3 != null : !var8.equals(var3))) continue;
            throw new GameTestHarnessAssertion("Expected entity data to be: " + var3 + ", but was: " + var8);
        }
    }

    public void assertContainerEmpty(BlockPosition var0) {
        BlockPosition var1 = this.absolutePos(var0);
        TileEntity var2 = this.getLevel().getBlockEntity(var1);
        if (var2 instanceof TileEntityContainer && !((TileEntityContainer)var2).isEmpty()) {
            throw new GameTestHarnessAssertion("Container should be empty");
        }
    }

    public void assertContainerContains(BlockPosition var0, Item var1) {
        BlockPosition var2 = this.absolutePos(var0);
        TileEntity var3 = this.getLevel().getBlockEntity(var2);
        if (!(var3 instanceof TileEntityContainer)) {
            throw new GameTestHarnessAssertion("Expected a container at " + var0 + ", found " + IRegistry.BLOCK_ENTITY_TYPE.getKey(var3.getType()));
        }
        if (((TileEntityContainer)var3).countItem(var1) != 1) {
            throw new GameTestHarnessAssertion("Container should contain: " + var1);
        }
    }

    public void assertSameBlockStates(StructureBoundingBox var0, BlockPosition var1) {
        BlockPosition.betweenClosedStream(var0).forEach(var2 -> {
            BlockPosition var3 = var1.offset(var2.getX() - var0.minX(), var2.getY() - var0.minY(), var2.getZ() - var0.minZ());
            this.assertSameBlockState((BlockPosition)var2, var3);
        });
    }

    public void assertSameBlockState(BlockPosition var0, BlockPosition var1) {
        IBlockData var3;
        IBlockData var2 = this.getBlockState(var0);
        if (var2 != (var3 = this.getBlockState(var1))) {
            this.fail("Incorrect state. Expected " + var3 + ", got " + var2, var0);
        }
    }

    public void assertAtTickTimeContainerContains(long var0, BlockPosition var2, Item var3) {
        this.runAtTickTime(var0, () -> this.assertContainerContains(var2, var3));
    }

    public void assertAtTickTimeContainerEmpty(long var0, BlockPosition var2) {
        this.runAtTickTime(var0, () -> this.assertContainerEmpty(var2));
    }

    public <E extends Entity, T> void succeedWhenEntityData(BlockPosition var0, EntityTypes<E> var1, Function<E, T> var2, T var3) {
        this.succeedWhen(() -> this.assertEntityData(var0, var1, var2, var3));
    }

    public <E extends Entity> void assertEntityProperty(E var0, Predicate<E> var1, String var2) {
        if (!var1.test(var0)) {
            throw new GameTestHarnessAssertion("Entity " + var0 + " failed " + var2 + " test");
        }
    }

    public <E extends Entity, T> void assertEntityProperty(E var0, Function<E, T> var1, String var2, T var3) {
        T var4 = var1.apply(var0);
        if (!var4.equals(var3)) {
            throw new GameTestHarnessAssertion("Entity " + var0 + " value " + var2 + "=" + var4 + " is not equal to expected " + var3);
        }
    }

    public void succeedWhenEntityPresent(EntityTypes<?> var0, int var1, int var2, int var3) {
        this.succeedWhenEntityPresent(var0, new BlockPosition(var1, var2, var3));
    }

    public void succeedWhenEntityPresent(EntityTypes<?> var0, BlockPosition var1) {
        this.succeedWhen(() -> this.assertEntityPresent(var0, var1));
    }

    public void succeedWhenEntityNotPresent(EntityTypes<?> var0, int var1, int var2, int var3) {
        this.succeedWhenEntityNotPresent(var0, new BlockPosition(var1, var2, var3));
    }

    public void succeedWhenEntityNotPresent(EntityTypes<?> var0, BlockPosition var1) {
        this.succeedWhen(() -> this.assertEntityNotPresent(var0, var1));
    }

    public void succeed() {
        this.testInfo.succeed();
    }

    private void ensureSingleFinalCheck() {
        if (this.finalCheckAdded) {
            throw new IllegalStateException("This test already has final clause");
        }
        this.finalCheckAdded = true;
    }

    public void succeedIf(Runnable var0) {
        this.ensureSingleFinalCheck();
        this.testInfo.createSequence().thenWaitUntil(0L, var0).thenSucceed();
    }

    public void succeedWhen(Runnable var0) {
        this.ensureSingleFinalCheck();
        this.testInfo.createSequence().thenWaitUntil(var0).thenSucceed();
    }

    public void succeedOnTickWhen(int var0, Runnable var1) {
        this.ensureSingleFinalCheck();
        this.testInfo.createSequence().thenWaitUntil(var0, var1).thenSucceed();
    }

    public void runAtTickTime(long var0, Runnable var2) {
        this.testInfo.setRunAtTickTime(var0, var2);
    }

    public void runAfterDelay(long var0, Runnable var2) {
        this.runAtTickTime(this.testInfo.getTick() + var0, var2);
    }

    public void randomTick(BlockPosition var0) {
        BlockPosition var1 = this.absolutePos(var0);
        WorldServer var2 = this.getLevel();
        var2.getBlockState(var1).randomTick(var2, var1, var2.random);
    }

    public int getHeight(HeightMap.Type var0, int var1, int var2) {
        BlockPosition var3 = this.absolutePos(new BlockPosition(var1, 0, var2));
        return this.relativePos(this.getLevel().getHeightmapPos(var0, var3)).getY();
    }

    public void fail(String var0, BlockPosition var1) {
        throw new GameTestHarnessAssertionPosition(var0, this.absolutePos(var1), var1, this.getTick());
    }

    public void fail(String var0, Entity var1) {
        throw new GameTestHarnessAssertionPosition(var0, var1.blockPosition(), this.relativePos(var1.blockPosition()), this.getTick());
    }

    public void fail(String var0) {
        throw new GameTestHarnessAssertion(var0);
    }

    public void failIf(Runnable var0) {
        this.testInfo.createSequence().thenWaitUntil(var0).thenFail(() -> new GameTestHarnessAssertion("Fail conditions met"));
    }

    public void failIfEver(Runnable var0) {
        LongStream.range(this.testInfo.getTick(), this.testInfo.getTimeoutTicks()).forEach(var1 -> this.testInfo.setRunAtTickTime(var1, var0::run));
    }

    public GameTestHarnessSequence startSequence() {
        return this.testInfo.createSequence();
    }

    public BlockPosition absolutePos(BlockPosition var0) {
        BlockPosition var1 = this.testInfo.getStructureBlockPos();
        BlockPosition var2 = var1.offset(var0);
        return DefinedStructure.transform(var2, EnumBlockMirror.NONE, this.testInfo.getRotation(), var1);
    }

    public BlockPosition relativePos(BlockPosition var0) {
        BlockPosition var1 = this.testInfo.getStructureBlockPos();
        EnumBlockRotation var2 = this.testInfo.getRotation().getRotated(EnumBlockRotation.CLOCKWISE_180);
        BlockPosition var3 = DefinedStructure.transform(var0, EnumBlockMirror.NONE, var2, var1);
        return var3.subtract(var1);
    }

    public Vec3D absoluteVec(Vec3D var0) {
        Vec3D var1 = Vec3D.atLowerCornerOf(this.testInfo.getStructureBlockPos());
        return DefinedStructure.transform(var1.add(var0), EnumBlockMirror.NONE, this.testInfo.getRotation(), this.testInfo.getStructureBlockPos());
    }

    public long getTick() {
        return this.testInfo.getTick();
    }

    private AxisAlignedBB getBounds() {
        return this.testInfo.getStructureBounds();
    }

    private AxisAlignedBB getRelativeBounds() {
        AxisAlignedBB var0 = this.testInfo.getStructureBounds();
        return var0.move(BlockPosition.ZERO.subtract(this.absolutePos(BlockPosition.ZERO)));
    }

    public void forEveryBlockInStructure(Consumer<BlockPosition> var0) {
        AxisAlignedBB var1 = this.getRelativeBounds();
        BlockPosition.MutableBlockPosition.betweenClosedStream(var1.move(0.0, 1.0, 0.0)).forEach(var0);
    }

    public void onEachTick(Runnable var0) {
        LongStream.range(this.testInfo.getTick(), this.testInfo.getTimeoutTicks()).forEach(var1 -> this.testInfo.setRunAtTickTime(var1, var0::run));
    }
}

