/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.WorldVersion;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.DispenserRegistry;
import org.slf4j.Logger;

public class DebugReportGenerator {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Collection<Path> inputFolders;
    private final Path outputFolder;
    private final List<DebugReportProvider> allProviders = Lists.newArrayList();
    private final List<DebugReportProvider> providersToRun = Lists.newArrayList();
    private final WorldVersion version;
    private final boolean alwaysGenerate;

    public DebugReportGenerator(Path var0, Collection<Path> var1, WorldVersion var2, boolean var3) {
        this.outputFolder = var0;
        this.inputFolders = var1;
        this.version = var2;
        this.alwaysGenerate = var3;
    }

    public Collection<Path> getInputFolders() {
        return this.inputFolders;
    }

    public Path getOutputFolder() {
        return this.outputFolder;
    }

    public Path getOutputFolder(b var0) {
        return this.getOutputFolder().resolve(var0.directory);
    }

    public void run() throws IOException {
        HashCache var0 = new HashCache(this.outputFolder, this.allProviders, this.version);
        Stopwatch var1 = Stopwatch.createStarted();
        Stopwatch var2 = Stopwatch.createUnstarted();
        for (DebugReportProvider var4 : this.providersToRun) {
            if (!this.alwaysGenerate && !var0.shouldRunInThisVersion(var4)) {
                LOGGER.debug("Generator {} already run for version {}", (Object)var4.getName(), (Object)this.version.getName());
                continue;
            }
            LOGGER.info("Starting provider: {}", (Object)var4.getName());
            var2.start();
            var4.run(var0.getUpdater(var4));
            var2.stop();
            LOGGER.info("{} finished after {} ms", (Object)var4.getName(), (Object)var2.elapsed(TimeUnit.MILLISECONDS));
            var2.reset();
        }
        LOGGER.info("All providers took: {} ms", (Object)var1.elapsed(TimeUnit.MILLISECONDS));
        var0.purgeStaleAndWrite();
    }

    public void addProvider(boolean var0, DebugReportProvider var1) {
        if (var0) {
            this.providersToRun.add(var1);
        }
        this.allProviders.add(var1);
    }

    public a createPathProvider(b var0, String var1) {
        return new a(this, var0, var1);
    }

    static {
        DispenserRegistry.bootStrap();
    }

    public static final class b
    extends Enum<b> {
        public static final /* enum */ b DATA_PACK = new b("data");
        public static final /* enum */ b RESOURCE_PACK = new b("assets");
        public static final /* enum */ b REPORTS = new b("reports");
        final String directory;
        private static final /* synthetic */ b[] e;

        public static b[] values() {
            return (b[])e.clone();
        }

        public static b valueOf(String var0) {
            return Enum.valueOf(b.class, var0);
        }

        private b(String var2) {
            this.directory = var2;
        }

        private static /* synthetic */ b[] a() {
            return new b[]{DATA_PACK, RESOURCE_PACK, REPORTS};
        }

        static {
            e = b.a();
        }
    }

    public static class a {
        private final Path root;
        private final String kind;

        a(DebugReportGenerator var0, b var1, String var2) {
            this.root = var0.getOutputFolder(var1);
            this.kind = var2;
        }

        public Path file(MinecraftKey var0, String var1) {
            return this.root.resolve(var0.getNamespace()).resolve(this.kind).resolve(var0.getPath() + "." + var1);
        }

        public Path json(MinecraftKey var0) {
            return this.root.resolve(var0.getNamespace()).resolve(this.kind).resolve(var0.getPath() + ".json");
        }
    }
}

