/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.math.Vector3fa;
import java.util.Locale;
import net.minecraft.core.IRegistry;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.util.MathHelper;

public abstract class DustParticleOptionsBase
implements ParticleParam {
    public static final float MIN_SCALE = 0.01f;
    public static final float MAX_SCALE = 4.0f;
    protected final Vector3fa color;
    protected final float scale;

    public DustParticleOptionsBase(Vector3fa var0, float var1) {
        this.color = var0;
        this.scale = MathHelper.clamp(var1, 0.01f, 4.0f);
    }

    public static Vector3fa readVector3f(StringReader var0) throws CommandSyntaxException {
        var0.expect(' ');
        float var1 = var0.readFloat();
        var0.expect(' ');
        float var2 = var0.readFloat();
        var0.expect(' ');
        float var3 = var0.readFloat();
        return new Vector3fa(var1, var2, var3);
    }

    public static Vector3fa readVector3f(PacketDataSerializer var0) {
        return new Vector3fa(var0.readFloat(), var0.readFloat(), var0.readFloat());
    }

    @Override
    public void writeToNetwork(PacketDataSerializer var0) {
        var0.writeFloat(this.color.x());
        var0.writeFloat(this.color.y());
        var0.writeFloat(this.color.z());
        var0.writeFloat(this.scale);
    }

    @Override
    public String writeToString() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f", IRegistry.PARTICLE_TYPE.getKey(this.getType()), Float.valueOf(this.color.x()), Float.valueOf(this.color.y()), Float.valueOf(this.color.z()), Float.valueOf(this.scale));
    }

    public Vector3fa getColor() {
        return this.color;
    }

    public float getScale() {
        return this.scale;
    }
}

