/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.ISourceBlock;
import net.minecraft.core.dispenser.DispenseBehaviorMaybe;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContextDirectional;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDispenser;
import org.slf4j.Logger;

public class DispenseBehaviorShulkerBox
extends DispenseBehaviorMaybe {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    protected ItemStack execute(ISourceBlock var0, ItemStack var1) {
        this.setSuccess(false);
        Item var2 = var1.getItem();
        if (var2 instanceof ItemBlock) {
            EnumDirection var3 = var0.getBlockState().getValue(BlockDispenser.FACING);
            BlockPosition var4 = var0.getPos().relative(var3);
            EnumDirection var5 = var0.getLevel().isEmptyBlock(var4.below()) ? var3 : EnumDirection.UP;
            try {
                this.setSuccess(((ItemBlock)var2).place(new BlockActionContextDirectional((World)var0.getLevel(), var4, var3, var1, var5)).consumesAction());
            }
            catch (Exception var6) {
                LOGGER.error("Error trying to place shulker box at {}", (Object)var4, (Object)var6);
            }
        }
        return var1;
    }
}

