/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class RegistryMaterials<T>
extends IRegistryWritable<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ObjectList<Holder.c<T>> byId = new ObjectArrayList(256);
    private final Object2IntMap<T> toId = (Object2IntMap)SystemUtils.make(new Object2IntOpenCustomHashMap(SystemUtils.identityStrategy()), var0 -> var0.defaultReturnValue(-1));
    private final Map<MinecraftKey, Holder.c<T>> byLocation = new HashMap<MinecraftKey, Holder.c<T>>();
    private final Map<ResourceKey<T>, Holder.c<T>> byKey = new HashMap<ResourceKey<T>, Holder.c<T>>();
    private final Map<T, Holder.c<T>> byValue = new IdentityHashMap<T, Holder.c<T>>();
    private final Map<T, Lifecycle> lifecycles = new IdentityHashMap<T, Lifecycle>();
    private Lifecycle elementsLifecycle;
    private volatile Map<TagKey<T>, HolderSet.Named<T>> tags = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>();
    private boolean frozen;
    @Nullable
    private final Function<T, Holder.c<T>> customHolderProvider;
    @Nullable
    private Map<T, Holder.c<T>> intrusiveHolderCache;
    @Nullable
    private List<Holder.c<T>> holdersInOrder;
    private int nextId;

    public RegistryMaterials(ResourceKey<? extends IRegistry<T>> var02, Lifecycle var1, @Nullable Function<T, Holder.c<T>> var2) {
        super(var02, var1);
        this.elementsLifecycle = var1;
        this.customHolderProvider = var2;
        if (var2 != null) {
            this.intrusiveHolderCache = new IdentityHashMap<T, Holder.c<T>>();
        }
    }

    private List<Holder.c<T>> holdersInOrder() {
        if (this.holdersInOrder == null) {
            this.holdersInOrder = this.byId.stream().filter(Objects::nonNull).toList();
        }
        return this.holdersInOrder;
    }

    private void validateWrite(ResourceKey<T> var0) {
        if (this.frozen) {
            throw new IllegalStateException("Registry is already frozen (trying to add key " + var0 + ")");
        }
    }

    @Override
    public Holder<T> registerMapping(int var0, ResourceKey<T> var1, T var2, Lifecycle var3) {
        return this.registerMapping(var0, var1, var2, var3, true);
    }

    private Holder<T> registerMapping(int var02, ResourceKey<T> var1, T var2, Lifecycle var3, boolean var4) {
        Holder.c var5;
        this.validateWrite(var1);
        Validate.notNull(var1);
        Validate.notNull(var2);
        this.byId.size(Math.max(this.byId.size(), var02 + 1));
        this.toId.put(var2, var02);
        this.holdersInOrder = null;
        if (var4 && this.byKey.containsKey(var1)) {
            SystemUtils.logAndPauseIfInIde("Adding duplicate key '" + var1 + "' to registry");
        }
        if (this.byValue.containsKey(var2)) {
            SystemUtils.logAndPauseIfInIde("Adding duplicate value '" + var2 + "' to registry");
        }
        this.lifecycles.put(var2, var3);
        this.elementsLifecycle = this.elementsLifecycle.add(var3);
        if (this.nextId <= var02) {
            this.nextId = var02 + 1;
        }
        if (this.customHolderProvider != null) {
            var5 = this.customHolderProvider.apply(var2);
            Holder.c var6 = this.byKey.put(var1, var5);
            if (var6 != null && var6 != var5) {
                throw new IllegalStateException("Invalid holder present for key " + var1);
            }
        } else {
            var5 = this.byKey.computeIfAbsent(var1, var0 -> Holder.c.createStandAlone(this, var0));
        }
        this.byLocation.put(var1.location(), var5);
        this.byValue.put(var2, var5);
        var5.bind(var1, var2);
        this.byId.set(var02, (Object)var5);
        return var5;
    }

    @Override
    public Holder<T> register(ResourceKey<T> var0, T var1, Lifecycle var2) {
        return this.registerMapping(this.nextId, var0, var1, var2);
    }

    @Override
    public Holder<T> registerOrOverride(OptionalInt var0, ResourceKey<T> var1, T var2, Lifecycle var3) {
        int var6;
        Object var5;
        this.validateWrite(var1);
        Validate.notNull(var1);
        Validate.notNull(var2);
        Holder var4 = this.byKey.get(var1);
        Object v0 = var5 = var4 != null && var4.isBound() ? var4.value() : null;
        if (var5 == null) {
            var6 = var0.orElse(this.nextId);
        } else {
            var6 = this.toId.getInt(var5);
            if (var0.isPresent() && var0.getAsInt() != var6) {
                throw new IllegalStateException("ID mismatch");
            }
            this.lifecycles.remove(var5);
            this.toId.removeInt(var5);
            this.byValue.remove(var5);
        }
        return this.registerMapping(var6, var1, var2, var3, false);
    }

    @Override
    @Nullable
    public MinecraftKey getKey(T var0) {
        Holder.c<T> var1 = this.byValue.get(var0);
        return var1 != null ? var1.key().location() : null;
    }

    @Override
    public Optional<ResourceKey<T>> getResourceKey(T var0) {
        return Optional.ofNullable(this.byValue.get(var0)).map(Holder.c::key);
    }

    @Override
    public int getId(@Nullable T var0) {
        return this.toId.getInt(var0);
    }

    @Override
    @Nullable
    public T get(@Nullable ResourceKey<T> var0) {
        return RegistryMaterials.getValueFromNullable(this.byKey.get(var0));
    }

    @Override
    @Nullable
    public T byId(int var0) {
        if (var0 < 0 || var0 >= this.byId.size()) {
            return null;
        }
        return RegistryMaterials.getValueFromNullable((Holder.c)this.byId.get(var0));
    }

    @Override
    public Optional<Holder<T>> getHolder(int var0) {
        if (var0 < 0 || var0 >= this.byId.size()) {
            return Optional.empty();
        }
        return Optional.ofNullable((Holder)this.byId.get(var0));
    }

    @Override
    public Optional<Holder<T>> getHolder(ResourceKey<T> var0) {
        return Optional.ofNullable((Holder)this.byKey.get(var0));
    }

    @Override
    public Holder<T> getOrCreateHolderOrThrow(ResourceKey<T> var02) {
        return this.byKey.computeIfAbsent(var02, var0 -> {
            if (this.customHolderProvider != null) {
                throw new IllegalStateException("This registry can't create new holders without value");
            }
            this.validateWrite((ResourceKey<T>)var0);
            return Holder.c.createStandAlone(this, var0);
        });
    }

    @Override
    public DataResult<Holder<T>> getOrCreateHolder(ResourceKey<T> var0) {
        Holder.c<T> var1 = this.byKey.get(var0);
        if (var1 == null) {
            if (this.customHolderProvider != null) {
                return DataResult.error((String)("This registry can't create new holders without value (requested key: " + var0 + ")"));
            }
            if (this.frozen) {
                return DataResult.error((String)("Registry is already frozen (requested key: " + var0 + ")"));
            }
            var1 = Holder.c.createStandAlone(this, var0);
            this.byKey.put(var0, var1);
        }
        return DataResult.success(var1);
    }

    @Override
    public int size() {
        return this.byKey.size();
    }

    @Override
    public Lifecycle lifecycle(T var0) {
        return this.lifecycles.get(var0);
    }

    @Override
    public Lifecycle elementsLifecycle() {
        return this.elementsLifecycle;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.transform(this.holdersInOrder().iterator(), Holder::value);
    }

    @Override
    @Nullable
    public T get(@Nullable MinecraftKey var0) {
        Holder.c<T> var1 = this.byLocation.get(var0);
        return RegistryMaterials.getValueFromNullable(var1);
    }

    @Nullable
    private static <T> T getValueFromNullable(@Nullable Holder.c<T> var0) {
        return var0 != null ? (T)var0.value() : null;
    }

    @Override
    public Set<MinecraftKey> keySet() {
        return Collections.unmodifiableSet(this.byLocation.keySet());
    }

    @Override
    public Set<ResourceKey<T>> registryKeySet() {
        return Collections.unmodifiableSet(this.byKey.keySet());
    }

    @Override
    public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
        return Collections.unmodifiableSet(Maps.transformValues(this.byKey, Holder::value).entrySet());
    }

    @Override
    public Stream<Holder.c<T>> holders() {
        return this.holdersInOrder().stream();
    }

    @Override
    public boolean isKnownTagName(TagKey<T> var0) {
        return this.tags.containsKey(var0);
    }

    @Override
    public Stream<Pair<TagKey<T>, HolderSet.Named<T>>> getTags() {
        return this.tags.entrySet().stream().map(var0 -> Pair.of((Object)((TagKey)var0.getKey()), (Object)((HolderSet.Named)var0.getValue())));
    }

    @Override
    public HolderSet.Named<T> getOrCreateTag(TagKey<T> var0) {
        HolderSet.Named<T> var1 = this.tags.get(var0);
        if (var1 == null) {
            var1 = this.createTag(var0);
            IdentityHashMap<TagKey<T>, HolderSet.Named<T>> var2 = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.tags);
            var2.put(var0, var1);
            this.tags = var2;
        }
        return var1;
    }

    private HolderSet.Named<T> createTag(TagKey<T> var0) {
        return new HolderSet.Named<T>(this, var0);
    }

    @Override
    public Stream<TagKey<T>> getTagNames() {
        return this.tags.keySet().stream();
    }

    @Override
    public boolean isEmpty() {
        return this.byKey.isEmpty();
    }

    @Override
    public Optional<Holder<T>> getRandom(RandomSource var0) {
        return SystemUtils.getRandomSafe(this.holdersInOrder(), var0).map(Holder::hackyErase);
    }

    @Override
    public boolean containsKey(MinecraftKey var0) {
        return this.byLocation.containsKey(var0);
    }

    @Override
    public boolean containsKey(ResourceKey<T> var0) {
        return this.byKey.containsKey(var0);
    }

    @Override
    public IRegistry<T> freeze() {
        this.frozen = true;
        List<MinecraftKey> var02 = this.byKey.entrySet().stream().filter(var0 -> !((Holder.c)var0.getValue()).isBound()).map(var0 -> ((ResourceKey)var0.getKey()).location()).sorted().toList();
        if (!var02.isEmpty()) {
            throw new IllegalStateException("Unbound values in registry " + this.key() + ": " + var02);
        }
        if (this.intrusiveHolderCache != null) {
            List<Holder.c> var1 = this.intrusiveHolderCache.values().stream().filter(var0 -> !var0.isBound()).toList();
            if (!var1.isEmpty()) {
                throw new IllegalStateException("Some intrusive holders were not added to registry: " + var1);
            }
            this.intrusiveHolderCache = null;
        }
        return this;
    }

    @Override
    public Holder.c<T> createIntrusiveHolder(T var02) {
        if (this.customHolderProvider == null) {
            throw new IllegalStateException("This registry can't create intrusive holders");
        }
        if (this.frozen || this.intrusiveHolderCache == null) {
            throw new IllegalStateException("Registry is already frozen");
        }
        return this.intrusiveHolderCache.computeIfAbsent(var02, var0 -> Holder.c.createIntrusive(this, var0));
    }

    @Override
    public Optional<HolderSet.Named<T>> getTag(TagKey<T> var0) {
        return Optional.ofNullable(this.tags.get(var0));
    }

    @Override
    public void bindTags(Map<TagKey<T>, List<Holder<T>>> var02) {
        IdentityHashMap<Holder.c, List> var12 = new IdentityHashMap<Holder.c, List>();
        this.byKey.values().forEach(var1 -> var12.put((Holder.c)var1, new ArrayList()));
        var02.forEach((? super K var1, ? super V var2) -> {
            for (Holder var4 : var2) {
                if (!var4.isValidInRegistry(this)) {
                    throw new IllegalStateException("Can't create named set " + var1 + " containing value " + var4 + " from outside registry " + this);
                }
                if (var4 instanceof Holder.c) {
                    Holder.c var5 = (Holder.c)var4;
                    ((List)var12.get(var5)).add(var1);
                    continue;
                }
                throw new IllegalStateException("Found direct holder " + var4 + " value in tag " + var1);
            }
        });
        Sets.SetView var22 = Sets.difference(this.tags.keySet(), var02.keySet());
        if (!var22.isEmpty()) {
            LOGGER.warn("Not all defined tags for registry {} are present in data pack: {}", this.key(), (Object)var22.stream().map(var0 -> var0.location().toString()).sorted().collect(Collectors.joining(", ")));
        }
        IdentityHashMap<TagKey<T>, HolderSet.Named<T>> var3 = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.tags);
        var02.forEach((? super K var1, ? super V var2) -> var3.computeIfAbsent((TagKey<T>)var1, this::createTag).bind(var2));
        var12.forEach(Holder.c::bindTags);
        this.tags = var3;
    }

    @Override
    public void resetTags() {
        this.tags.values().forEach(var0 -> var0.bind(List.of()));
        this.byKey.values().forEach(var0 -> var0.bindTags(Set.of()));
    }
}

