/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.datafixers.util.Either;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;

public interface Holder<T> {
    public T value();

    public boolean isBound();

    public boolean is(MinecraftKey var1);

    public boolean is(ResourceKey<T> var1);

    public boolean is(Predicate<ResourceKey<T>> var1);

    public boolean is(TagKey<T> var1);

    public Stream<TagKey<T>> tags();

    public Either<ResourceKey<T>, T> unwrap();

    public Optional<ResourceKey<T>> unwrapKey();

    public b kind();

    public boolean isValidInRegistry(IRegistry<T> var1);

    public static <T> Holder<T> direct(T var0) {
        return new a<T>(var0);
    }

    public static <T> Holder<T> hackyErase(Holder<? extends T> var0) {
        return var0;
    }

    public record a<T>(T value) implements Holder<T>
    {
        @Override
        public boolean isBound() {
            return true;
        }

        @Override
        public boolean is(MinecraftKey var0) {
            return false;
        }

        @Override
        public boolean is(ResourceKey<T> var0) {
            return false;
        }

        @Override
        public boolean is(TagKey<T> var0) {
            return false;
        }

        @Override
        public boolean is(Predicate<ResourceKey<T>> var0) {
            return false;
        }

        @Override
        public Either<ResourceKey<T>, T> unwrap() {
            return Either.right(this.value);
        }

        @Override
        public Optional<ResourceKey<T>> unwrapKey() {
            return Optional.empty();
        }

        @Override
        public b kind() {
            return b.DIRECT;
        }

        @Override
        public String toString() {
            return "Direct{" + this.value + "}";
        }

        @Override
        public boolean isValidInRegistry(IRegistry<T> var0) {
            return true;
        }

        @Override
        public Stream<TagKey<T>> tags() {
            return Stream.of(new TagKey[0]);
        }
    }

    public static class c<T>
    implements Holder<T> {
        private final IRegistry<T> registry;
        private Set<TagKey<T>> tags = Set.of();
        private final a type;
        @Nullable
        private ResourceKey<T> key;
        @Nullable
        private T value;

        private c(a var0, IRegistry<T> var1, @Nullable ResourceKey<T> var2, @Nullable T var3) {
            this.registry = var1;
            this.type = var0;
            this.key = var2;
            this.value = var3;
        }

        public static <T> c<T> createStandAlone(IRegistry<T> var0, ResourceKey<T> var1) {
            return new c<Object>(a.STAND_ALONE, var0, var1, null);
        }

        @Deprecated
        public static <T> c<T> createIntrusive(IRegistry<T> var0, @Nullable T var1) {
            return new c<T>(a.INTRUSIVE, var0, null, var1);
        }

        public ResourceKey<T> key() {
            if (this.key == null) {
                throw new IllegalStateException("Trying to access unbound value '" + this.value + "' from registry " + this.registry);
            }
            return this.key;
        }

        @Override
        public T value() {
            if (this.value == null) {
                throw new IllegalStateException("Trying to access unbound value '" + this.key + "' from registry " + this.registry);
            }
            return this.value;
        }

        @Override
        public boolean is(MinecraftKey var0) {
            return this.key().location().equals(var0);
        }

        @Override
        public boolean is(ResourceKey<T> var0) {
            return this.key() == var0;
        }

        @Override
        public boolean is(TagKey<T> var0) {
            return this.tags.contains(var0);
        }

        @Override
        public boolean is(Predicate<ResourceKey<T>> var0) {
            return var0.test(this.key());
        }

        @Override
        public boolean isValidInRegistry(IRegistry<T> var0) {
            return this.registry == var0;
        }

        @Override
        public Either<ResourceKey<T>, T> unwrap() {
            return Either.left(this.key());
        }

        @Override
        public Optional<ResourceKey<T>> unwrapKey() {
            return Optional.of(this.key());
        }

        @Override
        public b kind() {
            return b.REFERENCE;
        }

        @Override
        public boolean isBound() {
            return this.key != null && this.value != null;
        }

        void bind(ResourceKey<T> var0, T var1) {
            if (this.key != null && var0 != this.key) {
                throw new IllegalStateException("Can't change holder key: existing=" + this.key + ", new=" + var0);
            }
            if (this.type == a.INTRUSIVE && this.value != var1) {
                throw new IllegalStateException("Can't change holder " + var0 + " value: existing=" + this.value + ", new=" + var1);
            }
            this.key = var0;
            this.value = var1;
        }

        void bindTags(Collection<TagKey<T>> var0) {
            this.tags = Set.copyOf(var0);
        }

        @Override
        public Stream<TagKey<T>> tags() {
            return this.tags.stream();
        }

        public String toString() {
            return "Reference{" + this.key + "=" + this.value + "}";
        }

        static final class a
        extends Enum<a> {
            public static final /* enum */ a STAND_ALONE = new a();
            public static final /* enum */ a INTRUSIVE = new a();
            private static final /* synthetic */ a[] c;

            public static a[] values() {
                return (a[])c.clone();
            }

            public static a valueOf(String var0) {
                return Enum.valueOf(a.class, var0);
            }

            private static /* synthetic */ a[] a() {
                return new a[]{STAND_ALONE, INTRUSIVE};
            }

            static {
                c = a.a();
            }
        }
    }

    public static final class b
    extends Enum<b> {
        public static final /* enum */ b REFERENCE = new b();
        public static final /* enum */ b DIRECT = new b();
        private static final /* synthetic */ b[] c;

        public static b[] values() {
            return (b[])c.clone();
        }

        public static b valueOf(String var0) {
            return Enum.valueOf(b.class, var0);
        }

        private static /* synthetic */ b[] a() {
            return new b[]{REFERENCE, DIRECT};
        }

        static {
            c = b.a();
        }
    }
}

