/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ArgumentPredicateItemStack
implements Predicate<ItemStack> {
    private static final Dynamic2CommandExceptionType ERROR_STACK_TOO_BIG = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatable("arguments.item.overstacked", var0, var1));
    private final Holder<Item> item;
    @Nullable
    private final NBTTagCompound tag;

    public ArgumentPredicateItemStack(Holder<Item> var0, @Nullable NBTTagCompound var1) {
        this.item = var0;
        this.tag = var1;
    }

    public Item getItem() {
        return this.item.value();
    }

    @Override
    public boolean test(ItemStack var0) {
        return var0.is(this.item) && GameProfileSerializer.compareNbt(this.tag, var0.getTag(), true);
    }

    public ItemStack createItemStack(int var0, boolean var1) throws CommandSyntaxException {
        ItemStack var2 = new ItemStack(this.item, var0);
        if (this.tag != null) {
            var2.setTag(this.tag);
        }
        if (var1 && var0 > var2.getMaxStackSize()) {
            throw ERROR_STACK_TOO_BIG.create((Object)this.getItemName(), (Object)var2.getMaxStackSize());
        }
        return var2;
    }

    public String serialize() {
        StringBuilder var0 = new StringBuilder(this.getItemName());
        if (this.tag != null) {
            var0.append(this.tag);
        }
        return var0.toString();
    }

    private String getItemName() {
        return this.item.unwrapKey().map(ResourceKey::location).orElseGet(() -> "unknown[" + this.item + "]").toString();
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((ItemStack)object);
    }
}

