/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

public class ArgumentParserItemStack {
    private static final SimpleCommandExceptionType ERROR_NO_TAGS_ALLOWED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.item.tag.disallowed"));
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_ITEM = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("argument.item.id.invalid", var0));
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_TAG = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("arguments.item.tag.unknown", var0));
    private static final char SYNTAX_START_NBT = '{';
    private static final char SYNTAX_TAG = '#';
    private static final Function<SuggestionsBuilder, CompletableFuture<Suggestions>> SUGGEST_NOTHING = SuggestionsBuilder::buildFuture;
    private final HolderLookup<Item> items;
    private final StringReader reader;
    private final boolean allowTags;
    private Either<Holder<Item>, HolderSet<Item>> result;
    @Nullable
    private NBTTagCompound nbt;
    private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestions = SUGGEST_NOTHING;

    private ArgumentParserItemStack(HolderLookup<Item> var0, StringReader var1, boolean var2) {
        this.items = var0;
        this.reader = var1;
        this.allowTags = var2;
    }

    public static a parseForItem(HolderLookup<Item> var0, StringReader var1) throws CommandSyntaxException {
        int var2 = var1.getCursor();
        try {
            ArgumentParserItemStack var3 = new ArgumentParserItemStack(var0, var1, false);
            var3.parse();
            Holder var4 = (Holder)var3.result.left().orElseThrow(() -> new IllegalStateException("Parser returned unexpected tag name"));
            return new a(var4, var3.nbt);
        }
        catch (CommandSyntaxException var3) {
            var1.setCursor(var2);
            throw var3;
        }
    }

    public static Either<a, b> parseForTesting(HolderLookup<Item> var0, StringReader var12) throws CommandSyntaxException {
        int var2 = var12.getCursor();
        try {
            ArgumentParserItemStack var3 = new ArgumentParserItemStack(var0, var12, true);
            var3.parse();
            return var3.result.mapBoth(var1 -> new a((Holder<Item>)var1, var0.nbt), var1 -> new b((HolderSet<Item>)var1, var0.nbt));
        }
        catch (CommandSyntaxException var3) {
            var12.setCursor(var2);
            throw var3;
        }
    }

    public static CompletableFuture<Suggestions> fillSuggestions(HolderLookup<Item> var0, SuggestionsBuilder var1, boolean var2) {
        StringReader var3 = new StringReader(var1.getInput());
        var3.setCursor(var1.getStart());
        ArgumentParserItemStack var4 = new ArgumentParserItemStack(var0, var3, var2);
        try {
            var4.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return var4.suggestions.apply(var1.createOffset(var3.getCursor()));
    }

    private void readItem() throws CommandSyntaxException {
        int var0 = this.reader.getCursor();
        MinecraftKey var1 = MinecraftKey.read(this.reader);
        Optional<Holder<Item>> var2 = this.items.get(ResourceKey.create(IRegistry.ITEM_REGISTRY, var1));
        this.result = Either.left(var2.orElseThrow(() -> {
            this.reader.setCursor(var0);
            return ERROR_UNKNOWN_ITEM.createWithContext((ImmutableStringReader)this.reader, (Object)var1);
        }));
    }

    private void readTag() throws CommandSyntaxException {
        if (!this.allowTags) {
            throw ERROR_NO_TAGS_ALLOWED.createWithContext((ImmutableStringReader)this.reader);
        }
        int var0 = this.reader.getCursor();
        this.reader.expect('#');
        this.suggestions = this::suggestTag;
        MinecraftKey var1 = MinecraftKey.read(this.reader);
        Optional<HolderSet<Item>> var2 = this.items.get(TagKey.create(IRegistry.ITEM_REGISTRY, var1));
        this.result = Either.right(var2.orElseThrow(() -> {
            this.reader.setCursor(var0);
            return ERROR_UNKNOWN_TAG.createWithContext((ImmutableStringReader)this.reader, (Object)var1);
        }));
    }

    private void readNbt() throws CommandSyntaxException {
        this.nbt = new MojangsonParser(this.reader).readStruct();
    }

    private void parse() throws CommandSyntaxException {
        this.suggestions = this.allowTags ? this::suggestItemIdOrTag : this::suggestItem;
        if (this.reader.canRead() && this.reader.peek() == '#') {
            this.readTag();
        } else {
            this.readItem();
        }
        this.suggestions = this::suggestOpenNbt;
        if (this.reader.canRead() && this.reader.peek() == '{') {
            this.suggestions = SUGGEST_NOTHING;
            this.readNbt();
        }
    }

    private CompletableFuture<Suggestions> suggestOpenNbt(SuggestionsBuilder var0) {
        if (var0.getRemaining().isEmpty()) {
            var0.suggest(String.valueOf('{'));
        }
        return var0.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestTag(SuggestionsBuilder var0) {
        return ICompletionProvider.suggestResource(this.items.listTags().map(TagKey::location), var0, String.valueOf('#'));
    }

    private CompletableFuture<Suggestions> suggestItem(SuggestionsBuilder var0) {
        return ICompletionProvider.suggestResource(this.items.listElements().map(ResourceKey::location), var0);
    }

    private CompletableFuture<Suggestions> suggestItemIdOrTag(SuggestionsBuilder var0) {
        this.suggestTag(var0);
        return this.suggestItem(var0);
    }

    public record a(Holder<Item> item, @Nullable NBTTagCompound nbt) {
    }

    public record b(HolderSet<Item> tag, @Nullable NBTTagCompound nbt) {
    }
}

