/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.item.ArgumentParserItemStack;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ArgumentItemPredicate
implements ArgumentType<a> {
    private static final Collection<String> EXAMPLES = Arrays.asList("stick", "minecraft:stick", "#stick", "#stick{foo=bar}");
    private final HolderLookup<Item> items;

    public ArgumentItemPredicate(CommandBuildContext var0) {
        this.items = var0.holderLookup(IRegistry.ITEM_REGISTRY);
    }

    public static ArgumentItemPredicate itemPredicate(CommandBuildContext var0) {
        return new ArgumentItemPredicate(var0);
    }

    public a parse(StringReader var02) throws CommandSyntaxException {
        Either<ArgumentParserItemStack.a, ArgumentParserItemStack.b> var1 = ArgumentParserItemStack.parseForTesting(this.items, var02);
        return (a)var1.map(var0 -> ArgumentItemPredicate.createResult(var1 -> var1 == var0.item(), var0.nbt()), var0 -> ArgumentItemPredicate.createResult(var0.tag()::contains, var0.nbt()));
    }

    public static Predicate<ItemStack> getItemPredicate(CommandContext<CommandListenerWrapper> var0, String var1) {
        return (Predicate)var0.getArgument(var1, a.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        return ArgumentParserItemStack.fillSuggestions(this.items, var1, true);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private static a createResult(Predicate<Holder<Item>> var0, @Nullable NBTTagCompound var12) {
        return var12 != null ? var2 -> var2.is(var0) && GameProfileSerializer.compareNbt(var12, var2.getTag(), true) : var1 -> var1.is(var0);
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static interface a
    extends Predicate<ItemStack> {
    }
}

